/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.transaction;

import java.util.Map;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.meta.NonNativeObjectInfo;
import org.neodatis.odb.core.layers.layer2.meta.ObjectInfoHeader;
import org.neodatis.odb.core.transaction.ICache;
import org.neodatis.odb.core.transaction.ISession;
import org.neodatis.odb.impl.core.layers.layer3.engine.StorageEngineConstant;
import org.neodatis.odb.impl.core.layers.layer3.oid.IDStatus;
import org.neodatis.odb.impl.core.transaction.IdInfo;
import org.neodatis.odb.impl.core.transaction.ObjectInsertingInfo;
import org.neodatis.tool.wrappers.map.OdbHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cache
implements ICache {
    protected static int nbObjects = 0;
    protected static int nbOids = 0;
    protected static int nbOih = 0;
    protected static int nbTransactionOids = 0;
    protected static int nbObjectPositionByIds = 0;
    protected static int nbCallsToGetObjectInfoHeaderFromOid = 0;
    protected static int nbCallsToGetObjectInfoHeaderFromObject = 0;
    protected static int nbCallsToGetObjectWithOid = 0;
    protected Map<Object, OID> objects;
    protected Map<OID, Object> oids;
    protected Map<Object, ObjectInsertingInfo> insertingObjects;
    protected Map<OID, Object[]> readingObjectInfo;
    protected Map<OID, IdInfo> objectPositionsByIds;
    protected Map<OID, OID> unconnectedZoneOids;
    protected ISession session;
    protected String name;
    protected Map<OID, ObjectInfoHeader> objectInfoPointersCacheFromOid;
    protected boolean useCache;

    public Cache(ISession session, String name) {
        this.init(session, name);
    }

    protected void init(ISession session, String name) {
        this.name = name;
        this.session = session;
        this.objects = new OdbHashMap<Object, OID>();
        this.oids = new OdbHashMap<OID, Object>();
        this.unconnectedZoneOids = new OdbHashMap<OID, OID>();
        this.objectInfoPointersCacheFromOid = new OdbHashMap<OID, ObjectInfoHeader>();
        this.insertingObjects = new OdbHashMap<Object, ObjectInsertingInfo>();
        this.readingObjectInfo = new OdbHashMap<OID, Object[]>();
        this.objectPositionsByIds = new OdbHashMap<OID, IdInfo>();
        this.useCache = OdbConfiguration.useCache();
    }

    @Override
    public void addObject(OID oid, Object object, ObjectInfoHeader objectInfoHeader) {
        if (!this.useCache) {
            return;
        }
        if (oid == null) {
            throw new ODBRuntimeException(NeoDatisError.CACHE_NULL_OID);
        }
        if (this.checkHeaderPosition() && objectInfoHeader.getPosition() == -1L) {
            throw new ODBRuntimeException(NeoDatisError.CACHE_NEGATIVE_POSITION.addParameter("Adding OIH with position = -1"));
        }
        if ((long)this.objects.size() > OdbConfiguration.getMaxNumberOfObjectInCache()) {
            this.manageFullCache();
        }
        this.oids.put(oid, object);
        try {
            this.objects.put(object, oid);
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        this.objectInfoPointersCacheFromOid.put(oid, objectInfoHeader);
        nbObjects = this.objects.size();
        nbOids = this.oids.size();
        nbOih = this.objectInfoPointersCacheFromOid.size();
    }

    @Override
    public void addObjectInfo(ObjectInfoHeader objectInfoHeader) {
        if (!this.useCache) {
            return;
        }
        if (objectInfoHeader.getOid() == null) {
            throw new ODBRuntimeException(NeoDatisError.CACHE_NULL_OID);
        }
        if (objectInfoHeader.getClassInfoId() == null) {
            throw new ODBRuntimeException(NeoDatisError.CACHE_OBJECT_INFO_HEADER_WITHOUT_CLASS_ID.addParameter(objectInfoHeader.getOid()));
        }
        if ((long)this.objectInfoPointersCacheFromOid.size() > OdbConfiguration.getMaxNumberOfObjectInCache()) {
            this.manageFullCache();
        }
        this.objectInfoPointersCacheFromOid.put(objectInfoHeader.getOid(), objectInfoHeader);
        nbObjects = this.objects.size();
        nbOids = this.oids.size();
        nbOih = this.objectInfoPointersCacheFromOid.size();
    }

    protected void manageFullCache() {
        if (OdbConfiguration.automaticallyIncreaseCacheSize()) {
            OdbConfiguration.setMaxNumberOfObjectInCache((long)((double)OdbConfiguration.getMaxNumberOfObjectInCache() * 1.2));
        }
    }

    @Override
    public void startInsertingObjectWithOid(Object object, OID oid, NonNativeObjectInfo nnoi) {
        if (object == null) {
            return;
        }
        ObjectInsertingInfo oii = this.insertingObjects.get(object);
        if (oii == null) {
            this.insertingObjects.put(object, new ObjectInsertingInfo(oid, 1));
        } else {
            ++oii.level;
        }
    }

    @Override
    public void updateIdOfInsertingObject(Object object, OID oid) {
        if (oid == null) {
            throw new ODBRuntimeException(NeoDatisError.CACHE_NULL_OID);
        }
        ObjectInsertingInfo oii = this.insertingObjects.get(object);
        if (oii != null) {
            oii.oid = oid;
        }
    }

    @Override
    public void endInsertingObject(Object object) {
        ObjectInsertingInfo oii = this.insertingObjects.get(object);
        if (oii.level == 1) {
            this.insertingObjects.remove(object);
            oii = null;
        } else {
            --oii.level;
        }
    }

    @Override
    public void removeObjectWithOid(OID oid) {
        if (oid == null) {
            throw new ODBRuntimeException(NeoDatisError.CACHE_NULL_OID);
        }
        Object object = this.oids.get(oid);
        this.oids.remove(oid);
        try {
            this.objects.remove(object);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.objectInfoPointersCacheFromOid.remove(oid);
        this.unconnectedZoneOids.remove(oid);
        nbObjects = this.objects.size();
        nbOids = this.oids.size();
        nbOih = this.objectInfoPointersCacheFromOid.size();
    }

    @Override
    public void removeObject(Object object) {
        if (object == null) {
            throw new ODBRuntimeException(NeoDatisError.CACHE_NULL_OBJECT.addParameter(" while removing object from the cache"));
        }
        OID oid = this.objects.get(object);
        this.oids.remove(oid);
        try {
            this.objects.remove(object);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.objectInfoPointersCacheFromOid.remove(oid);
        this.unconnectedZoneOids.remove(oid);
        nbObjects = this.objects.size();
        nbOids = this.oids.size();
        nbOih = this.objectInfoPointersCacheFromOid.size();
    }

    @Override
    public boolean existObject(Object object) {
        return this.objects.containsKey(object);
    }

    @Override
    public Object getObjectWithOid(OID oid) {
        if (oid == null) {
            throw new ODBRuntimeException(NeoDatisError.CACHE_NULL_OID.addParameter(oid));
        }
        Object o = this.oids.get(oid);
        ++nbCallsToGetObjectWithOid;
        return o;
    }

    @Override
    public ObjectInfoHeader getObjectInfoHeaderFromObject(Object object, boolean throwExceptionIfNotFound) {
        OID oid = this.objects.get(object);
        ObjectInfoHeader oih = this.objectInfoPointersCacheFromOid.get(oid);
        if (oih == null && throwExceptionIfNotFound) {
            throw new ODBRuntimeException(NeoDatisError.OBJECT_DOES_NOT_EXIST_IN_CACHE.addParameter(object.toString()));
        }
        ++nbCallsToGetObjectInfoHeaderFromObject;
        return oih;
    }

    @Override
    public ObjectInfoHeader getObjectInfoHeaderFromOid(OID oid, boolean throwExceptionIfNotFound) {
        if (oid == null) {
            throw new ODBRuntimeException(NeoDatisError.CACHE_NULL_OID);
        }
        ObjectInfoHeader oih = this.objectInfoPointersCacheFromOid.get(oid);
        if (oih == null && throwExceptionIfNotFound) {
            throw new ODBRuntimeException(NeoDatisError.OBJECT_WITH_OID_DOES_NOT_EXIST_IN_CACHE.addParameter(oid));
        }
        ++nbCallsToGetObjectInfoHeaderFromOid;
        return oih;
    }

    @Override
    public OID getOid(Object object, boolean throwExceptionIfNotFound) {
        OID oid = this.objects.get(object);
        if (oid != null) {
            return oid;
        }
        if (throwExceptionIfNotFound) {
            throw new ODBRuntimeException(NeoDatisError.OBJECT_DOES_NOT_EXIST_IN_CACHE);
        }
        return StorageEngineConstant.NULL_OBJECT_ID;
    }

    @Override
    public void savePositionOfObjectWithOid(OID oid, long objectPosition) {
        if (oid == null) {
            throw new ODBRuntimeException(NeoDatisError.CACHE_NULL_OID);
        }
        IdInfo idInfo = new IdInfo(oid, objectPosition, 1);
        this.objectPositionsByIds.put(oid, idInfo);
        nbObjects = this.objects.size();
        nbOids = this.oids.size();
        nbOih = this.objectInfoPointersCacheFromOid.size();
    }

    @Override
    public void markIdAsDeleted(OID oid) {
        if (oid == null) {
            throw new ODBRuntimeException(NeoDatisError.CACHE_NULL_OID);
        }
        IdInfo idInfo = this.objectPositionsByIds.get(oid);
        if (idInfo != null) {
            idInfo.status = (byte)2;
        } else {
            idInfo = new IdInfo(oid, -1L, 2);
            this.objectPositionsByIds.put(oid, idInfo);
        }
    }

    @Override
    public boolean isDeleted(OID oid) {
        if (oid == null) {
            throw new ODBRuntimeException(NeoDatisError.CACHE_NULL_OID);
        }
        IdInfo idInfo = this.objectPositionsByIds.get(oid);
        if (idInfo != null) {
            return idInfo.status == 2;
        }
        return false;
    }

    @Override
    public long getObjectPositionByOid(OID oid) {
        if (oid == null) {
            return 0L;
        }
        IdInfo idInfo = this.objectPositionsByIds.get(oid);
        if (idInfo != null) {
            if (!IDStatus.isActive(idInfo.status)) {
                return 0L;
            }
            return idInfo.position;
        }
        return -1L;
    }

    @Override
    public void clearOnCommit() {
        this.objectPositionsByIds.clear();
        this.unconnectedZoneOids.clear();
        this.objectInfoPointersCacheFromOid.clear();
    }

    @Override
    public void clear(boolean setToNull) {
        if (this.objects != null) {
            this.objects.clear();
            this.oids.clear();
            this.objectInfoPointersCacheFromOid.clear();
            this.insertingObjects.clear();
            this.objectPositionsByIds.clear();
            this.readingObjectInfo.clear();
            this.unconnectedZoneOids.clear();
        }
        if (setToNull) {
            this.objects = null;
            this.oids = null;
            this.objectInfoPointersCacheFromOid = null;
            this.insertingObjects = null;
            this.objectPositionsByIds = null;
            this.readingObjectInfo = null;
            this.unconnectedZoneOids = null;
        }
    }

    @Override
    public void clearInsertingObjects() {
        this.insertingObjects.clear();
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("C=");
        buffer.append(this.objects.size()).append(" objects ");
        buffer.append(this.oids.size()).append(" oids ");
        buffer.append(this.objectInfoPointersCacheFromOid.size()).append(" pointers");
        buffer.append(this.objectPositionsByIds.size()).append(" pos by oid");
        return buffer.toString();
    }

    @Override
    public String toCompleteString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.objects.size()).append(" Objects=").append(this.objects).append("\n");
        buffer.append(this.oids.size()).append(" Objects from pos").append(this.oids).append("\n");
        buffer.append(this.objectInfoPointersCacheFromOid.size()).append(" Pointers=").append(this.objectInfoPointersCacheFromOid);
        return buffer.toString();
    }

    @Override
    public int getNumberOfObjects() {
        return this.objects.size();
    }

    @Override
    public int getNumberOfObjectHeader() {
        return this.objectInfoPointersCacheFromOid.size();
    }

    @Override
    public OID idOfInsertingObject(Object object) {
        if (object == null) {
            return StorageEngineConstant.NULL_OBJECT_ID;
        }
        ObjectInsertingInfo oii = this.insertingObjects.get(object);
        if (oii != null) {
            return oii.oid;
        }
        return StorageEngineConstant.NULL_OBJECT_ID;
    }

    @Override
    public int insertingLevelOf(Object object) {
        ObjectInsertingInfo oii = this.insertingObjects.get(object);
        if (oii == null) {
            return 0;
        }
        return oii.level;
    }

    @Override
    public boolean isReadingObjectInfoWithOid(OID oid) {
        if (oid == null) {
            return false;
        }
        return this.readingObjectInfo.get(oid) != null;
    }

    @Override
    public NonNativeObjectInfo getReadingObjectInfoFromOid(OID oid) {
        if (oid == null) {
            throw new ODBRuntimeException(NeoDatisError.CACHE_NULL_OID);
        }
        Object[] values = this.readingObjectInfo.get(oid);
        if (values == null) {
            return null;
        }
        return (NonNativeObjectInfo)values[1];
    }

    @Override
    public void startReadingObjectInfoWithOid(OID oid, NonNativeObjectInfo objectInfo) {
        if (oid == null) {
            throw new ODBRuntimeException(NeoDatisError.CACHE_NULL_OID);
        }
        Object[] objects = this.readingObjectInfo.get(oid);
        if (objects == null) {
            Object[] values = new Object[]{new Short(1), objectInfo};
            this.readingObjectInfo.put(oid, values);
        } else {
            short currentReadCount = (Short)objects[0];
            objects[0] = new Short((short)(currentReadCount + 1));
        }
    }

    @Override
    public void endReadingObjectInfo(OID oid) {
        if (oid == null) {
            throw new ODBRuntimeException(NeoDatisError.CACHE_NULL_OID.addParameter(oid));
        }
        Object[] values = this.readingObjectInfo.get(oid);
        if (values == null || values[0] == null) {
            throw new ODBRuntimeException(NeoDatisError.OBJECT_INFO_NOT_IN_TEMP_CACHE.addParameter(oid).addParameter("?"));
        }
        short readCount = (Short)values[0];
        if (readCount == 1) {
            this.readingObjectInfo.remove(oid);
        } else {
            values[0] = new Short((short)(readCount - 1));
        }
    }

    @Override
    public Map<OID, Object> getOids() {
        return this.oids;
    }

    public void setOids(Map<OID, Object> oids) {
        this.oids = oids;
    }

    @Override
    public Map<OID, ObjectInfoHeader> getObjectInfoPointersCacheFromOid() {
        return this.objectInfoPointersCacheFromOid;
    }

    public void setObjectInfoPointersCacheFromOid(Map<OID, ObjectInfoHeader> objectInfoPointersCacheFromOid) {
        this.objectInfoPointersCacheFromOid = objectInfoPointersCacheFromOid;
    }

    @Override
    public Map<Object, OID> getObjects() {
        return this.objects;
    }

    public void setObjects(Map<Object, OID> objects) {
        this.objects = objects;
    }

    @Override
    public boolean objectWithIdIsInCommitedZone(OID oid) {
        return !this.unconnectedZoneOids.containsKey(oid);
    }

    @Override
    public void addOIDToUnconnectedZone(OID oid) {
        if (!this.useCache) {
            return;
        }
        this.unconnectedZoneOids.put(oid, oid);
    }

    public static String usage() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("NbObj=").append(nbObjects);
        buffer.append(" - NbOIDs=").append(nbOids);
        buffer.append(" - NbObjPos=").append(nbObjectPositionByIds);
        buffer.append(" - NbOIHs=").append(nbOih);
        buffer.append(" - NbTransOIDs=").append(nbTransactionOids);
        buffer.append(" - Calls2getObjectWitOid=").append(nbCallsToGetObjectWithOid);
        buffer.append(" - Calls2getObjectInfoHeaderFromOid=").append(nbCallsToGetObjectInfoHeaderFromOid);
        buffer.append(" - Calls2getObjectInfoHeaderFromObject=").append(nbCallsToGetObjectInfoHeaderFromObject);
        return buffer.toString();
    }

    protected boolean checkHeaderPosition() {
        return false;
    }
}

