/*
 * Decompiled with CFR 0.152.
 */
package org.neodatis.odb.impl.core.transaction;

import java.io.IOException;
import java.util.Iterator;
import org.neodatis.odb.ODBRuntimeException;
import org.neodatis.odb.OID;
import org.neodatis.odb.OdbConfiguration;
import org.neodatis.odb.core.ICoreProvider;
import org.neodatis.odb.core.NeoDatisError;
import org.neodatis.odb.core.layers.layer2.meta.CIZoneInfo;
import org.neodatis.odb.core.layers.layer2.meta.ClassInfo;
import org.neodatis.odb.core.layers.layer2.meta.MetaModel;
import org.neodatis.odb.core.layers.layer2.meta.ODBType;
import org.neodatis.odb.core.layers.layer2.meta.SessionMetaModel;
import org.neodatis.odb.core.layers.layer3.IBaseIdentification;
import org.neodatis.odb.core.layers.layer3.ICommitListener;
import org.neodatis.odb.core.layers.layer3.IOFileParameter;
import org.neodatis.odb.core.layers.layer3.IOSocketParameter;
import org.neodatis.odb.core.layers.layer3.IObjectWriter;
import org.neodatis.odb.core.layers.layer3.engine.IFileSystemInterface;
import org.neodatis.odb.core.transaction.ISession;
import org.neodatis.odb.core.transaction.ITransaction;
import org.neodatis.odb.core.transaction.IWriteAction;
import org.neodatis.odb.impl.core.layers.layer3.engine.LocalFileSystemInterface;
import org.neodatis.odb.impl.core.transaction.DefaultWriteAction;
import org.neodatis.tool.DLogger;
import org.neodatis.tool.wrappers.OdbTime;
import org.neodatis.tool.wrappers.io.OdbFile;
import org.neodatis.tool.wrappers.list.IOdbList;
import org.neodatis.tool.wrappers.list.OdbArrayList;
import org.neodatis.tool.wrappers.map.OdbHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTransaction
implements ITransaction {
    public static final String LOG_ID = "Transaction";
    private boolean isCommited;
    private long creationDateTime;
    private IOdbList<IWriteAction> writeActions;
    public IWriteAction currentWriteAction;
    public long currentWritePositionInWA;
    private boolean hasAllWriteActionsInMemory;
    public int numberOfWriteActions;
    public IFileSystemInterface fsi;
    private IFileSystemInterface fsiToApplyWriteActions;
    private boolean hasBeenPersisted;
    private boolean archiveLog;
    private boolean wasRollbacked;
    private String overrideTransactionName;
    private boolean readOnlyMode;
    public ISession session;
    private boolean isLocal;
    private ICoreProvider provider;

    public DefaultTransaction(ISession session) throws IOException {
        this.init(session);
    }

    public DefaultTransaction(ISession session, String overrideTransactionName) throws IOException {
        this.overrideTransactionName = overrideTransactionName;
        this.init(session);
        this.readOnlyMode = true;
    }

    public DefaultTransaction(ISession session, IFileSystemInterface fsiToApplyTransaction) {
        this.fsiToApplyWriteActions = fsiToApplyTransaction;
        this.init(session);
        this.readOnlyMode = false;
    }

    public void init(ISession session) {
        this.provider = OdbConfiguration.getCoreProvider();
        this.session = session;
        this.isCommited = false;
        this.creationDateTime = OdbTime.getCurrentTimeInMs();
        this.writeActions = new OdbArrayList<IWriteAction>(1000);
        this.hasAllWriteActionsInMemory = true;
        this.numberOfWriteActions = 0;
        this.hasBeenPersisted = false;
        this.wasRollbacked = false;
        this.currentWritePositionInWA = -1L;
    }

    @Override
    public void clear() {
        if (this.writeActions != null) {
            this.writeActions.clear();
            this.writeActions = null;
        }
    }

    @Override
    public void reset() {
        this.clear();
        this.init(this.session);
        this.fsi = null;
    }

    public void addWriteAction(IWriteAction writeAction) {
        this.addWriteAction(writeAction, true);
    }

    public void addWriteAction(IWriteAction writeAction, boolean persistWriteAcion) {
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.info("Adding WA in Transaction of session " + this.session.getId());
        }
        if (writeAction.isEmpty()) {
            return;
        }
        this.checkRollback();
        if (!this.hasBeenPersisted && persistWriteAcion) {
            this.persist();
        }
        if (persistWriteAcion) {
            writeAction.persist(this.fsi, this.numberOfWriteActions + 1);
        }
        if (this.hasAllWriteActionsInMemory) {
            this.writeActions.add(writeAction);
        }
        ++this.numberOfWriteActions;
        if (this.hasAllWriteActionsInMemory && this.numberOfWriteActions > OdbConfiguration.getMaxNumberOfWriteObjectPerTransaction()) {
            this.hasAllWriteActionsInMemory = false;
            Iterator iterator = this.writeActions.iterator();
            DefaultWriteAction wa = null;
            while (iterator.hasNext()) {
                wa = (DefaultWriteAction)iterator.next();
                wa.clear();
            }
            this.writeActions.clear();
            if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
                DLogger.info("Number of objects has exceeded the max number " + this.numberOfWriteActions + "/" + OdbConfiguration.getMaxNumberOfWriteObjectPerTransaction() + ": switching to persistent transaction managment");
            }
        }
    }

    @Override
    public String getName() {
        IBaseIdentification p = this.fsiToApplyWriteActions.getParameters();
        if (p instanceof IOFileParameter) {
            IOFileParameter ifp = (IOFileParameter)this.fsiToApplyWriteActions.getParameters();
            StringBuffer buffer = new StringBuffer(ifp.getCleanFileName()).append("-").append(this.creationDateTime).append("-").append(this.session.getId()).append(".transaction");
            return buffer.toString();
        }
        if (p instanceof IOSocketParameter) {
            IOSocketParameter sp = (IOSocketParameter)this.fsiToApplyWriteActions.getParameters();
            return sp.getBaseIdentifier();
        }
        throw new ODBRuntimeException(NeoDatisError.UNSUPPORTED_IO_TYPE.addParameter(p.getClass().getName()));
    }

    IBaseIdentification getParameters(boolean canWrite) {
        IBaseIdentification p = this.fsiToApplyWriteActions.getParameters();
        if (p instanceof IOFileParameter) {
            IOFileParameter ifp = (IOFileParameter)this.fsiToApplyWriteActions.getParameters();
            StringBuffer buffer = new StringBuffer(ifp.getDirectory()).append("/").append(ifp.getCleanFileName()).append("-").append(this.creationDateTime).append("-").append(this.session.getId()).append(".transaction");
            return new IOFileParameter(buffer.toString(), canWrite, ifp.getUserName(), ifp.getPassword());
        }
        if (p instanceof IOSocketParameter) {
            IOSocketParameter sp = (IOSocketParameter)this.fsiToApplyWriteActions.getParameters();
            return new IOSocketParameter(sp.getDestinationHost(), sp.getPort(), sp.getBaseIdentifier(), 2, this.creationDateTime, null, null);
        }
        throw new ODBRuntimeException(NeoDatisError.UNSUPPORTED_IO_TYPE.addParameter(p.getClass().getName()));
    }

    private void checkFileAccess(boolean canWrite) {
        this.checkFileAccess(canWrite, null);
    }

    private synchronized void checkFileAccess(boolean canWrite, String fileName) {
        if (this.fsi == null) {
            IBaseIdentification p = null;
            p = this.fsiToApplyWriteActions == null ? new IOFileParameter(fileName, canWrite, null, null) : this.getParameters(canWrite);
            if (this.session != null) {
                this.isLocal = this.session.getStorageEngine().isLocal();
            }
            this.fsi = new LocalFileSystemInterface("transaction", this.session, p, false, OdbConfiguration.getDefaultBufferSizeForTransaction());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void persist() {
        this.checkFileAccess(true);
        try {
            if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
                DLogger.debug("# Persisting transaction " + this.getName());
            }
            this.fsi.setWritePosition(0L, false);
            this.fsi.writeBoolean(this.isCommited, false);
            this.fsi.writeLong(this.creationDateTime, false, "creation date", 3);
            this.fsi.writeLong(0L, false, "size", 3);
            this.hasBeenPersisted = true;
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            throw throwable;
        }
    }

    public IOdbList<IWriteAction> getWriteActions() {
        return this.writeActions;
    }

    public long getCreationDateTime() {
        return this.creationDateTime;
    }

    @Override
    public boolean isCommited() {
        return this.isCommited;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCommited(boolean isConfirmed) {
        this.isCommited = isConfirmed;
        this.checkFileAccess(true);
        try {
            this.fsi.setWritePositionNoVerification(ODBType.BYTE.getSize() + ODBType.LONG.getSize(), false);
            this.fsi.writeLong(this.numberOfWriteActions, false, "nb write actions", 3);
            this.fsi.flush();
            if (this.isLocal) {
                this.fsi.useBuffer(false);
            }
            this.fsi.setWritePositionNoVerification(0L, false);
            this.fsi.writeByte((byte)1, false);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            throw throwable;
        }
    }

    private void checkRollback() {
        if (this.wasRollbacked) {
            throw new ODBRuntimeException(NeoDatisError.ODB_HAS_BEEN_ROLLBACKED);
        }
    }

    @Override
    public void rollback() {
        this.wasRollbacked = true;
        if (this.fsi != null) {
            this.fsi.close();
            this.delete();
        }
    }

    @Override
    public void commit() {
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.info("Commiting " + this.numberOfWriteActions + " write actions - In Memory : " + this.hasAllWriteActionsInMemory + " - sid=" + this.session.getId());
        }
        this.checkRollback();
        this.manageCommitListenersBefore();
        if (this.currentWriteAction != null && !this.currentWriteAction.isEmpty()) {
            this.addWriteAction(this.currentWriteAction);
            this.currentWriteAction = null;
        }
        if (this.fsi == null && this.numberOfWriteActions != 0) {
            throw new ODBRuntimeException(NeoDatisError.TRANSACTION_ALREADY_COMMITED_OR_ROLLBACKED);
        }
        if (this.numberOfWriteActions == 0 || this.readOnlyMode) {
            this.commitMetaModel();
            if (this.fsi != null) {
                this.fsi.close();
                this.fsi = null;
            }
            if (this.session != null) {
                this.session.getCache().clearOnCommit();
            }
            return;
        }
        this.setCommited(true);
        this.applyTo();
        this.commitMetaModel();
        if (this.archiveLog) {
            this.fsi.setWritePositionNoVerification(0L, false);
            this.fsi.writeByte((byte)2, false);
            this.fsi.getIo().enableAutomaticDelete(false);
            this.fsi.close();
            this.fsi = null;
        } else {
            this.fsi.close();
            this.delete();
            this.fsi = null;
        }
        if (this.session != null) {
            this.session.getCache().clearOnCommit();
        }
        this.manageCommitListenersAfter();
    }

    private void manageCommitListenersAfter() {
        IOdbList<ICommitListener> listeners = this.session.getStorageEngine().getCommitListeners();
        if (listeners == null || listeners.isEmpty()) {
            return;
        }
        Iterator iterator = listeners.iterator();
        ICommitListener commitListener = null;
        while (iterator.hasNext()) {
            commitListener = (ICommitListener)iterator.next();
            commitListener.afterCommit();
        }
    }

    private void manageCommitListenersBefore() {
        IOdbList<ICommitListener> listeners = this.session.getStorageEngine().getCommitListeners();
        if (listeners == null || listeners.isEmpty()) {
            return;
        }
        Iterator iterator = listeners.iterator();
        ICommitListener commitListener = null;
        while (iterator.hasNext()) {
            commitListener = (ICommitListener)iterator.next();
            commitListener.beforeCommit();
        }
    }

    protected void commitMetaModel() {
        MetaModel sessionMetaModel = this.session.getMetaModel();
        if (!sessionMetaModel.hasChanged()) {
            return;
        }
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug("Start commitMetaModel");
        }
        MetaModel lastCommitedMetaModel = new SessionMetaModel();
        lastCommitedMetaModel = this.isLocal ? sessionMetaModel : this.session.getStorageEngine().getObjectReader().readMetaModel(lastCommitedMetaModel, false);
        Iterator<ClassInfo> cis = sessionMetaModel.getChangedClassInfo().iterator();
        ClassInfo newCi = null;
        ClassInfo lastCommittedCI = null;
        IObjectWriter writer = this.session.getStorageEngine().getObjectWriter();
        OID lastCommittedObjectOIDOfThisTransaction = null;
        OID lastCommittedObjectOIDOfPrevTransaction = null;
        while (cis.hasNext()) {
            newCi = cis.next();
            if (lastCommitedMetaModel.existClass(newCi.getFullClassName())) {
                lastCommittedCI = lastCommitedMetaModel.getClassInfoFromId(newCi.getId());
                lastCommittedCI.getCommitedZoneInfo().setNbDeletedObjects(newCi.getCommitedZoneInfo().getNbDeletedObjects());
            } else {
                lastCommittedCI = newCi;
            }
            lastCommittedObjectOIDOfThisTransaction = newCi.getCommitedZoneInfo().last;
            OID lastCommittedObjectOID = lastCommittedObjectOIDOfPrevTransaction = lastCommittedCI.getCommitedZoneInfo().last;
            if (lastCommittedObjectOIDOfPrevTransaction != null && this.session.getCache().isDeleted(lastCommittedObjectOIDOfPrevTransaction)) {
                newCi.getCommitedZoneInfo().last = lastCommittedObjectOID = lastCommittedObjectOIDOfThisTransaction;
            }
            if (lastCommittedObjectOID != null && newCi.getUncommittedZoneInfo().hasObjects()) {
                if (newCi.getCommitedZoneInfo().hasObjects()) {
                    writer.updateNextObjectFieldOfObjectInfo(lastCommittedObjectOID, newCi.getUncommittedZoneInfo().first, false);
                    writer.updatePreviousObjectFieldOfObjectInfo(newCi.getUncommittedZoneInfo().first, lastCommittedObjectOID, false);
                } else {
                    writer.updatePreviousObjectFieldOfObjectInfo(newCi.getUncommittedZoneInfo().first, null, false);
                }
            }
            newCi.getCommitedZoneInfo().setNbObjects(lastCommittedCI.getCommitedZoneInfo());
            newCi = this.buildClassInfoForCommit(newCi);
            writer.updateInstanceFieldsOfClassInfo(newCi, false);
            if (!OdbConfiguration.isDebugEnabled(LOG_ID)) continue;
            DLogger.debug("Analysing class " + newCi.getFullClassName());
            DLogger.debug("\t-Commited CI   = " + newCi);
            DLogger.debug("\t-connect last commited object with oid " + lastCommittedObjectOID + " to first uncommited object " + newCi.getUncommittedZoneInfo().first);
            DLogger.debug("\t-Commiting new Number of objects = " + newCi.getNumberOfObjects());
        }
        sessionMetaModel.resetChangedClasses();
        if (!this.isLocal) {
            this.session.setMetaModel(null);
        }
    }

    public ClassInfo buildClassInfoForCommit(ClassInfo classInfo) {
        long nbObjects = classInfo.getNumberOfObjects();
        classInfo.getCommitedZoneInfo().setNbObjects(nbObjects);
        if (classInfo.getCommitedZoneInfo().first == null) {
            classInfo.getCommitedZoneInfo().first = classInfo.getUncommittedZoneInfo().first;
        }
        if (classInfo.getUncommittedZoneInfo().last != null) {
            classInfo.getCommitedZoneInfo().last = classInfo.getUncommittedZoneInfo().last;
        }
        classInfo.getUncommittedZoneInfo().set(new CIZoneInfo(classInfo, null, null, 0L));
        return classInfo;
    }

    public static DefaultTransaction read(String fileName) throws IOException, ClassNotFoundException {
        OdbFile file = new OdbFile(fileName);
        if (!file.exists()) {
            throw new ODBRuntimeException(NeoDatisError.FILE_NOT_FOUND.addParameter(fileName));
        }
        DefaultTransaction transaction = new DefaultTransaction(null, fileName);
        transaction.loadWriteActions(fileName, false);
        return transaction;
    }

    public void loadWriteActions(boolean apply) {
        this.loadWriteActions(this.getName(), apply);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadWriteActions(String filename, boolean apply) {
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug("Load write actions of " + filename);
        }
        DefaultWriteAction wa = null;
        try {
            this.checkFileAccess(false, filename);
            this.fsi.useBuffer(true);
            this.fsi.setReadPosition(0L);
            this.isCommited = this.fsi.readByte() == 1;
            this.creationDateTime = this.fsi.readLong();
            long totalNumberOfWriteActions = this.fsi.readLong();
            if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
                DLogger.info(this.writeActions.size() + " write actions in file");
            }
            int i = 0;
            while ((long)i < totalNumberOfWriteActions) {
                wa = DefaultWriteAction.read(this.fsi, i + 1);
                if (apply) {
                    wa.applyTo(this.fsiToApplyWriteActions, i + 1);
                    wa.clear();
                } else {
                    this.addWriteAction(wa, false);
                }
                ++i;
            }
            if (apply) {
                this.fsiToApplyWriteActions.flush();
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadWriteActionsBackwards(String filename, boolean apply) throws IOException, ClassNotFoundException {
        int executedWriteAction = 0;
        if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
            DLogger.debug("Load write actions of " + filename);
        }
        DefaultWriteAction wa = null;
        try {
            this.checkFileAccess(false, filename);
            this.fsi.useBuffer(true);
            this.fsi.setReadPosition(0L);
            this.isCommited = this.fsi.readByte() == 1;
            this.creationDateTime = this.fsi.readLong();
            OdbHashMap<Long, Long> writtenPositions = null;
            if (apply) {
                writtenPositions = new OdbHashMap<Long, Long>();
            }
            Long position = new Long(-1L);
            int i = this.numberOfWriteActions;
            long previousWriteActionPosition = this.fsi.getLength();
            while (i > 0) {
                this.fsi.setReadPosition(previousWriteActionPosition - (long)ODBType.LONG.getSize());
                previousWriteActionPosition = this.fsi.readLong();
                this.fsi.setReadPosition(previousWriteActionPosition);
                wa = DefaultWriteAction.read(this.fsi, i + 1);
                if (apply) {
                    position = new Long(wa.getPosition());
                    if (writtenPositions.get(position) != null) {
                        --i;
                        continue;
                    }
                    wa.applyTo(this.fsiToApplyWriteActions, i + 1);
                    writtenPositions.put(position, position);
                    ++executedWriteAction;
                } else {
                    this.addWriteAction(wa, false);
                }
                --i;
            }
            if (apply) {
                this.fsiToApplyWriteActions.flush();
                if (OdbConfiguration.isDebugEnabled(LOG_ID)) {
                    DLogger.debug("Total Write actions : " + i + " / position cache = " + writtenPositions.size());
                }
                DLogger.info("Total write actions = " + this.numberOfWriteActions + " : executed = " + executedWriteAction);
                writtenPositions.clear();
                writtenPositions = null;
            }
            Object var11_9 = null;
        }
        catch (Throwable throwable) {
            Object var11_10 = null;
            throw throwable;
        }
    }

    protected void delete() {
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("state=").append(this.isCommited).append(" | creation=").append(this.creationDateTime).append(" | write actions numbers=").append(this.numberOfWriteActions);
        return buffer.toString();
    }

    private void applyTo() {
        boolean realWriteNumber = false;
        boolean noPointerWA = false;
        if (!this.isCommited) {
            DLogger.info("can not execute a transaction that is not confirmed");
            return;
        }
        if (this.hasAllWriteActionsInMemory) {
            for (int i = 0; i < this.writeActions.size(); ++i) {
                DefaultWriteAction wa = (DefaultWriteAction)this.writeActions.get(i);
                wa.applyTo(this.fsiToApplyWriteActions, i + 1);
                wa.clear();
            }
            this.fsiToApplyWriteActions.flush();
        } else {
            this.loadWriteActions(true);
            this.fsiToApplyWriteActions.flush();
        }
    }

    @Override
    public void setFsiToApplyWriteActions(IFileSystemInterface fsi) {
        this.fsiToApplyWriteActions = fsi;
    }

    @Override
    public boolean isArchiveLog() {
        return this.archiveLog;
    }

    @Override
    public void setArchiveLog(boolean archiveLog) {
        this.archiveLog = archiveLog;
    }

    @Override
    public int getNumberOfWriteActions() {
        if (this.currentWriteAction != null && !this.currentWriteAction.isEmpty()) {
            return this.numberOfWriteActions + 1;
        }
        return this.numberOfWriteActions;
    }

    public IFileSystemInterface getFsi() throws IOException {
        if (this.fsi == null) {
            this.checkFileAccess(!this.readOnlyMode);
        }
        return this.fsi;
    }

    @Override
    public void setWritePosition(long position) {
        if (position != this.currentWritePositionInWA) {
            this.currentWritePositionInWA = position;
            if (this.currentWriteAction != null) {
                this.addWriteAction(this.currentWriteAction);
            }
            this.currentWriteAction = new DefaultWriteAction(position);
        } else if (this.currentWriteAction == null) {
            this.currentWriteAction = new DefaultWriteAction(position);
            this.currentWritePositionInWA = position;
        }
    }

    @Override
    public void manageWriteAction(long position, byte[] bytes) {
        if (this.currentWritePositionInWA == position) {
            if (this.currentWriteAction == null) {
                this.currentWriteAction = this.provider.getWriteAction(position, null);
            }
            this.currentWriteAction.addBytes(bytes);
            this.currentWritePositionInWA += (long)bytes.length;
        } else {
            if (this.currentWriteAction != null) {
                this.addWriteAction(this.currentWriteAction);
            }
            this.currentWriteAction = this.provider.getWriteAction(position, bytes);
            this.currentWritePositionInWA = position + (long)bytes.length;
        }
    }
}

