/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.rewrite.annotation.scan;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.LinkedHashSet;
import java.util.Set;
import org.ocpsoft.logging.Logger;

public class ByteCodeFilter {
    private static final Logger log = Logger.getLogger(ByteCodeFilter.class);
    private static final int CLASS_FILE_MAGIC = -889275714;
    private static final int CONSTANT_Class = 7;
    private static final int CONSTANT_Fieldref = 9;
    private static final int CONSTANT_Methodref = 10;
    private static final int CONSTANT_InterfaceMethodref = 11;
    private static final int CONSTANT_String = 8;
    private static final int CONSTANT_Integer = 3;
    private static final int CONSTANT_Float = 4;
    private static final int CONSTANT_Long = 5;
    private static final int CONSTANT_Double = 6;
    private static final int CONSTANT_NameAndType = 12;
    private static final int CONSTANT_Utf8 = 1;
    private static final int CONSTANT_MethodHandle = 15;
    private static final int CONSTANT_MethodType = 16;
    private static final int CONSTANT_InvokeDynamic = 18;
    private final Set<String> fieldDescriptors = new LinkedHashSet<String>();

    public ByteCodeFilter(Set<Class<? extends Annotation>> types) {
        for (Class<? extends Annotation> type : types) {
            this.fieldDescriptors.add("L" + type.getName().replace('.', '/'));
        }
    }

    public boolean accept(InputStream classFileStream) throws IOException {
        DataInputStream in = new DataInputStream(classFileStream);
        int magic = in.readInt();
        if (magic != -889275714) {
            if (log.isDebugEnabled()) {
                log.debug("Magic not found! Not a valid class file!");
            }
            return false;
        }
        int minor = in.readUnsignedShort();
        int major = in.readUnsignedShort();
        if (major < 49) {
            if (log.isTraceEnabled()) {
                log.trace("Not a JDK5 class! It cannot contain annotations!");
            }
            return false;
        }
        int constantPoolEntries = in.readUnsignedShort() - 1;
        block12: for (int i = 0; i < constantPoolEntries; ++i) {
            int tag = in.readUnsignedByte();
            switch (tag) {
                case 7: {
                    in.readUnsignedShort();
                    continue block12;
                }
                case 9: 
                case 10: 
                case 11: {
                    in.readUnsignedShort();
                    in.readUnsignedShort();
                    continue block12;
                }
                case 8: {
                    in.readUnsignedShort();
                    continue block12;
                }
                case 3: 
                case 4: {
                    in.readInt();
                    continue block12;
                }
                case 5: 
                case 6: {
                    in.readLong();
                    ++i;
                    continue block12;
                }
                case 12: {
                    in.readUnsignedShort();
                    in.readUnsignedShort();
                    continue block12;
                }
                case 1: {
                    String str = in.readUTF();
                    if (!this.containsFieldDescriptor(str)) continue block12;
                    if (log.isTraceEnabled()) {
                        log.trace("Found interesting annotation reference in constant pool: " + str);
                    }
                    return true;
                }
                case 15: {
                    in.readByte();
                    in.readShort();
                    continue block12;
                }
                case 16: {
                    in.readShort();
                    continue block12;
                }
                case 18: {
                    in.readShort();
                    in.readShort();
                    continue block12;
                }
                default: {
                    if (log.isDebugEnabled()) {
                        log.debug("Unknown constant pool tag found: " + tag);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private boolean containsFieldDescriptor(String str) {
        for (String descriptor : this.fieldDescriptors) {
            if (!str.contains(descriptor)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "ByteCodeFilter [fieldDescriptors=" + this.fieldDescriptors + "]";
    }
}

