/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.urlbuilder;

import java.util.Arrays;
import java.util.List;

class Parameter {
    private final CharSequence name;
    private final List<Object> values;

    private Parameter(CharSequence name, List<Object> values) {
        this.name = name;
        this.values = values;
    }

    public static Parameter create(CharSequence name, List<Object> values) {
        return new Parameter(name, values);
    }

    public static Parameter create(CharSequence name, Object ... values) {
        return new Parameter(name, Arrays.asList(values));
    }

    public CharSequence getName() {
        return this.name;
    }

    public boolean hasValues() {
        return !this.values.isEmpty();
    }

    public int getValueCount() {
        return this.values.size();
    }

    public String getValue(int index) {
        Object value = this.values.get(index);
        return value == null ? null : value.toString();
    }

    public List<Object> getValues() {
        return this.values;
    }
}

