/*
 * Decompiled with CFR 0.152.
 */
package org.ocpsoft.urlbuilder.util;

import org.ocpsoft.urlbuilder.util.Assert;
import org.ocpsoft.urlbuilder.util.CaptureType;
import org.ocpsoft.urlbuilder.util.CapturingGroup;

public abstract class ParseTools {
    private static final char ESCAPE_CHAR = '\\';

    public static CapturingGroup balancedCapture(CharSequence path, int startPos, int endPos, CaptureType type) {
        int cursor;
        Assert.notNull(path, "Character input array must not be null.");
        Assert.assertTrue(startPos >= 0, "Start position must be greater than zero.");
        Assert.assertTrue(startPos < path.length() - 1, "Start position must be at least one character before the array upper bound.");
        Assert.assertTrue(endPos > 0, "End position must be greater than zero.");
        Assert.assertTrue(endPos < path.length(), "End position must be less than or equal to the array upper bound.");
        Assert.assertTrue(startPos < endPos, "Start position must be less than end position.");
        Assert.assertTrue(path.charAt(startPos) == type.getBegin(), "Character at starting position was [" + path.charAt(startPos) + "] but expected [" + type.getBegin() + "]");
        if (startPos > 0 && path.charAt(startPos - 1) == '\\' && (startPos == 1 || startPos > 1 && path.charAt(startPos - 2) != '\\')) {
            throw new IllegalArgumentException("Character at starting position is escaped, and cannot be used in capturing a group.");
        }
        int depth = 1;
        char begin = type.getBegin();
        char term = type.getEnd();
        for (cursor = startPos + 1; cursor < endPos && depth > 0; ++cursor) {
            if (path.charAt(cursor) == term) {
                if (!ParseTools.isEscaped(path, cursor)) {
                    --depth;
                }
            } else if (path.charAt(cursor) == begin && !ParseTools.isEscaped(path, cursor)) {
                ++depth;
            }
            if (depth == 0) break;
        }
        return new CapturingGroup(path, startPos, cursor);
    }

    public static boolean isEscaped(CharSequence path, int cursor) {
        Assert.notNull(path, "Character input array must not be null.");
        Assert.assertTrue(cursor >= 0, "Start position must be greater than zero.");
        Assert.assertTrue(cursor < path.length(), "Start position must be within the array upper bound.");
        return cursor > 0 && path.charAt(cursor - 1) == '\\' && (cursor == 1 || cursor > 1 && path.charAt(cursor - 2) != '\\');
    }
}

