/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.operation.validator.model.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.openapi4j.core.util.MultiStringMap;
import org.openapi4j.operation.validator.model.Request;
import org.openapi4j.operation.validator.model.impl.Body;

public class DefaultRequest
implements Request {
    private final Request.Method method;
    private final String path;
    private final Map<String, String> cookies;
    private final Map<String, Collection<String>> headers;
    private final String query;
    private final Body body;

    private DefaultRequest(Request.Method method, String path, Map<String, String> cookies, Map<String, Collection<String>> headers, String query, Body body) {
        this.method = Objects.requireNonNull(method, "A method is required");
        this.path = Objects.requireNonNull(path, "A request path is required");
        this.cookies = Objects.requireNonNull(cookies);
        this.headers = Objects.requireNonNull(headers);
        this.query = query;
        this.body = body;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Request.Method getMethod() {
        return this.method;
    }

    @Override
    public Body getBody() {
        return this.body;
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public Map<String, String> getCookies() {
        return this.cookies;
    }

    @Override
    public Map<String, Collection<String>> getHeaders() {
        return this.headers;
    }

    @Override
    public Collection<String> getHeaderValues(String name) {
        return this.headers.get(name);
    }

    public static final class Builder {
        private final Request.Method method;
        private final String path;
        private final Map<String, String> cookies;
        private final MultiStringMap<String> headers;
        private String query;
        private Body body;

        public Builder(Request.Method method, String path) {
            this.method = Objects.requireNonNull(method, "A method is required");
            this.path = Objects.requireNonNull(path, "A path is required");
            this.cookies = new HashMap<String, String>();
            this.headers = new MultiStringMap(false);
        }

        public Builder cookies(Map<String, String> cookies) {
            this.cookies.putAll(cookies);
            return this;
        }

        public Builder cookie(String name, String value) {
            this.cookies.put(name, value);
            return this;
        }

        public Builder headers(Map<String, Collection<String>> headers) {
            headers.forEach((arg_0, arg_1) -> this.headers.putAll(arg_0, arg_1));
            return this;
        }

        public Builder header(String name, Collection<String> values) {
            this.headers.putAll(name, values);
            return this;
        }

        public Builder header(String name, String value) {
            this.headers.put(name, (Object)value);
            return this;
        }

        public Builder query(String query) {
            this.query = query;
            return this;
        }

        public Builder body(Body body) {
            this.body = body;
            return this;
        }

        public DefaultRequest build() {
            return new DefaultRequest(this.method, this.path, Collections.unmodifiableMap(this.cookies), this.headers.asUnmodifiableMap(), this.query, this.body);
        }
    }
}

