/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.operation.validator.util;

import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openapi4j.core.exception.ResolutionException;
import org.openapi4j.parser.model.v3.Parameter;

public class PathResolver {
    private static final String PATH_PARAM_MISSING_ERR_MSG = "Missing path parameter description for : '%s'.";
    private static final Pattern OAS_PATH_PARAMETERS_PATTERN = Pattern.compile("\\{[.;?*+]*([^{}.;?*+]+)[^}]*}");
    private static final PathResolver INSTANCE = new PathResolver();

    private PathResolver() {
    }

    public static PathResolver instance() {
        return INSTANCE;
    }

    public Optional<String> solve(String oasPath, List<Parameter> pathParameters) throws ResolutionException {
        if (pathParameters.isEmpty()) {
            return Optional.empty();
        }
        StringBuilder regex = new StringBuilder();
        int lastMatchEnd = 0;
        Matcher parametersMatcher = OAS_PATH_PARAMETERS_PATTERN.matcher(oasPath);
        while (parametersMatcher.find()) {
            this.addConstantFragment(regex, oasPath, lastMatchEnd, parametersMatcher.start());
            lastMatchEnd = parametersMatcher.end();
            String paramName = parametersMatcher.group(1);
            Optional<Parameter> optParameter = pathParameters.stream().filter(p -> p.getName().equals(paramName)).findFirst();
            if (!optParameter.isPresent()) {
                throw new ResolutionException(String.format(PATH_PARAM_MISSING_ERR_MSG, paramName));
            }
            this.addVariableFragment(regex, paramName);
        }
        this.addConstantFragment(regex, oasPath, lastMatchEnd, oasPath.length());
        return Optional.of(regex.toString());
    }

    private void addVariableFragment(StringBuilder regex, String paramName) {
        String reg = "(?<" + paramName + ">[^\\/]*)";
        regex.append(reg);
    }

    private void addConstantFragment(StringBuilder regex, String oasPath, int beginIndex, int endIndex) {
        String toQuote = oasPath.substring(beginIndex, endIndex);
        if (toQuote.length() != 0) {
            regex.append(Pattern.quote(toQuote));
        }
    }
}

