/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.operation.validator.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Pattern;
import org.json.JSONObject;
import org.json.XML;
import org.json.XMLParserConfiguration;
import org.openapi4j.core.util.TreeUtil;
import org.openapi4j.operation.validator.util.TypeConverter;
import org.openapi4j.parser.model.v3.Schema;
import org.openapi4j.parser.model.v3.Xml;

class XmlConverter {
    private static final XmlConverter INSTANCE = new XmlConverter();
    private static final Pattern nsPattern = Pattern.compile("<(/)*\\w+:(\\w+)((?:\\s+\\w+=\".+?\")*)(?:\\s+\\w+:\\w+=\".+?\")?((?:\\s+\\w+=\".+?\")*)(\\s*/?)>");
    private static final String nsReplace = "<$1$2$3$4$5>";

    private XmlConverter() {
    }

    static XmlConverter instance() {
        return INSTANCE;
    }

    JsonNode xmlToNode(Schema schema, String body) {
        return this.convert(schema, XML.toJSONObject((String)nsPattern.matcher(body).replaceAll(nsReplace), (XMLParserConfiguration)XMLParserConfiguration.KEEP_STRINGS));
    }

    private JsonNode convert(Schema schema, JSONObject xml) {
        JsonNode content;
        if (xml.isEmpty()) {
            return JsonNodeFactory.instance.nullNode();
        }
        try {
            content = TreeUtil.json.readTree(xml.toString());
        }
        catch (IOException e) {
            return JsonNodeFactory.instance.nullNode();
        }
        if ("object".equals(schema.getSupposedType())) {
            content = (JsonNode)((Map.Entry)content.fields().next()).getValue();
        }
        return this.processNode(schema, content);
    }

    private JsonNode processNode(Schema schema, JsonNode node) {
        JsonNode content = this.unwrap(schema, node, null);
        if ("array".equals(schema.getSupposedType())) {
            return this.parseArray(schema, content);
        }
        if ("object".equals(schema.getSupposedType())) {
            return this.parseObject(schema, content);
        }
        return TypeConverter.instance().convertPrimitive(schema, content.asText());
    }

    private JsonNode parseArray(Schema schema, JsonNode node) {
        if (!node.isArray()) {
            return JsonNodeFactory.instance.nullNode();
        }
        ArrayNode resultNode = JsonNodeFactory.instance.arrayNode();
        for (JsonNode arrayItem : node) {
            resultNode.add(this.processNode(schema.getItemsSchema(), arrayItem));
        }
        return resultNode;
    }

    private JsonNode parseObject(Schema schema, JsonNode node) {
        if (!node.isObject()) {
            return JsonNodeFactory.instance.nullNode();
        }
        ObjectNode resultNode = JsonNodeFactory.instance.objectNode();
        for (Map.Entry entry : schema.getProperties().entrySet()) {
            String entryKey = (String)entry.getKey();
            Schema propSchema = (Schema)entry.getValue();
            resultNode.set(entryKey, this.processNode(propSchema, this.unwrap(schema, node, entryKey)));
        }
        return resultNode;
    }

    private JsonNode unwrap(Schema schema, JsonNode content, String defaultKey) {
        Xml xmlConf = schema.getXml();
        if ("array".equals(schema.getSupposedType())) {
            if (xmlConf != null && xmlConf.isWrapped()) {
                if (xmlConf.getName() != null) {
                    return this.getRenamedNode(xmlConf, content.get(xmlConf.getName()), xmlConf.getName());
                }
                if (content.size() == 1) {
                    return (JsonNode)((Map.Entry)content.fields().next()).getValue();
                }
                return JsonNodeFactory.instance.nullNode();
            }
            xmlConf = schema.getItemsSchema().getXml();
            if (xmlConf != null) {
                return this.getRenamedNode(xmlConf, content, xmlConf.getName());
            }
        } else if ("object".equals(schema.getSupposedType())) {
            return this.getRenamedNode(xmlConf, content, defaultKey);
        }
        return content;
    }

    private JsonNode getRenamedNode(Xml xmlConf, JsonNode content, String defaultKey) {
        if (xmlConf != null && xmlConf.getName() != null) {
            return content.get(xmlConf.getName());
        }
        if (defaultKey != null) {
            return content.get(defaultKey);
        }
        return content;
    }
}

