/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.operation.validator.util.parameter;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openapi4j.operation.validator.util.parameter.FlatStyleConverter;
import org.openapi4j.parser.model.v3.AbsParameter;
import org.openapi4j.parser.model.v3.Schema;

class DeepObjectStyleConverter
extends FlatStyleConverter {
    private static final Pattern REGEX = Pattern.compile("(?:([^&]+)\\[([^&]+)])(?:=)([^&]*)");
    private static final DeepObjectStyleConverter INSTANCE = new DeepObjectStyleConverter();

    private DeepObjectStyleConverter() {
    }

    public static DeepObjectStyleConverter instance() {
        return INSTANCE;
    }

    @Override
    public JsonNode convert(AbsParameter<?> param, String paramName, String rawValue) {
        if (rawValue == null) {
            return null;
        }
        HashMap<String, Object> paramValues = new HashMap<String, Object>();
        Schema paramSchema = param.getSchema();
        Matcher matcher = REGEX.matcher(rawValue);
        while (matcher.find()) {
            if (!paramName.equalsIgnoreCase(matcher.group(1)) || !paramSchema.hasProperty(matcher.group(2))) continue;
            paramValues.put(matcher.group(2), matcher.group(3));
        }
        return this.convert(param, paramName, paramValues);
    }
}

