/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.operation.validator.util.parameter;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openapi4j.operation.validator.util.parameter.FlatStyleConverter;
import org.openapi4j.parser.model.v3.AbsParameter;

class MatrixStyleConverter
extends FlatStyleConverter {
    private static final Pattern PREFIXED_SEMICOLON_NAME_REGEX = Pattern.compile("(?:;)([^;]+)(?:=)([^;]*)");
    private static final MatrixStyleConverter INSTANCE = new MatrixStyleConverter();

    private MatrixStyleConverter() {
    }

    public static MatrixStyleConverter instance() {
        return INSTANCE;
    }

    @Override
    public JsonNode convert(AbsParameter<?> param, String paramName, String rawValue) {
        if (rawValue == null) {
            return null;
        }
        Map<String, Object> paramValues = this.getValues(param, paramName, rawValue, param.isExplode() ? ";" : ",");
        return this.convert(param, paramName, paramValues);
    }

    private Map<String, Object> getValues(AbsParameter<?> param, String paramName, String rawValue, String splitPattern) {
        String type = param.getSchema().getSupposedType();
        if ("object".equals(type)) {
            return this.getObjectValues(param, paramName, rawValue, splitPattern);
        }
        HashMap<String, Object> values = new HashMap<String, Object>();
        if ("array".equals(type)) {
            List<String> arrayValues = this.getArrayValues(param, rawValue, splitPattern);
            if (arrayValues != null && !arrayValues.isEmpty()) {
                values.put(paramName, arrayValues);
            }
        } else {
            Matcher matcher = PREFIXED_SEMICOLON_NAME_REGEX.matcher(rawValue);
            if (matcher.matches()) {
                values.put(matcher.group(1), matcher.group(2));
            }
        }
        return values;
    }

    private Map<String, Object> getObjectValues(AbsParameter<?> param, String paramName, String rawValue, String splitPattern) {
        Matcher matcher = PREFIXED_SEMICOLON_NAME_REGEX.matcher(rawValue);
        if (param.isExplode()) {
            HashMap<String, Object> values = new HashMap<String, Object>();
            while (matcher.find()) {
                values.put(matcher.group(1), matcher.group(2));
            }
            return values;
        }
        return matcher.find() ? this.getParameterValues(param, paramName, matcher.group(2), splitPattern) : null;
    }

    private List<String> getArrayValues(AbsParameter<?> param, String rawValue, String splitPattern) {
        Matcher matcher = PREFIXED_SEMICOLON_NAME_REGEX.matcher(rawValue);
        if (param.isExplode()) {
            ArrayList<String> arrayValues = new ArrayList<String>();
            while (matcher.find()) {
                arrayValues.add(matcher.group(2));
            }
            return arrayValues;
        }
        return matcher.matches() ? Arrays.asList(matcher.group(2).split(splitPattern)) : null;
    }
}

