/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.operation.validator.util.parameter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openapi4j.operation.validator.util.ContentConverter;
import org.openapi4j.operation.validator.util.parameter.DeepObjectStyleConverter;
import org.openapi4j.operation.validator.util.parameter.FormStyleConverter;
import org.openapi4j.operation.validator.util.parameter.LabelStyleConverter;
import org.openapi4j.operation.validator.util.parameter.MatrixStyleConverter;
import org.openapi4j.operation.validator.util.parameter.PipeDelimitedStyleConverter;
import org.openapi4j.operation.validator.util.parameter.SimpleStyleConverter;
import org.openapi4j.operation.validator.util.parameter.SpaceDelimitedStyleConverter;
import org.openapi4j.parser.model.OpenApiSchema;
import org.openapi4j.parser.model.v3.AbsParameter;
import org.openapi4j.parser.model.v3.MediaType;
import org.openapi4j.parser.model.v3.Parameter;

public final class ParameterConverter {
    private static final String LABEL = "label";
    private static final String MATRIX = "matrix";
    private static final String SPACE_DELIMITED = "spaceDelimited";
    private static final String PIPE_DELIMITED = "pipeDelimited";
    private static final String DEEP_OBJECT = "deepObject";

    private ParameterConverter() {
    }

    public static Map<String, JsonNode> pathToNode(Map<String, AbsParameter<Parameter>> specParameters, Pattern pattern, String path) {
        HashMap<String, JsonNode> mappedValues = new HashMap<String, JsonNode>();
        if (pattern == null) {
            return mappedValues;
        }
        Matcher matcher = pattern.matcher(path);
        if (!matcher.matches()) {
            return mappedValues;
        }
        for (Map.Entry<String, AbsParameter<Parameter>> paramEntry : specParameters.entrySet()) {
            String style;
            String paramName = paramEntry.getKey();
            AbsParameter<Parameter> param = paramEntry.getValue();
            JsonNode convertedValue = param.getSchema() != null ? (LABEL.equals(style = param.getStyle()) ? LabelStyleConverter.instance().convert(param, paramName, matcher.group(paramName)) : (MATRIX.equals(style) ? MatrixStyleConverter.instance().convert(param, paramName, matcher.group(paramName)) : SimpleStyleConverter.instance().convert(param, paramName, matcher.group(paramName)))) : ParameterConverter.getValueFromContentType(param.getContentMediaTypes(), matcher.group(paramName));
            mappedValues.put(paramName, convertedValue);
        }
        return mappedValues;
    }

    public static Map<String, JsonNode> queryToNode(Map<String, AbsParameter<Parameter>> specParameters, String rawValue) {
        HashMap<String, JsonNode> mappedValues = new HashMap<String, JsonNode>();
        if (rawValue == null) {
            return mappedValues;
        }
        for (Map.Entry<String, AbsParameter<Parameter>> paramEntry : specParameters.entrySet()) {
            JsonNode convertedValue;
            String paramName = paramEntry.getKey();
            AbsParameter<Parameter> param = paramEntry.getValue();
            if (param.getSchema() != null) {
                String style = param.getStyle();
                if (SPACE_DELIMITED.equals(style)) {
                    convertedValue = SpaceDelimitedStyleConverter.instance().convert(param, paramName, rawValue);
                } else if (PIPE_DELIMITED.equals(style)) {
                    convertedValue = PipeDelimitedStyleConverter.instance().convert(param, paramName, rawValue);
                } else if (DEEP_OBJECT.equals(style)) {
                    convertedValue = DeepObjectStyleConverter.instance().convert(param, paramName, rawValue);
                } else {
                    if (param.getExplode() == null) {
                        param.setExplode(Boolean.valueOf(true));
                    }
                    convertedValue = FormStyleConverter.instance().convert(param, paramName, rawValue);
                }
            } else {
                convertedValue = ParameterConverter.getValueFromContentType(param.getContentMediaTypes(), rawValue);
            }
            if (convertedValue == null) continue;
            mappedValues.put(paramName, convertedValue);
        }
        return mappedValues;
    }

    public static <M extends OpenApiSchema<M>> Map<String, JsonNode> headersToNode(Map<String, AbsParameter<M>> specParameters, Map<String, Collection<String>> headers) {
        HashMap<String, JsonNode> mappedValues = new HashMap<String, JsonNode>();
        if (headers == null) {
            return mappedValues;
        }
        for (Map.Entry<String, AbsParameter<M>> paramEntry : specParameters.entrySet()) {
            Collection<String> headerValues;
            String paramName = paramEntry.getKey();
            AbsParameter<M> param = paramEntry.getValue();
            Object convertedValue = !headers.containsKey(paramName) ? null : ((headerValues = headers.get(paramName)) != null ? (param.getSchema() != null ? SimpleStyleConverter.instance().convert(param, paramName, String.join((CharSequence)",", headerValues)) : ParameterConverter.getValueFromContentType(param.getContentMediaTypes(), headerValues.stream().findFirst().orElse(null))) : JsonNodeFactory.instance.nullNode());
            if (convertedValue == null) continue;
            mappedValues.put(paramName, (JsonNode)convertedValue);
        }
        return mappedValues;
    }

    public static Map<String, JsonNode> cookiesToNode(Map<String, AbsParameter<Parameter>> specParameters, Map<String, String> cookies) {
        HashMap<String, JsonNode> mappedValues = new HashMap<String, JsonNode>();
        if (cookies == null) {
            return mappedValues;
        }
        for (Map.Entry<String, AbsParameter<Parameter>> paramEntry : specParameters.entrySet()) {
            String value;
            String paramName = paramEntry.getKey();
            AbsParameter<Parameter> param = paramEntry.getValue();
            if (param.getExplode() == null) {
                param.setExplode(Boolean.valueOf(true));
            }
            Object convertedValue = !cookies.containsKey(paramName) ? null : ((value = cookies.get(paramName)) != null ? (param.getSchema() != null ? SimpleStyleConverter.instance().convert(param, paramName, value) : ParameterConverter.getValueFromContentType(param.getContentMediaTypes(), value)) : JsonNodeFactory.instance.nullNode());
            if (convertedValue == null) continue;
            mappedValues.put(paramName, (JsonNode)convertedValue);
        }
        return mappedValues;
    }

    private static JsonNode getValueFromContentType(Map<String, MediaType> mediaTypes, String value) {
        Optional entry;
        if (mediaTypes != null && value != null && (entry = mediaTypes.entrySet().stream().findFirst()).isPresent()) {
            Map.Entry mediaType = (Map.Entry)entry.get();
            try {
                return ContentConverter.convert(((MediaType)mediaType.getValue()).getSchema(), (String)mediaType.getKey(), null, value);
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }
}

