/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.operation.validator.validation;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.openapi4j.core.model.v3.OAI3;
import org.openapi4j.core.validation.ValidationException;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.operation.validator.model.Request;
import org.openapi4j.operation.validator.model.Response;
import org.openapi4j.operation.validator.model.impl.RequestParameters;
import org.openapi4j.operation.validator.validation.OperationValidator;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.model.v3.Operation;
import org.openapi4j.parser.model.v3.Path;
import org.openapi4j.schema.validator.ValidationContext;

public class RequestValidator {
    private static final String OPENAPI_REQUIRED_ERR_MSG = "OpenAPI is required.";
    private static final String VALIDATION_CTX_REQUIRED_ERR_MSG = "Validation context is required.";
    private static final String PATH_REQUIRED_ERR_MSG = "Path is required.";
    private static final String OPERATION_REQUIRED_ERR_MSG = "Operation is required.";
    private static final String REQUEST_REQUIRED_ERR_MSG = "Request is required.";
    private static final String RESPONSE_REQUIRED_ERR_MSG = "Response is required.";
    private static final String INVALID_REQUEST_ERR_MSG = "Invalid request";
    private static final String INVALID_RESPONSE_ERR_MSG = "Invalid response";
    private final OpenApi3 openApi;
    private final ValidationContext<OAI3> context;
    private final Map<Operation, OperationValidator> operationValidators;

    public RequestValidator(OpenApi3 openApi) {
        this((ValidationContext<OAI3>)new ValidationContext(openApi.getContext()), openApi);
    }

    public RequestValidator(ValidationContext<OAI3> context, OpenApi3 openApi) {
        Objects.requireNonNull(openApi, OPENAPI_REQUIRED_ERR_MSG);
        Objects.requireNonNull(context, VALIDATION_CTX_REQUIRED_ERR_MSG);
        this.openApi = openApi;
        this.context = context;
        this.operationValidators = new ConcurrentHashMap<Operation, OperationValidator>();
    }

    public OperationValidator compile(Path path, Operation operation) {
        Objects.requireNonNull(path, PATH_REQUIRED_ERR_MSG);
        Objects.requireNonNull(operation, OPERATION_REQUIRED_ERR_MSG);
        return this.operationValidators.computeIfAbsent(operation, op -> new OperationValidator(this.context, this.openApi, path, (Operation)op));
    }

    public RequestParameters validate(Request request, Path path, Operation operation) throws ValidationException {
        Objects.requireNonNull(request, REQUEST_REQUIRED_ERR_MSG);
        OperationValidator opValidator = this.compile(path, operation);
        ValidationResults results = new ValidationResults();
        Map<String, JsonNode> pathParameters = opValidator.validatePath(request, results);
        Map<String, JsonNode> queryParameters = opValidator.validateQuery(request, results);
        Map<String, JsonNode> headerParameters = opValidator.validateHeaders(request, results);
        Map<String, JsonNode> cookieParameters = opValidator.validateCookies(request, results);
        opValidator.validateBody(request, results);
        if (!results.isValid()) {
            throw new ValidationException(INVALID_REQUEST_ERR_MSG, results);
        }
        return new RequestParameters(pathParameters, queryParameters, headerParameters, cookieParameters);
    }

    public void validate(Response response, Path path, Operation operation) throws ValidationException {
        Objects.requireNonNull(response, RESPONSE_REQUIRED_ERR_MSG);
        OperationValidator opValidator = this.compile(path, operation);
        ValidationResults results = new ValidationResults();
        opValidator.validateHeaders(response, results);
        opValidator.validateBody(response, results);
        if (!results.isValid()) {
            throw new ValidationException(INVALID_RESPONSE_ERR_MSG, results);
        }
    }
}

