/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.model.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import org.openapi4j.core.model.OAIContext;
import org.openapi4j.parser.model.v3.AbsExtendedRefOpenApiSchema;
import org.openapi4j.parser.model.v3.MediaType;

public class RequestBody
extends AbsExtendedRefOpenApiSchema<RequestBody> {
    @JsonProperty(value="content")
    private Map<String, MediaType> contentMediaTypes;
    private String description;
    private Boolean required;

    public String getDescription() {
        return this.description;
    }

    public RequestBody setDescription(String description) {
        this.description = description;
        return this;
    }

    public Map<String, MediaType> getContentMediaTypes() {
        return this.contentMediaTypes;
    }

    public RequestBody setContentMediaTypes(Map<String, MediaType> contentMediaTypes) {
        this.contentMediaTypes = contentMediaTypes;
        return this;
    }

    public boolean hasContentMediaType(String name) {
        return this.mapHas(this.contentMediaTypes, name);
    }

    public MediaType getContentMediaType(String name) {
        return this.mapGet(this.contentMediaTypes, name);
    }

    public RequestBody setContentMediaType(String name, MediaType contentMediaType) {
        if (this.contentMediaTypes == null) {
            this.contentMediaTypes = new HashMap<String, MediaType>();
        }
        this.contentMediaTypes.put(name, contentMediaType);
        return this;
    }

    public RequestBody removeContentMediaType(String name) {
        this.mapRemove(this.contentMediaTypes, name);
        return this;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public boolean isRequired() {
        return Boolean.TRUE.equals(this.required);
    }

    public RequestBody setRequired(Boolean required) {
        this.required = required;
        return this;
    }

    @Override
    protected RequestBody copyReference(OAIContext context) {
        RequestBody copy = new RequestBody();
        copy.setRef(this.getRef());
        copy.setCanonicalRef(this.getCanonicalRef());
        return copy;
    }

    @Override
    protected RequestBody copyContent(OAIContext context, boolean followRefs) {
        RequestBody copy = new RequestBody();
        copy.setDescription(this.getDescription());
        copy.setContentMediaTypes(this.copyMap(this.getContentMediaTypes(), context, followRefs));
        copy.setRequired(this.getRequired());
        copy.setExtensions(this.copyMap(this.getExtensions()));
        return copy;
    }
}

