/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.model.v3;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import org.openapi4j.core.model.OAIContext;
import org.openapi4j.parser.model.v3.AbsExtendedRefOpenApiSchema;
import org.openapi4j.parser.model.v3.Header;
import org.openapi4j.parser.model.v3.Link;
import org.openapi4j.parser.model.v3.MediaType;

public class Response
extends AbsExtendedRefOpenApiSchema<Response> {
    private String description;
    private Map<String, Header> headers;
    @JsonProperty(value="content")
    private Map<String, MediaType> contentMediaTypes;
    private Map<String, Link> links;

    public String getDescription() {
        return this.description;
    }

    public Response setDescription(String description) {
        this.description = description;
        return this;
    }

    public Map<String, Header> getHeaders() {
        return this.headers;
    }

    public Response setHeaders(Map<String, Header> headers) {
        this.headers = headers;
        return this;
    }

    public boolean hasHeader(String name) {
        return this.mapHas(this.headers, name);
    }

    public Header getHeader(String name) {
        return this.mapGet(this.headers, name);
    }

    public Response setHeader(String name, Header header) {
        if (this.headers == null) {
            this.headers = new HashMap<String, Header>();
        }
        this.headers.put(name, header);
        return this;
    }

    public Response removeHeader(String name) {
        this.mapRemove(this.headers, name);
        return this;
    }

    public Map<String, MediaType> getContentMediaTypes() {
        return this.contentMediaTypes;
    }

    public Response setContentMediaTypes(Map<String, MediaType> contentMediaTypes) {
        this.contentMediaTypes = contentMediaTypes;
        return this;
    }

    public boolean hasContentMediaType(String name) {
        return this.mapHas(this.contentMediaTypes, name);
    }

    public MediaType getContentMediaType(String name) {
        return this.mapGet(this.contentMediaTypes, name);
    }

    public Response setContentMediaType(String name, MediaType contentMediaType) {
        if (this.contentMediaTypes == null) {
            this.contentMediaTypes = new HashMap<String, MediaType>();
        }
        this.contentMediaTypes.put(name, contentMediaType);
        return this;
    }

    public Response removeContentMediaType(String name) {
        this.mapRemove(this.contentMediaTypes, name);
        return this;
    }

    public Map<String, Link> getLinks() {
        return this.links;
    }

    public Response setLinks(Map<String, Link> links) {
        this.links = links;
        return this;
    }

    public boolean hasLink(String name) {
        return this.mapHas(this.links, name);
    }

    public Link getLink(String name) {
        return this.mapGet(this.links, name);
    }

    public Response setLink(String name, Link link) {
        if (this.links == null) {
            this.links = new HashMap<String, Link>();
        }
        this.links.put(name, link);
        return this;
    }

    public Response removeLink(String name) {
        this.mapRemove(this.links, name);
        return this;
    }

    @Override
    protected Response copyReference(OAIContext context) {
        Response copy = new Response();
        copy.setRef(this.getRef());
        copy.setCanonicalRef(this.getCanonicalRef());
        return copy;
    }

    @Override
    protected Response copyContent(OAIContext context, boolean followRefs) {
        Response copy = new Response();
        copy.setDescription(this.getDescription());
        copy.setHeaders(this.copyMap(this.getHeaders(), context, followRefs));
        copy.setContentMediaTypes(this.copyMap(this.getContentMediaTypes(), context, followRefs));
        copy.setLinks(this.copyMap(this.getLinks(), context, followRefs));
        copy.setExtensions(this.copyMap(this.getExtensions()));
        return copy;
    }
}

