/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.validation.v3;

import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.core.validation.ValidationSeverity;
import org.openapi4j.parser.model.v3.OAuthFlow;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.validation.Validator;
import org.openapi4j.parser.validation.v3.Regexes;
import org.openapi4j.parser.validation.v3.Validator3Base;

class OAuthFlowValidator
extends Validator3Base<OpenApi3, OAuthFlow> {
    private static final String AUTH_URL_NOT_ALLOWED = "'authorizationUrl' is not allowed when OAuth2 configuration is 'implicit' or 'authorizationCode'.";
    private static final String TOKEN_URL_NOT_ALLOWED = "'tokenUrl' is not allowed when OAuth2 configuration is 'implicit'.";
    private static final Validator<OpenApi3, OAuthFlow> INSTANCE = new OAuthFlowValidator();

    private OAuthFlowValidator() {
    }

    public static Validator<OpenApi3, OAuthFlow> instance() {
        return INSTANCE;
    }

    @Override
    public void validate(OpenApi3 api, OAuthFlow oauthFlow, ValidationResults results) {
        String conf = oauthFlow.getConfiguration();
        if ("implicit".equals(conf) || "authorizationCode".equals(conf)) {
            this.validateUrl(oauthFlow.getAuthorizationUrl(), results, true, "authorizationUrl", ValidationSeverity.ERROR);
        } else if (oauthFlow.getAuthorizationUrl() != null) {
            results.addError(AUTH_URL_NOT_ALLOWED, "authorizationUrl");
        }
        if ("password".equals(conf) || "clientCredentials".equals(conf) || "authorizationCode".equals(conf)) {
            this.validateUrl(oauthFlow.getTokenUrl(), results, true, "tokenUrl", ValidationSeverity.ERROR);
        } else if (oauthFlow.getTokenUrl() != null) {
            results.addError(TOKEN_URL_NOT_ALLOWED, "tokenUrl");
        }
        this.validateUrl(oauthFlow.getRefreshUrl(), results, false, "refreshUrl", ValidationSeverity.ERROR);
        this.validateMap(api, oauthFlow.getScopes(), results, true, "scopes", Regexes.NOEXT_REGEX, null);
        this.validateMap(api, oauthFlow.getExtensions(), results, false, "extensions", Regexes.EXT_REGEX, null);
    }
}

