/*
 * Decompiled with CFR 0.152.
 */
package org.openapi4j.parser.validation.v3;

import org.openapi4j.core.exception.DecodeException;
import org.openapi4j.core.model.reference.Reference;
import org.openapi4j.core.validation.ValidationResults;
import org.openapi4j.parser.model.AbsRefOpenApiSchema;
import org.openapi4j.parser.model.OpenApiSchema;
import org.openapi4j.parser.model.v3.OpenApi3;
import org.openapi4j.parser.validation.Validator;
import org.openapi4j.parser.validation.ValidatorBase;

abstract class Validator3Base<O extends OpenApi3, T>
extends ValidatorBase<O, T> {
    protected static final String REF_MISSING = "Missing $ref '%s'";
    protected static final String REF_CONTENT_UNREADABLE = "Unable to read $ref content for '%s' pointer.";

    Validator3Base() {
    }

    <F extends OpenApiSchema<F>> F getReferenceContent(OpenApi3 api, AbsRefOpenApiSchema<F> schema, ValidationResults results, String crumb, Class<F> clazz) {
        Reference reference = schema.getReference(api.getContext());
        if (reference == null) {
            results.addError(String.format(REF_MISSING, schema.getRef()), crumb);
        } else {
            try {
                return (F)((OpenApiSchema)reference.getMappedContent(clazz));
            }
            catch (DecodeException e) {
                results.addError(String.format(REF_CONTENT_UNREADABLE, schema.getRef()), crumb);
            }
        }
        return null;
    }

    <F extends OpenApiSchema<F>> void validateReference(OpenApi3 api, AbsRefOpenApiSchema<F> schema, ValidationResults results, String crumb, Validator<OpenApi3, F> validator, Class<F> clazz) {
        F content = this.getReferenceContent(api, schema, results, crumb, clazz);
        if (content != null) {
            validator.validate(api, content, results);
        }
    }
}

