/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import java.io.File;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractKotlinCodegen;
import org.openapitools.codegen.meta.GeneratorMetadata;
import org.openapitools.codegen.meta.Stability;
import org.openapitools.codegen.meta.features.GlobalFeature;
import org.openapitools.codegen.meta.features.ParameterFeature;
import org.openapitools.codegen.meta.features.SecurityFeature;
import org.openapitools.codegen.meta.features.WireFormatFeature;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;

public class KotlinWiremockServerCodegen
extends AbstractKotlinCodegen {
    protected static final String VENDOR_EXTENSION_BASE_NAME_LITERAL = "x-base-name-literal";

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "kotlin-wiremock";
    }

    @Override
    public String getHelp() {
        return "Generates Kotlin WireMock stub request and response samples.";
    }

    public KotlinWiremockServerCodegen() {
        this.templateDir = "kotlin-wiremock";
        this.embeddedTemplateDir = "kotlin-wiremock";
        this.generatorMetadata = GeneratorMetadata.newBuilder((GeneratorMetadata)this.generatorMetadata).stability(Stability.BETA).build();
        this.setArtifactId("kotlin-wiremock");
        this.setApiPackage(this.packageName + ".apis");
        this.setModelPackage(this.packageName + ".models");
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.modifyFeatureSet(features -> features.securityFeatures(EnumSet.allOf(SecurityFeature.class)).excludeWireFormatFeatures(new WireFormatFeature[]{WireFormatFeature.XML, WireFormatFeature.PROTOBUF}).excludeGlobalFeatures(new GlobalFeature[]{GlobalFeature.XMLStructureDefinitions, GlobalFeature.Callbacks, GlobalFeature.LinkObjects}).excludeParameterFeatures(new ParameterFeature[]{ParameterFeature.Cookie}));
        this.typeMapping.put("array", "kotlin.collections.List");
        this.reservedWords.remove("ApiResponse");
        this.additionalProperties.put("apiPackage", this.apiPackage());
        this.additionalProperties.put("modelPackage", this.modelPackage());
        this.apiTemplateFiles.put("api-stub.mustache", "Stubs.kt");
        this.apiTemplateFiles.put("api-stub-builder.mustache", "StubBuilders.kt");
        this.modelTemplateFiles.put("model.mustache", ".kt");
        this.supportingFiles.addAll(List.of(new SupportingFile("build.gradle.kts.mustache", "", "build.gradle.kts"), new SupportingFile("settings.gradle.kts.mustache", "", "settings.gradle.kts"), new SupportingFile("libs.versions.toml.mustache", "gradle", "libs.versions.toml"), new SupportingFile("gradlew.mustache", "", "gradlew"), new SupportingFile("gradlew.bat.mustache", "", "gradlew.bat"), new SupportingFile("gradle-wrapper.properties.mustache", "gradle" + File.separator + "wrapper", "gradle-wrapper.properties"), new SupportingFile("gradle-wrapper.jar", "gradle" + File.separator + "wrapper", "gradle-wrapper.jar")));
        this.supportingFiles.add(new SupportingFile(".gitignore.mustache", "", ".gitignore"));
    }

    @Override
    public ModelsMap postProcessModels(ModelsMap objs) {
        ModelsMap objects = super.postProcessModels(objs);
        for (ModelMap model : objects.getModels()) {
            CodegenModel cm = model.getModel();
            List vars = Stream.of(cm.vars, cm.allVars, cm.optionalVars, cm.requiredVars, cm.readOnlyVars, cm.readWriteVars, cm.parentVars).flatMap(Collection::stream).collect(Collectors.toList());
            for (CodegenProperty var : vars) {
                var.vendorExtensions.put(VENDOR_EXTENSION_BASE_NAME_LITERAL, var.baseName.replace("$", "\\$"));
            }
        }
        return objects;
    }

    @Override
    public void postProcess() {
        System.out.println("################################################################################");
        System.out.println("# Thanks for using OpenAPI Generator.                                              #");
        System.out.println("# Please consider donation to help us maintain this project \ud83d\ude4f                     #");
        System.out.println("# https://opencollective.com/openapi_generator/donate                              #");
        System.out.println("#                                                                                  #");
        System.out.println("# This generator's contributed by Stefan Koppier (https://github.com/stefankoppier)#");
        System.out.println("################################################################################");
    }
}

