/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.Schema;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.openapitools.codegen.CliOption;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.CodegenModel;
import org.openapitools.codegen.CodegenOperation;
import org.openapitools.codegen.CodegenParameter;
import org.openapitools.codegen.CodegenProperty;
import org.openapitools.codegen.CodegenType;
import org.openapitools.codegen.IJsonSchemaValidationProperties;
import org.openapitools.codegen.SupportingFile;
import org.openapitools.codegen.languages.AbstractScalaCodegen;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.ModelsMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.serializer.SerializerUtils;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScalaCaskServerCodegen
extends AbstractScalaCodegen
implements CodegenConfig {
    public static final String PROJECT_NAME = "projectName";
    private final Logger LOGGER = LoggerFactory.getLogger(ScalaCaskServerCodegen.class);
    protected String artifactVersion = "0.0.1";
    static String ApiServiceTemplate = "apiService.mustache";

    @Override
    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    @Override
    public String getName() {
        return "scala-cask";
    }

    @Override
    public String getHelp() {
        return "Generates a scala-cask server.";
    }

    public ScalaCaskServerCodegen() {
        this.outputFolder = "generated-code/scala-cask";
        this.templateDir = "scala-cask";
        this.embeddedTemplateDir = "scala-cask";
        this.apiPackage = "Apis";
        this.modelPackage = "Models";
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.outputFolder = "generated-code/cask";
        this.modelTestTemplateFiles.put("modelTest.mustache", ".scala");
        this.modelTemplateFiles.put("model.mustache", ".scala");
        this.modelTemplateFiles.put("modelData.mustache", "Data.scala");
        this.apiTemplateFiles.put("api.mustache", ".scala");
        this.apiTemplateFiles.put("apiRoutes.mustache", ".scala");
        this.apiTemplateFiles.put(ApiServiceTemplate, "Service.scala");
        this.templateDir = "scala-cask";
        this.embeddedTemplateDir = "scala-cask";
        this.setReservedWordsLowerCase(Arrays.asList("abstract", "continue", "for", "new", "switch", "assert", "default", "if", "package", "synchronized", "boolean", "do", "goto", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while", "type"));
        this.defaultIncludes = new HashSet<String>(Arrays.asList("double", "Int", "Long", "Float", "Double", "char", "float", "String", "boolean", "Boolean", "Double", "Integer", "Long", "Float", "List", "Set", "Map"));
        this.typeMapping.put("integer", "Int");
        this.typeMapping.put("long", "Long");
        this.typeMapping.put("binary", "String");
        this.typeMapping.put("object", "Value");
        this.cliOptions.add(new CliOption("groupId", "groupId in generated pom.xml"));
        this.cliOptions.add(new CliOption("artifactId", "artifactId in generated pom.xml. This also becomes part of the generated library's filename"));
        this.cliOptions.add(new CliOption("artifactVersion", "artifact version in generated pom.xml. This also becomes part of the generated library's filename. If not provided, uses the version from the OpenAPI specification file. If that's also not present, uses the default value of the artifactVersion option."));
        this.cliOptions.add(new CliOption("gitRepoId", "Git repo ID, e.g. openapi-generator."));
        this.cliOptions.add(new CliOption("gitUserId", "Git user ID, e.g. openapitools."));
        this.cliOptions.add(new CliOption("packageName", "packageDescription"));
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isMapSchema(p)) {
            String inner = this.getSchemaType(ModelUtils.getAdditionalProperties(p));
            return "Map[String, " + inner + "]() ";
        }
        if (ModelUtils.isFreeFormObject(p)) {
            return "ujson.Null";
        }
        return super.toDefaultValue(p);
    }

    @Override
    public String getSchemaType(Schema p) {
        if (ModelUtils.isFreeFormObject(p)) {
            return "Value";
        }
        return super.getSchemaType(p);
    }

    @Override
    public String testPackage() {
        return "jvm/src/test/scala";
    }

    @Override
    public String toModelTestFilename(String name) {
        String n = super.toModelTestFilename(name);
        return (this.modelPackage + "." + n).replace('.', '/');
    }

    private String ensureProp(String key, String defaultValue) {
        if (this.additionalProperties.containsKey(key) && !this.additionalProperties.get(key).toString().trim().isEmpty()) {
            return (String)this.additionalProperties.get(key);
        }
        this.additionalProperties.put(key, defaultValue);
        return defaultValue;
    }

    @Override
    public void processOpts() {
        super.processOpts();
        String groupId = this.ensureProp("groupId", "org.openapitools");
        this.ensureProp("artifactId", "caskgen");
        this.artifactVersion = this.ensureProp("artifactVersion", "0.0.1");
        this.gitRepoId = this.ensureProp("gitRepoId", "<your git repo -- set 'gitRepoId'>");
        this.gitUserId = this.ensureProp("gitUserId", "<your git user -- set 'gitUserId'>");
        String basePackage = this.ensureProp("packageName", groupId + ".server");
        this.apiPackage = this.ensureProp("apiPackage", basePackage + ".api");
        this.modelPackage = this.ensureProp("modelPackage", basePackage + ".model");
        String apiPath = "jvm/src/main/scala/" + this.apiPackage.replace('.', '/');
        String modelPath = "shared/src/main/scala/" + this.modelPackage.replace('.', '/');
        List appFullPath = Arrays.stream(apiPath.split("/")).collect(Collectors.toList());
        String appFolder = String.join((CharSequence)"/", appFullPath.subList(0, appFullPath.size() - 1));
        this.additionalProperties.put("appName", "Cask App");
        this.additionalProperties.put("appDescription", "A cask service");
        this.additionalProperties.put("infoUrl", "https://openapi-generator.tech");
        this.additionalProperties.put("infoEmail", this.infoEmail);
        this.additionalProperties.put("licenseInfo", "All rights reserved");
        this.additionalProperties.put("licenseUrl", "http://apache.org/licenses/LICENSE-2.0.html");
        this.additionalProperties.put("invokerPackage", this.invokerPackage);
        this.additionalProperties.put("openbrackets", "{{");
        this.additionalProperties.put("closebrackets", "}}");
        this.supportingFiles.add(new SupportingFile("example.mustache", "example", "Server.scala"));
        this.supportingFiles.add(new SupportingFile("Dockerfile.mustache", "example", "Dockerfile"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("build.sbt.mustache", "", "build.sbt"));
        this.supportingFiles.add(new SupportingFile("buildAndPublish.yml.mustache", "", ".github/workflows/buildAndPublish.yml"));
        this.supportingFiles.add(new SupportingFile("build.sc.mustache", "", "build.sc"));
        this.supportingFiles.add(new SupportingFile(".scalafmt.conf.mustache", "", ".scalafmt.conf"));
        this.supportingFiles.add(new SupportingFile("gitignore.mustache", "", ".gitignore"));
        this.supportingFiles.add(new SupportingFile("appPackage.mustache", appFolder, "package.scala"));
        this.supportingFiles.add(new SupportingFile("apiPackage.mustache", apiPath, "package.scala"));
        this.supportingFiles.add(new SupportingFile("modelPackage.mustache", modelPath, "package.scala"));
        this.supportingFiles.add(new SupportingFile("exampleApp.mustache", appFolder, "ExampleApp.scala"));
        this.supportingFiles.add(new SupportingFile("baseApp.mustache", appFolder, "BaseApp.scala"));
        this.supportingFiles.add(new SupportingFile("openapiRoute.mustache", apiPath, "OpenApiRoutes.scala"));
        this.supportingFiles.add(new SupportingFile("appRoutes.mustache", appFolder, "AppRoutes.scala"));
        this.supportingFiles.add(new SupportingFile("project/build.properties", "project", "build.properties"));
        this.supportingFiles.add(new SupportingFile("project/plugins.sbt", "project", "plugins.sbt"));
        this.instantiationTypes.put("array", "Seq");
        this.instantiationTypes.put("map", "Map");
        this.importMapping = new HashMap();
        this.importMapping.put("BigDecimal", "scala.math.BigDecimal");
        this.importMapping.put("UUID", "java.util.UUID");
        this.importMapping.put("File", "java.io.File");
        this.importMapping.put("Date", "java.time.LocalDate as Date");
        this.importMapping.put("Timestamp", "java.sql.Timestamp");
        this.importMapping.put("Map", "Map");
        this.importMapping.put("HashMap", "Map");
        this.importMapping.put("Array", "Seq");
        this.importMapping.put("ArrayList", "Seq");
        this.importMapping.put("List", "Seq");
        this.importMapping.put("DateTime", "java.time.LocalDateTime");
        this.importMapping.put("LocalDateTime", "java.time.LocalDateTime");
        this.importMapping.put("LocalDate", "java.time.LocalDate");
        this.importMapping.put("OffsetDateTime", "java.time.OffsetDateTime");
        this.importMapping.put("LocalTime", "java.time.LocalTime");
        this.importMapping.put("Value", "ujson.Value");
    }

    static boolean consumesMimetype(CodegenOperation op, String mimetype) {
        boolean defaultRetValue = true;
        List<Map<String, String>> consumes = op.consumes;
        if (consumes != null) {
            for (Map<String, String> c : consumes) {
                String mt = c.get("mediaType");
                if (!mt.equalsIgnoreCase(mimetype)) continue;
                return true;
            }
            return false;
        }
        return defaultRetValue;
    }

    static String formatMap(Map<?, ?> map) {
        StringBuilder mapAsString = new StringBuilder("{");
        for (Object key : map.keySet().stream().sorted().collect(Collectors.toList())) {
            mapAsString.append(key + " -- " + map.get(key) + ",\n");
        }
        if (mapAsString.length() > 1) {
            mapAsString.delete(mapAsString.length() - 2, mapAsString.length());
        }
        mapAsString.append("}");
        return mapAsString.toString();
    }

    @Override
    public String toApiName(String name) {
        if (name.isEmpty()) {
            return "DefaultApi";
        }
        name = this.sanitizeName(name);
        return StringUtils.camelize(name);
    }

    @Override
    public String apiFilename(String templateName, String tag) {
        String suffix = this.apiTemplateFiles().get(templateName);
        String fn = this.toApiFilename(tag);
        if (templateName.equals(ApiServiceTemplate)) {
            return this.apiInterfaceFileFolder() + "/" + fn + suffix;
        }
        return this.apiFileFolder() + "/" + fn + "Routes" + suffix;
    }

    @Override
    public String modelFilename(String templateName, String modelName) {
        String defaultFilename = super.modelFilename(templateName, modelName);
        if (templateName.equals(ApiServiceTemplate)) {
            String suffix = this.apiTemplateFiles().get(templateName);
            String fn = this.toApiFilename(modelName);
            String path = this.modelFileFolder() + "/" + fn + suffix;
            return path;
        }
        return defaultFilename;
    }

    @Override
    public String apiFileFolder() {
        String folder = this.outputFolder + "/jvm/" + this.sourceFolder + "/" + this.apiPackage().replace('.', File.separatorChar);
        return folder;
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + "/shared/" + this.sourceFolder + "/" + this.modelPackage().replace('.', File.separatorChar);
    }

    public String apiInterfaceFileFolder() {
        return this.outputFolder + "/shared/" + this.sourceFolder + "/" + this.apiPackage().replace('.', File.separatorChar);
    }

    static String capitalise(String p) {
        if (p.length() < 2) {
            return p.toUpperCase(Locale.ROOT);
        }
        String first = "" + p.charAt(0);
        return first.toUpperCase(Locale.ROOT) + p.substring(1);
    }

    private static List<Map<String, Object>> getOperations(Map<String, Object> objs) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Map apiInfo = (Map)objs.get("apiInfo");
        List apis = (List)apiInfo.get("apis");
        for (Map api : apis) {
            Map operations = (Map)api.get("operations");
            result.add(operations);
        }
        return result;
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        List<Map<String, Object>> operations = ScalaCaskServerCodegen.getOperations(objs);
        for (int i = 0; i < operations.size(); ++i) {
            operations.get(i).put("hasMore", i < operations.size() - 1);
        }
        objs.put("operations", operations);
        return super.postProcessSupportingFileData(objs);
    }

    protected String getResourceFolder() {
        String src = this.getSourceFolder();
        List parts = Arrays.stream(src.split("/", -1)).collect(Collectors.toList());
        if (parts.isEmpty()) {
            return "resources";
        }
        String srcMain = String.join((CharSequence)"/", parts.subList(0, parts.size() - 1));
        return srcMain + "/resources";
    }

    @Override
    public void processOpenAPI(OpenAPI openAPI) {
        String jsonOpenAPI = SerializerUtils.toJsonString(openAPI);
        try {
            String outputFile = this.getOutputDir() + "/jvm/" + this.getResourceFolder() + "/openapi.json";
            FileUtils.writeStringToFile((File)new File(outputFile), (String)jsonOpenAPI, (Charset)StandardCharsets.UTF_8);
            this.LOGGER.info("wrote file to {}", (Object)outputFile);
        }
        catch (Exception e) {
            this.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    static List<OperationGroup> group(List<CodegenOperation> operationList) {
        HashMap groupedByPrefix = new HashMap();
        operationList.forEach(op -> {
            String prefix = ScalaCaskServerCodegen.nonParamPathPrefix(op);
            String key = op.httpMethod + " " + prefix;
            if (!op.pathParams.isEmpty()) {
                OperationGroup group = groupedByPrefix.getOrDefault(key, new OperationGroup(op.httpMethod, prefix));
                group.add((CodegenOperation)op);
                groupedByPrefix.put(key, group);
            }
        });
        return groupedByPrefix.values().stream().collect(Collectors.toList());
    }

    static String nonParamPathPrefix(CodegenOperation op) {
        if (op.pathParams.isEmpty()) {
            return op.path;
        }
        String firstParam = ((CodegenParameter)op.pathParams.stream().findFirst().get()).paramName;
        int i = op.path.indexOf(firstParam);
        String path = ScalaCaskServerCodegen.chompSuffix(op.path.substring(0, i - 1), "/");
        return path;
    }

    static List<OperationGroup> createRouteGroups(List<CodegenOperation> operationList) {
        List<OperationGroup> groups = ScalaCaskServerCodegen.group(operationList);
        operationList.forEach(op -> {
            String scalaPath = ScalaCaskServerCodegen.pathWithBracketPlaceholdersRemovedAndXPathIndexAdded(op);
            op.vendorExtensions.put("x-cask-path", scalaPath);
            String annotation = "@cask." + op.httpMethod.toLowerCase(Locale.ROOT);
            op.vendorExtensions.put("x-annotation", annotation);
            for (OperationGroup group : groups) {
                if (group.contains((CodegenOperation)op) || !op.path.startsWith(group.pathPrefix) || !op.httpMethod.equalsIgnoreCase(group.httpMethod)) continue;
                group.add((CodegenOperation)op);
            }
        });
        List<OperationGroup> trimmed = groups.stream().filter(g -> g.operations.size() > 1).map(g -> {
            g.updateAnnotations();
            return g;
        }).collect(Collectors.toList());
        return trimmed;
    }

    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        Map operations = (Map)objs.get("operations");
        List operationList = (List)operations.get("operation");
        objs.put("route-groups", ScalaCaskServerCodegen.createRouteGroups(operationList));
        operationList.forEach(ScalaCaskServerCodegen::postProcessOperation);
        return objs;
    }

    @Override
    public ModelsMap postProcessModels(ModelsMap objs) {
        objs.getModels().stream().map(ModelMap::getModel).forEach(this::postProcessModel);
        return objs;
    }

    private void setDefaultValueForCodegenProperty(CodegenProperty p) {
        if (p.defaultValue == null || p.defaultValue.trim().isEmpty()) {
            p.defaultValue = p.getIsEnumOrRef() ? "null" : ScalaCaskServerCodegen.defaultValueNonOption(p);
        } else if (p.defaultValue.contains("Seq.empty")) {
            p.defaultValue = "Nil";
        }
    }

    private void postProcessModel(CodegenModel model) {
        model.getAllVars().forEach(this::setDefaultValueForCodegenProperty);
        model.getVars().forEach(this::setDefaultValueForCodegenProperty);
        model.getVars().forEach(ScalaCaskServerCodegen::postProcessProperty);
        model.getAllVars().forEach(ScalaCaskServerCodegen::postProcessProperty);
    }

    private static void postProcessOperation(CodegenOperation op) {
        op.httpMethod = op.httpMethod.toLowerCase(Locale.ROOT);
        op.vendorExtensions.put("x-consumes-json", ScalaCaskServerCodegen.consumesMimetype(op, "application/json"));
        op.vendorExtensions.put("x-consumes-xml", ScalaCaskServerCodegen.consumesMimetype(op, "application/xml"));
        op.bodyParams.stream().filter(b -> b.isBodyParam).forEach(p -> {
            p.vendorExtensions.put("x-consumes-json", ScalaCaskServerCodegen.consumesMimetype(op, "application/json"));
            p.vendorExtensions.put("x-consumes-xml", ScalaCaskServerCodegen.consumesMimetype(op, "application/xml"));
        });
        op.allParams.forEach(p -> p.vendorExtensions.put("x-container-type", ScalaCaskServerCodegen.containerType(p.dataType)));
        op.bodyParams.forEach(p -> p.vendorExtensions.put("x-container-type", ScalaCaskServerCodegen.containerType(p.dataType)));
        String paramList = op.allParams.stream().map(p -> p.paramName).collect(Collectors.joining(", "));
        op.vendorExtensions.put("x-param-list", paramList);
        Stream<String> typed = op.allParams.stream().map(p -> p.paramName + " : " + ScalaCaskServerCodegen.asScalaDataType(p, p.required, false));
        op.vendorExtensions.put("x-param-list-typed", String.join((CharSequence)", ", typed.collect(Collectors.toList())));
        Stream<String> typedJson = op.allParams.stream().map(p -> p.paramName + " : " + ScalaCaskServerCodegen.asScalaDataType(p, p.required, true));
        op.vendorExtensions.put("x-param-list-typed-json", String.join((CharSequence)", ", typedJson.collect(Collectors.toList())));
        op.vendorExtensions.put("x-cask-path-typed", ScalaCaskServerCodegen.routeArgs(op));
        op.vendorExtensions.put("x-query-args", ScalaCaskServerCodegen.queryArgs(op));
        List responses = op.responses.stream().map(r -> r.dataType).filter(Objects::nonNull).collect(Collectors.toList());
        op.vendorExtensions.put("x-response-type", responses.isEmpty() ? "Unit" : String.join((CharSequence)" | ", responses));
    }

    private static void postProcessProperty(CodegenProperty p) {
        p.vendorExtensions.put("x-datatype-model", ScalaCaskServerCodegen.asScalaDataType(p, p.required, false));
        p.vendorExtensions.put("x-defaultValue-model", ScalaCaskServerCodegen.defaultValue(p, p.required, p.defaultValue));
        String dataTypeData = ScalaCaskServerCodegen.asScalaDataType(p, p.required, true);
        p.vendorExtensions.put("x-datatype-data", dataTypeData);
        p.vendorExtensions.put("x-containertype-data", ScalaCaskServerCodegen.containerType(dataTypeData));
        p.vendorExtensions.put("x-defaultValue-data", ScalaCaskServerCodegen.defaultValueNonOption(p, p.defaultValue));
        p.vendorExtensions.put("x-wrap-in-optional", !p.required && !p.isArray && !p.isMap);
        boolean hasItemModel = p.items != null && p.items.isModel;
        boolean isObjectArray = p.isArray && hasItemModel;
        boolean isOptionalObj = !p.required && p.isModel;
        p.vendorExtensions.put("x-map-asModel", (isOptionalObj || isObjectArray) && !p.isMap);
        p.vendorExtensions.put("x-deserialize-asModelMap", p.isMap && hasItemModel);
        if (p.pattern != null && p.pattern.startsWith("/") && p.pattern.endsWith("/")) {
            p.pattern = p.pattern.substring(1, p.pattern.length() - 1);
        }
    }

    private static String pathWithBracketPlaceholdersRemovedAndXPathIndexAdded(CodegenOperation op) {
        String[] items = op.path.split("/", -1);
        Object scalaPath = "";
        for (int i = 0; i < items.length; ++i) {
            String nextPart = ScalaCaskServerCodegen.hasBrackets(items[i]) ? ":" + ScalaCaskServerCodegen.chompBrackets(items[i]) : items[i];
            scalaPath = i != items.length - 1 ? (String)scalaPath + nextPart + "/" : (String)scalaPath + nextPart;
        }
        return scalaPath;
    }

    private static CodegenParameter pathParamForName(CodegenOperation op, String pathParam) {
        CodegenParameter param = op.pathParams.stream().filter(p -> p.paramName.equals(pathParam)).findFirst().get();
        if (param == null) {
            throw new RuntimeException("Bug: path param " + pathParam + " not found");
        }
        return param;
    }

    private static String routeArgs(CodegenOperation op) {
        Stream<String> pathParamNames = Arrays.stream(op.path.split("/", -1)).filter(ScalaCaskServerCodegen::hasBrackets).map(p -> {
            CodegenParameter param = ScalaCaskServerCodegen.pathParamForName(op, ScalaCaskServerCodegen.chompBrackets(p));
            return param.paramName + " : " + ScalaCaskServerCodegen.asScalaDataType(param, param.required, true);
        });
        List pathList = pathParamNames.collect(Collectors.toList());
        pathList.add("request: cask.Request");
        Stream<String> queryParams = op.queryParams.stream().map(p -> {
            p.vendorExtensions.put("x-default-value", ScalaCaskServerCodegen.defaultValue(p));
            return p.paramName + " : " + ScalaCaskServerCodegen.asScalaDataType(p, p.required, true, true);
        });
        pathList.addAll(queryParams.collect(Collectors.toList()));
        return pathList.isEmpty() ? "" : String.join((CharSequence)", ", pathList);
    }

    private static String defaultValue(CodegenParameter p) {
        return ScalaCaskServerCodegen.defaultValue(p, p.required, p.defaultValue);
    }

    private static String defaultValue(IJsonSchemaValidationProperties p, boolean required, String fallbackDefaultValue) {
        if (!(required || p.getIsArray() || p.getIsMap())) {
            return "None";
        }
        return ScalaCaskServerCodegen.defaultValueNonOption(p, fallbackDefaultValue);
    }

    private static String defaultValueNonOption(IJsonSchemaValidationProperties p, String fallbackDefaultValue) {
        if (p.getIsArray()) {
            if (p.getUniqueItems()) {
                return "Set.empty";
            }
            return "Nil";
        }
        if (p.getIsMap()) {
            return "Map.empty";
        }
        if (p.getIsNumber()) {
            return "0";
        }
        if (p.getIsEnum()) {
            return fallbackDefaultValue;
        }
        if (p.getIsBoolean()) {
            return "false";
        }
        if (p.getIsUuid()) {
            return "java.util.UUID.randomUUID()";
        }
        if (p.getIsString()) {
            return "\"\"";
        }
        return fallbackDefaultValue;
    }

    private static String defaultValueNonOption(CodegenProperty p) {
        if (p.getIsArray()) {
            return "Nil";
        }
        if (p.getIsMap()) {
            return "Map.empty";
        }
        if (p.isNumber || p.isNumeric) {
            return "0";
        }
        if (p.isBoolean) {
            return "false";
        }
        if (p.isUuid) {
            return "java.util.UUID.randomUUID()";
        }
        if (p.isModel) {
            return "null";
        }
        if (p.isDate || p.isDateTime) {
            return "null";
        }
        if (p.isString) {
            return "\"\"";
        }
        return p.defaultValue;
    }

    @Override
    public CodegenProperty fromProperty(String name, Schema schema) {
        CodegenProperty property = super.fromProperty(name, schema);
        if (ModelUtils.isFreeFormObject(schema)) {
            property.dataType = "Value";
            property.baseType = "Value";
        }
        return property;
    }

    @Override
    public String getTypeDeclaration(Schema schema) {
        if (ModelUtils.isFreeFormObject(schema)) {
            return "Value";
        }
        return super.getTypeDeclaration(schema);
    }

    @Override
    public String toModelImport(String name) {
        String result = super.toModelImport(name);
        if (this.importMapping.containsKey(name)) {
            return (String)this.importMapping.get(name);
        }
        return result;
    }

    private static String queryArgs(CodegenOperation op) {
        List list = op.queryParams.stream().map(p -> p.paramName).collect(Collectors.toList());
        String prefix = list.isEmpty() ? "" : ", ";
        return prefix + String.join((CharSequence)", ", list);
    }

    private static String asScalaDataType(IJsonSchemaValidationProperties param, boolean required, boolean useJason) {
        return ScalaCaskServerCodegen.asScalaDataType(param, required, useJason, !useJason);
    }

    private static String asScalaDataType(IJsonSchemaValidationProperties param, boolean required, boolean useJason, boolean allowOptional) {
        String dataSuffix;
        Object dataType = param.getIsModel() && useJason ? param.getDataType() + "Data" : param.getDataType();
        String string = dataSuffix = useJason && param.getItems() != null && param.getItems().getIsModel() ? "Data" : "";
        if (((String)dataType).startsWith("List[")) {
            dataType = ((String)dataType).replace("List[", "Seq[");
            dataType = ((String)dataType).replace("]", dataSuffix + "]");
        } else if (((String)dataType).startsWith("Set[")) {
            dataType = ((String)dataType).replace("]", dataSuffix + "]");
        } else if (!required && allowOptional) {
            dataType = "Option[" + (String)dataType + "]";
        }
        return dataType;
    }

    private static String chompBrackets(String str) {
        return str.replace("{", "").replace("}", "");
    }

    private static String chompSuffix(String str, String suffix) {
        return str.endsWith(suffix) ? ScalaCaskServerCodegen.chompSuffix(str.substring(0, str.length() - suffix.length()), suffix) : str;
    }

    private static boolean hasBrackets(String str) {
        return str.matches("^\\{(.*)\\}$");
    }

    static String containerType(String dataType) {
        String fixedForList = dataType.replaceAll(".*\\[(.*)\\]", "$1");
        String[] parts = fixedForList.split(",");
        return parts[parts.length - 1];
    }

    public static class OperationGroup {
        List<CodegenOperation> operations = new ArrayList<CodegenOperation>();
        final String pathPrefix;
        final String httpMethod;
        final String caskAnnotation;
        final String methodName;

        public boolean hasGroupQueryParams() {
            return this.operations.stream().flatMap(op -> op.queryParams.stream()).count() > 0L;
        }

        public List<CodegenParameter> getGroupQueryParams() {
            List<CodegenParameter> list = this.operations.stream().flatMap(op -> op.queryParams.stream()).map(p -> {
                CodegenParameter copy = p.copy();
                copy.vendorExtensions.put("x-default-value", ScalaCaskServerCodegen.defaultValue(p));
                copy.required = false;
                copy.dataType = ScalaCaskServerCodegen.asScalaDataType(copy, false, true, true);
                copy.defaultValue = ScalaCaskServerCodegen.defaultValue(copy);
                return copy;
            }).collect(Collectors.toList());
            return list;
        }

        public String toString() {
            List ops = this.operations.stream().map(o -> o.path + "\n").collect(Collectors.toList());
            return this.httpMethod + " " + this.pathPrefix + " w/ " + this.operations.size() + " operations:\n" + String.join((CharSequence)"", ops);
        }

        public OperationGroup(String httpMethod, String pathPrefix) {
            this.httpMethod = httpMethod;
            this.pathPrefix = pathPrefix;
            this.caskAnnotation = "@cask." + httpMethod.toLowerCase(Locale.ROOT);
            List stripped = Arrays.stream(pathPrefix.split("/", -1)).map(ScalaCaskServerCodegen::capitalise).collect(Collectors.toList());
            this.methodName = "routeWorkAroundFor" + ScalaCaskServerCodegen.capitalise(httpMethod) + String.join((CharSequence)"", stripped);
        }

        public void add(CodegenOperation op) {
            if (!op.path.startsWith(this.pathPrefix)) {
                throw new IllegalArgumentException("inconsistent path: " + this.pathPrefix);
            }
            if (!op.httpMethod.equals(this.httpMethod)) {
                throw new IllegalArgumentException("inconsistent method: " + this.httpMethod);
            }
            ArrayList<ParamPart> pathParts = new ArrayList<ParamPart>();
            List parts = Arrays.stream(op.path.substring(this.pathPrefix.length()).split("/", -1)).filter(p -> !p.isEmpty()).collect(Collectors.toList());
            for (int i = 0; i < parts.size(); ++i) {
                String p2 = (String)parts.get(i);
                ParamPart pp = ScalaCaskServerCodegen.hasBrackets(p2) ? new ParamPart(ScalaCaskServerCodegen.chompBrackets(p2), ScalaCaskServerCodegen.pathParamForName(op, ScalaCaskServerCodegen.chompBrackets(p2))) : new ParamPart(p2, null);
                pathParts.add(pp);
            }
            List<ParamPart> paramPathParts = pathParts.stream().filter(p -> p.isParam).collect(Collectors.toList());
            if (!paramPathParts.isEmpty()) {
                String lastParamName = ((ParamPart)paramPathParts.get((int)(paramPathParts.size() - 1))).name;
                paramPathParts.forEach(p -> {
                    p.hasMoreParams = !p.name.equals(lastParamName);
                });
            }
            if (!pathParts.isEmpty()) {
                ((ParamPart)pathParts.get((int)(pathParts.size() - 1))).hasMore = false;
            }
            op.vendorExtensions.put("x-path-remaining", pathParts);
            op.vendorExtensions.put("x-has-path-remaining", !paramPathParts.isEmpty());
            this.operations.add(op);
        }

        public boolean contains(CodegenOperation op) {
            return this.operations.contains(op);
        }

        public void updateAnnotations() {
            this.operations.forEach(op -> {
                String annotation = op.vendorExtensions.get("x-annotation").toString();
                String conflicts = String.join((CharSequence)", ", this.operations.stream().map(o -> o.path).collect(Collectors.toList()));
                op.vendorExtensions.put("x-annotation", "// conflicts with [" + conflicts + "] after" + this.pathPrefix + ", ignoring " + annotation);
            });
            this.operations = this.operations.stream().sorted((a, b) -> a.pathParams.size() - b.pathParams.size()).collect(Collectors.toList());
        }
    }

    public static class ParamPart {
        final CodegenParameter param;
        final String name;
        final boolean isParam;
        boolean hasMore;
        boolean hasMoreParams;
        final String conversion;

        public ParamPart(String name, CodegenParameter param) {
            this.name = name;
            this.param = param;
            this.isParam = param != null;
            this.hasMore = true;
            this.conversion = !this.isParam || param.isString ? "" : ".to" + param.dataType;
        }
    }
}

