/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github.security;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class DangerousTriggersRecipe
extends Recipe {
    private static final Set<String> DANGEROUS_TRIGGERS = new HashSet<String>(Arrays.asList("pull_request_target", "workflow_run"));

    public String getDisplayName() {
        return "Find dangerous workflow triggers";
    }

    public String getDescription() {
        return "Detects use of fundamentally insecure workflow triggers like `pull_request_target` and `workflow_run`. These triggers run with elevated privileges and are almost always used insecurely, potentially allowing code injection from untrusted sources. Based on [zizmor's dangerous-triggers audit](https://github.com/woodruffw/zizmor/blob/main/crates/zizmor/src/audit/dangerous_triggers.rs).";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new DangerousTriggersVisitor();
    }

    @Generated
    public DangerousTriggersRecipe() {
    }

    @Generated
    public String toString() {
        return "DangerousTriggersRecipe()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DangerousTriggersRecipe)) {
            return false;
        }
        DangerousTriggersRecipe other = (DangerousTriggersRecipe)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DangerousTriggersRecipe;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    private static class DangerousTriggersVisitor
    extends YamlIsoVisitor<ExecutionContext> {
        private DangerousTriggersVisitor() {
        }

        public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
            Yaml.Mapping.Entry mappingEntry = super.visitMappingEntry(entry, (Object)ctx);
            if (this.isOnEntry(mappingEntry)) {
                return this.checkTriggersInOnEntry(mappingEntry);
            }
            return mappingEntry;
        }

        private boolean isOnEntry(Yaml.Mapping.Entry entry) {
            if (!(entry.getKey() instanceof Yaml.Scalar)) {
                return false;
            }
            String key = ((Yaml.Scalar)entry.getKey()).getValue();
            return "on".equals(key);
        }

        private Yaml.Mapping.Entry checkTriggersInOnEntry(Yaml.Mapping.Entry onEntry) {
            block4: {
                Yaml.Block onValue;
                block5: {
                    block3: {
                        onValue = onEntry.getValue();
                        if (!(onValue instanceof Yaml.Scalar)) break block3;
                        String trigger = ((Yaml.Scalar)onValue).getValue();
                        if (DANGEROUS_TRIGGERS.contains(trigger)) {
                            String message = this.getDangerousTriggersMessage(trigger);
                            return (Yaml.Mapping.Entry)SearchResult.found((Tree)onEntry, (String)message);
                        }
                        break block4;
                    }
                    if (!(onValue instanceof Yaml.Sequence)) break block5;
                    Yaml.Sequence sequence = (Yaml.Sequence)onValue;
                    for (Yaml.Sequence.Entry seqEntry : sequence.getEntries()) {
                        if (!(seqEntry.getBlock() instanceof Yaml.Scalar)) continue;
                        String trigger = ((Yaml.Scalar)seqEntry.getBlock()).getValue();
                        if (!DANGEROUS_TRIGGERS.contains(trigger)) continue;
                        String message = this.getDangerousTriggersMessage(trigger);
                        return (Yaml.Mapping.Entry)SearchResult.found((Tree)onEntry, (String)message);
                    }
                    break block4;
                }
                if (!(onValue instanceof Yaml.Mapping)) break block4;
                Yaml.Mapping mapping = (Yaml.Mapping)onValue;
                for (Yaml.Mapping.Entry triggerEntry : mapping.getEntries()) {
                    if (!(triggerEntry.getKey() instanceof Yaml.Scalar)) continue;
                    String trigger = ((Yaml.Scalar)triggerEntry.getKey()).getValue();
                    if (!DANGEROUS_TRIGGERS.contains(trigger)) continue;
                    String message = this.getDangerousTriggersMessage(trigger);
                    return (Yaml.Mapping.Entry)SearchResult.found((Tree)onEntry, (String)message);
                }
            }
            return onEntry;
        }

        private String getDangerousTriggersMessage(String trigger) {
            switch (trigger) {
                case "pull_request_target": {
                    return "The 'pull_request_target' trigger is almost always used insecurely. It runs with write permissions in the context of the target repository, potentially allowing code injection from pull requests. Consider using 'pull_request' instead, or implement proper isolation.";
                }
                case "workflow_run": {
                    return "The 'workflow_run' trigger is almost always used insecurely. It can trigger workflows with sensitive permissions based on external events. Consider using more specific triggers with explicit safety checks.";
                }
            }
            return String.format("The '%s' trigger is considered insecure and should be avoided.", trigger);
        }
    }
}

