/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Collections;
import java.util.Set;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

@NullMarked
public class BigDecimalDoubleConstructorRecipe
extends Recipe {
    public String getDisplayName() {
        return "`new BigDecimal(double)` should not be used";
    }

    public String getDescription() {
        return "Use of `new BigDecimal(double)` constructor can lead to loss of precision. Use `BigDecimal.valueOf(double)` instead.\nFor example writing `new BigDecimal(0.1)` does not create a `BigDecimal` which is exactly equal to `0.1`, but it is equal to `0.1000000000000000055511151231257827021181583404541015625`. This is because `0.1` cannot be represented exactly as a double (or, for that matter, as a binary fraction of any finite length).";
    }

    public Set<String> getTags() {
        return Collections.singleton("RSPEC-S2111");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
            JavaTemplate bigDecimalDoubleConstructor;
            JavaTemplate after;

            public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                JavaTemplate.Matcher matcher;
                if (this.bigDecimalDoubleConstructor == null) {
                    this.bigDecimalDoubleConstructor = JavaTemplate.builder((String)"new java.math.BigDecimal(#{d:any(double)})").bindType("java.math.BigDecimal").build();
                }
                if ((matcher = this.bigDecimalDoubleConstructor.matcher(this.getCursor())).find()) {
                    if (this.after == null) {
                        this.after = JavaTemplate.builder((String)"java.math.BigDecimal.valueOf(#{d:any(double)})").bindType("java.math.BigDecimal").build();
                    }
                    return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                }
                return super.visitNewClass(elem, (Object)ctx);
            }
        };
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.math.BigDecimal", Boolean.valueOf(true)), new UsesMethod("java.math.BigDecimal <init>(..)", true)}), (TreeVisitor)javaVisitor);
    }
}

