/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.mockito;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.staticanalysis.kotlin.KotlinFileChecker;

public class CleanupMockitoImports
extends Recipe {
    public String getDisplayName() {
        return "Cleanup Mockito imports";
    }

    public String getDescription() {
        return "Removes unused `org.mockito` import symbols, unless its possible they are associated with method invocations having null or unknown type information.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("org.mockito.*", Boolean.valueOf(false)), Preconditions.not((TreeVisitor)new KotlinFileChecker())}), (TreeVisitor)new CleanupMockitoImportsVisitor());
    }

    private static class CleanupMockitoImportsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final List<String> MOCKITO_METHOD_NAMES = Arrays.asList("after", "atLeast", "atLeastOnce", "atMost", "calls", "clearInvocations", "doAnswer", "doCallRealMethod", "doNothing", "doReturn", "doThrow", "given", "ignoreStubs", "inOrder", "mock", "mockingDetails", "never", "only", "reset", "spy", "stub", "stubVoid", "then", "timeout", "times", "verify", "verifyNoInteractions", "verifyNoMoreInteractions", "verifyZeroInteractions", "when", "will", "willAnswer", "willCallRealMethod", "willDoNothing", "willReturn", "willThrow");

        private CleanupMockitoImportsVisitor() {
        }

        public @Nullable J preVisit(J tree, ExecutionContext ctx) {
            this.stopAfterPreVisit();
            if (tree instanceof JavaSourceFile) {
                JavaSourceFile sf = (JavaSourceFile)tree;
                List mockitoMethodsUsed = (List)new MockitoMethodTypeVisitor().reduce((Tree)sf, new ArrayList());
                List unknownTypeMethodInvocationNames = (List)new WellFormedMockitoMethodTypeVisitor().reduce((Tree)sf, new ArrayList());
                List qualifiedMethodInvocationNames = (List)new QualifiedMockitoMethodTypeVisitor().reduce((Tree)sf, new ArrayList());
                for (J.Import _import : sf.getImports()) {
                    if (!_import.getPackageName().startsWith("org.mockito")) continue;
                    if (_import.isStatic()) {
                        String staticName = _import.getQualid().getSimpleName();
                        if (mockitoMethodsUsed.contains(staticName)) continue;
                        if ("*".equals(staticName)) {
                            this.maybeRemoveImport(_import.getPackageName() + "." + _import.getClassName());
                            continue;
                        }
                        if (unknownTypeMethodInvocationNames.contains(staticName)) continue;
                        String fullyQualifiedName = _import.getPackageName() + "." + _import.getClassName() + "." + staticName;
                        this.maybeRemoveImport(fullyQualifiedName);
                        continue;
                    }
                    if (!qualifiedMethodInvocationNames.isEmpty()) continue;
                    this.maybeRemoveImport(_import.getPackageName() + "." + _import.getClassName());
                }
            }
            return tree;
        }

        private static class MockitoMethodTypeVisitor
        extends JavaIsoVisitor<List<String>> {
            private MockitoMethodTypeVisitor() {
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, List<String> methods) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, methods);
                if (MOCKITO_METHOD_NAMES.contains(mi.getSimpleName()) && mi.getSelect() == null && TypeUtils.isWellFormedType((JavaType)mi.getType())) {
                    methods.add(mi.getSimpleName());
                }
                return mi;
            }
        }

        private static class WellFormedMockitoMethodTypeVisitor
        extends JavaIsoVisitor<List<String>> {
            private WellFormedMockitoMethodTypeVisitor() {
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, List<String> missingMethods) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, missingMethods);
                if (MOCKITO_METHOD_NAMES.contains(mi.getSimpleName()) && !TypeUtils.isWellFormedType((JavaType)mi.getType())) {
                    missingMethods.add(mi.getSimpleName());
                }
                return mi;
            }
        }

        private static class QualifiedMockitoMethodTypeVisitor
        extends JavaIsoVisitor<List<String>> {
            private QualifiedMockitoMethodTypeVisitor() {
            }

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, List<String> qualifiedMethods) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, qualifiedMethods);
                if (MOCKITO_METHOD_NAMES.contains(mi.getSimpleName()) && mi.getSelect() != null && TypeUtils.isAssignableTo((String)"org.mockito.Mockito", (JavaType)mi.getSelect().getType())) {
                    qualifiedMethods.add(mi.getSimpleName());
                }
                return mi;
            }
        }
    }
}

