/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.mockito;

import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;

public class RemoveTimesZeroAndOne
extends Recipe {
    private static final MethodMatcher verifyMatcher = new MethodMatcher("org.mockito.Mockito verify(..)", false);
    private static final MethodMatcher timesMatcher = new MethodMatcher("org.mockito.Mockito times(int)", false);

    public String getDisplayName() {
        return "Remove `Mockito.times(0)` and `Mockito.times(1)`";
    }

    public String getDescription() {
        return "Remove `Mockito.times(0)` and `Mockito.times(1)` from `Mockito.verify()` calls.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod(verifyMatcher), new UsesMethod(timesMatcher)}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public // Could not load outer class - annotation placement on inner may be incorrect
             @Nullable J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                if (timesMatcher.matches((MethodCall)mi) && J.Literal.isLiteralValue((Expression)((Expression)mi.getArguments().get(0)), (Object)0)) {
                    this.maybeAddImport("org.mockito.Mockito", "never");
                    this.maybeRemoveImport("org.mockito.Mockito.times");
                    return (J.MethodInvocation)JavaTemplate.builder((String)"never()").staticImports(new String[]{"org.mockito.Mockito.never"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"mockito-core"})).build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[0]);
                }
                if (verifyMatcher.matches((MethodCall)mi) && mi.getArguments().size() == 2) {
                    J.MethodInvocation times = (J.MethodInvocation)mi.getArguments().get(1);
                    if (timesMatcher.matches((MethodCall)times) && J.Literal.isLiteralValue((Expression)((Expression)times.getArguments().get(0)), (Object)1)) {
                        this.maybeRemoveImport("org.mockito.Mockito.times");
                        JavaType.Method methodType = mi.getMethodType();
                        if (!methodType.getParameterTypes().isEmpty()) {
                            methodType = methodType.withParameterNames(methodType.getParameterNames().subList(0, 1)).withParameterTypes(methodType.getParameterTypes().subList(0, 1));
                            return mi.withArguments(mi.getArguments().subList(0, 1)).withMethodType(methodType).withName(mi.getName().withType((JavaType)methodType));
                        }
                        return mi.withArguments(mi.getArguments().subList(0, 1));
                    }
                }
                return mi;
            }
        });
    }
}

