/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.upgrade.customRecipes;

import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.camel.upgrade.AbstractCamelJavaVisitor;
import org.apache.camel.upgrade.RecipesUtil;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.tree.J;

public class MoveGetterToExtendedCamelContext
extends Recipe {
    private static final String MATCHER_GET_NAME_RESOLVER = "org.apache.camel.ExtendedCamelContext getComponentNameResolver()";
    private static final String MATCHER_GET_MODEL_JAXB_CONTEXT_FACTORY = "org.apache.camel.ExtendedCamelContext getModelJAXBContextFactory()";
    private static final String MATCHER_GET_MODEL_TO_XML_DUMPER = "org.apache.camel.ExtendedCamelContext getModelToXMLDumper()";
    private static final Pattern ABSTRACT_CONTEXT_TYPE = Pattern.compile("org.apache.camel.impl.engine.AbstractCamelContext");
    private static final String MATCHER_CONTEXT_GET_EXT = "org.apache.camel.CamelContext getExtension(java.lang.Class)";
    @Option(example="TODO Provide a usage example for the docs", displayName="Method name", description="Name of the method on external camel context.")
    public String oldMethodName;

    public String getDisplayName() {
        return "Move getter from context to ExtendedCamelContext.";
    }

    public String getDescription() {
        return "Move getter from context to ExtendedCamelContext";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return RecipesUtil.newVisitor(new AbstractCamelJavaVisitor(){

            @Override
            protected J.MethodInvocation doVisitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = super.doVisitMethodInvocation(method, ctx);
                if (this.getMethodMatcher(this.getOldMethodMatcher()).matches(mi, false)) {
                    mi = (J.MethodInvocation)JavaTemplate.builder((String)this.getNewMethodFromExternalContextContext()).build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[]{mi.getSelect()});
                    mi = mi.withArguments(method.getArguments());
                }
                return mi;
            }

            private String getOldMethodMatcher() {
                return "org.apache.camel.impl.engine.AbstractCamelContext " + MoveGetterToExtendedCamelContext.this.oldMethodName + "(..)";
            }

            private String getNewMethodFromExternalContextContext() {
                return "#{any(org.apache.camel.CamelContext)}.getCamelContextExtension()." + MoveGetterToExtendedCamelContext.this.oldMethodName + "()";
            }
        });
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MoveGetterToExtendedCamelContext)) {
            return false;
        }
        MoveGetterToExtendedCamelContext other = (MoveGetterToExtendedCamelContext)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$oldMethodName = this.oldMethodName;
        String other$oldMethodName = other.oldMethodName;
        return !(this$oldMethodName == null ? other$oldMethodName != null : !this$oldMethodName.equals(other$oldMethodName));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof MoveGetterToExtendedCamelContext;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oldMethodName = this.oldMethodName;
        result = result * 59 + ($oldMethodName == null ? 43 : $oldMethodName.hashCode());
        return result;
    }

    @Generated
    public MoveGetterToExtendedCamelContext() {
    }

    @Generated
    public MoveGetterToExtendedCamelContext(String oldMethodName) {
        this.oldMethodName = oldMethodName;
    }
}

