/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.v2migration.internal.utils;

import java.util.Collections;
import java.util.List;
import org.openrewrite.Tree;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;
import software.amazon.awssdk.annotations.SdkInternalApi;

@SdkInternalApi
public final class IdentifierUtils {
    private IdentifierUtils() {
    }

    public static J.Identifier makeId(String simpleName, JavaType type) {
        return new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), simpleName, type, null);
    }

    public static String simpleName(JavaType.Parameterized parameterized) {
        StringBuilder sb = new StringBuilder(parameterized.getClassName()).append('<');
        List typeParams = parameterized.getTypeParameters();
        for (int i = 0; i < typeParams.size(); ++i) {
            JavaType.FullyQualified fqParamType = TypeUtils.asFullyQualified((JavaType)((JavaType)typeParams.get(i)));
            if (fqParamType == null) {
                throw new RuntimeException("Encountered non fully qualified type");
            }
            sb.append(fqParamType.getClassName());
            if (i + 1 == typeParams.size()) continue;
            sb.append(", ");
        }
        return sb.append('>').toString();
    }
}

