/*
 * Decompiled with CFR 0.152.
 */
package tech.picnic.errorprone.refasterrules;

import java.util.Arrays;
import java.util.List;
import org.jspecify.annotations.NullMarked;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.template.internal.AbstractRefasterJavaVisitor;
import org.openrewrite.java.tree.J;

public class ImmutableTableRulesRecipes
extends Recipe {
    public String getDisplayName() {
        return "`ImmutableTableRules` Refaster recipes";
    }

    public String getDescription() {
        return "Refaster rules related to expressions dealing with `ImmutableTable`s.\n[Source](https://error-prone.picnic.tech/refasterrules/ImmutableTableRules).";
    }

    public List<Recipe> getRecipeList() {
        return Arrays.asList(new Recipe[]{new ImmutableTableBuilderRecipe(), new ImmutableTableBuilderBuildOrThrowRecipe(), new CellToImmutableTableRecipe(), new ImmutableTableOfRecipe()});
    }

    @NullMarked
    public static class ImmutableTableBuilderRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableTableRules.ImmutableTableBuilder`";
        }

        public String getDescription() {
            return "Prefer `ImmutableTable#builder()` over the associated constructor.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitNewClass(J.NewClass elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"new com.google.common.collect.ImmutableTable.Builder<>()").bindType("com.google.common.collect.ImmutableTable.Builder<R, C, V>").genericTypes(new String[]{"R", "C", "V"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableTable.builder()").bindType("com.google.common.collect.ImmutableTable.Builder<R, C, V>").genericTypes(new String[]{"R", "C", "V"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitNewClass(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)new UsesMethod("com.google.common.collect.ImmutableTable.Builder <init>(..)", true), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ImmutableTableBuilderBuildOrThrowRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableTableRules.ImmutableTableBuilderBuildOrThrow`";
        }

        public String getDescription() {
            return "Prefer `ImmutableTable.Builder#buildOrThrow()` over the less explicit `ImmutableTable.Builder#build()`.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"#{builder:any(com.google.common.collect.ImmutableTable.Builder<R, C, V>)}.build()").bindType("com.google.common.collect.ImmutableTable<R, C, V>").genericTypes(new String[]{"R", "C", "V"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"#{builder:any(com.google.common.collect.ImmutableTable.Builder<R, C, V>)}.buildOrThrow()").bindType("com.google.common.collect.ImmutableTable<R, C, V>").genericTypes(new String[]{"R", "C", "V"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableTable", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableTable.Builder build(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class CellToImmutableTableRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableTableRules.CellToImmutableTable`";
        }

        public String getDescription() {
            return "Prefer `ImmutableTable#of(Object, Object, Object)` over more contrived alternatives.";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before$0;
                JavaTemplate before$1;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before$0 == null) {
                        this.before$0 = JavaTemplate.builder((String)"com.google.common.collect.ImmutableTable.<R, C, V>builder().put(#{cell:any(com.google.common.collect.Table.Cell<? extends R, ? extends C, ? extends V>)}).buildOrThrow()").bindType("com.google.common.collect.ImmutableTable<R, C, V>").genericTypes(new String[]{"R", "C", "V"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before$0.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableTable.of(#{cell:any(com.google.common.collect.Table.Cell<? extends R, ? extends C, ? extends V>)}.getRowKey(), #{cell}.getColumnKey(), #{cell}.getValue())").bindType("com.google.common.collect.ImmutableTable<R, C, V>").genericTypes(new String[]{"R", "C", "V"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    if (this.before$1 == null) {
                        this.before$1 = JavaTemplate.builder((String)"java.util.stream.Stream.of(#{cell:any(com.google.common.collect.Table.Cell<? extends R, ? extends C, ? extends V>)}).collect(com.google.common.collect.ImmutableTable.toImmutableTable(com.google.common.collect.Table.Cell::getRowKey, com.google.common.collect.Table.Cell::getColumnKey, com.google.common.collect.Table.Cell::getValue))").bindType("com.google.common.collect.ImmutableTable<R, C, V>").genericTypes(new String[]{"R", "C", "V"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before$1.matcher(this.getCursor())).find()) {
                        this.maybeRemoveImport("java.util.stream.Stream");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableTable");
                        this.maybeRemoveImport("com.google.common.collect.ImmutableTable.toImmutableTable");
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableTable.of(#{cell:any(com.google.common.collect.Table.Cell<? extends R, ? extends C, ? extends V>)}.getRowKey(), #{cell}.getColumnKey(), #{cell}.getValue())").bindType("com.google.common.collect.ImmutableTable<R, C, V>").genericTypes(new String[]{"R", "C", "V"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[]{matcher.parameter(0)}), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableTable", Boolean.valueOf(true)), Preconditions.or((TreeVisitor[])new TreeVisitor[]{Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod("com.google.common.collect.ImmutableTable builder(..)", true), new UsesMethod("com.google.common.collect.ImmutableTable.Builder buildOrThrow(..)", true), new UsesMethod("com.google.common.collect.ImmutableTable.Builder put(..)", true)}), Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("java.util.stream.Stream", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableTable toImmutableTable(..)", true), new UsesMethod("java.util.stream.Stream collect(..)", true), new UsesMethod("java.util.stream.Stream of(..)", true)})})}), (TreeVisitor)javaVisitor);
        }
    }

    @NullMarked
    public static class ImmutableTableOfRecipe
    extends Recipe {
        public String getDisplayName() {
            return "Refaster template `ImmutableTableRules.ImmutableTableOf`";
        }

        public String getDescription() {
            return "Prefer `ImmutableTable#of()` over more contrived alternatives .";
        }

        public TreeVisitor<?, ExecutionContext> getVisitor() {
            AbstractRefasterJavaVisitor javaVisitor = new AbstractRefasterJavaVisitor(){
                JavaTemplate before;
                JavaTemplate after;

                public J visitMethodInvocation(J.MethodInvocation elem, ExecutionContext ctx) {
                    JavaTemplate.Matcher matcher;
                    if (this.before == null) {
                        this.before = JavaTemplate.builder((String)"com.google.common.collect.ImmutableTable.<R, C, V>builder().buildOrThrow()").bindType("com.google.common.collect.ImmutableTable<R, C, V>").genericTypes(new String[]{"R", "C", "V"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                    }
                    if ((matcher = this.before.matcher(this.getCursor())).find()) {
                        if (this.after == null) {
                            this.after = JavaTemplate.builder((String)"com.google.common.collect.ImmutableTable.of()").bindType("com.google.common.collect.ImmutableTable<R, C, V>").genericTypes(new String[]{"R", "C", "V"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"guava-33"})).build();
                        }
                        return this.embed(this.after.apply(this.getCursor(), elem.getCoordinates().replace(), new Object[0]), this.getCursor(), ctx, new AbstractRefasterJavaVisitor.EmbeddingOption[]{AbstractRefasterJavaVisitor.EmbeddingOption.SHORTEN_NAMES});
                    }
                    return super.visitMethodInvocation(elem, (Object)ctx);
                }
            };
            return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesType("com.google.common.collect.ImmutableTable", Boolean.valueOf(true)), new UsesMethod("com.google.common.collect.ImmutableTable builder(..)", true), new UsesMethod("com.google.common.collect.ImmutableTable.Builder buildOrThrow(..)", true)}), (TreeVisitor)javaVisitor);
        }
    }
}

