/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.maven.table;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import lombok.Generated;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

@JsonIgnoreType
public class DependencyResolutions
extends DataTable<Row> {
    public DependencyResolutions(Recipe recipe) {
        super(recipe, "Dependency resolutions", "Latencies of individual dependency resolution requests and their outcomes.");
    }

    public static final class Row {
        @Option(example="groupId", displayName="Group", description="The first part of a dependency coordinate `com.google.guava:guava:VERSION`.")
        private final String groupId;
        @Column(displayName="Artifact", description="The second part of a dependency coordinate `com.google.guava:guava:VERSION`.")
        private final String artifactId;
        @Column(displayName="Version", description="The resolved version.")
        private final String version;
        @Column(displayName="Repository URI", description="The artifact repository that this dependency attempted to resolve from.")
        private final String repositoryUri;
        @Column(displayName="HTTP status", description="The HTTP status code of the response.")
        private final Integer httpStatus;
        @Column(displayName="Latency (ms)", description="The time in milliseconds that it took to resolve this dependency.")
        private final Long latencyMillis;

        @Generated
        public Row(String groupId, String artifactId, String version, String repositoryUri, Integer httpStatus, Long latencyMillis) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.repositoryUri = repositoryUri;
            this.httpStatus = httpStatus;
            this.latencyMillis = latencyMillis;
        }

        @Generated
        public String getGroupId() {
            return this.groupId;
        }

        @Generated
        public String getArtifactId() {
            return this.artifactId;
        }

        @Generated
        public String getVersion() {
            return this.version;
        }

        @Generated
        public String getRepositoryUri() {
            return this.repositoryUri;
        }

        @Generated
        public Integer getHttpStatus() {
            return this.httpStatus;
        }

        @Generated
        public Long getLatencyMillis() {
            return this.latencyMillis;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            Integer this$httpStatus = this.getHttpStatus();
            Integer other$httpStatus = other.getHttpStatus();
            if (this$httpStatus == null ? other$httpStatus != null : !((Object)this$httpStatus).equals(other$httpStatus)) {
                return false;
            }
            Long this$latencyMillis = this.getLatencyMillis();
            Long other$latencyMillis = other.getLatencyMillis();
            if (this$latencyMillis == null ? other$latencyMillis != null : !((Object)this$latencyMillis).equals(other$latencyMillis)) {
                return false;
            }
            String this$groupId = this.getGroupId();
            String other$groupId = other.getGroupId();
            if (this$groupId == null ? other$groupId != null : !this$groupId.equals(other$groupId)) {
                return false;
            }
            String this$artifactId = this.getArtifactId();
            String other$artifactId = other.getArtifactId();
            if (this$artifactId == null ? other$artifactId != null : !this$artifactId.equals(other$artifactId)) {
                return false;
            }
            String this$version = this.getVersion();
            String other$version = other.getVersion();
            if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
                return false;
            }
            String this$repositoryUri = this.getRepositoryUri();
            String other$repositoryUri = other.getRepositoryUri();
            return !(this$repositoryUri == null ? other$repositoryUri != null : !this$repositoryUri.equals(other$repositoryUri));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $httpStatus = this.getHttpStatus();
            result = result * 59 + ($httpStatus == null ? 43 : ((Object)$httpStatus).hashCode());
            Long $latencyMillis = this.getLatencyMillis();
            result = result * 59 + ($latencyMillis == null ? 43 : ((Object)$latencyMillis).hashCode());
            String $groupId = this.getGroupId();
            result = result * 59 + ($groupId == null ? 43 : $groupId.hashCode());
            String $artifactId = this.getArtifactId();
            result = result * 59 + ($artifactId == null ? 43 : $artifactId.hashCode());
            String $version = this.getVersion();
            result = result * 59 + ($version == null ? 43 : $version.hashCode());
            String $repositoryUri = this.getRepositoryUri();
            result = result * 59 + ($repositoryUri == null ? 43 : $repositoryUri.hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "DependencyResolutions.Row(groupId=" + this.getGroupId() + ", artifactId=" + this.getArtifactId() + ", version=" + this.getVersion() + ", repositoryUri=" + this.getRepositoryUri() + ", httpStatus=" + this.getHttpStatus() + ", latencyMillis=" + this.getLatencyMillis() + ")";
        }
    }
}

