/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.opensaml.saml.saml2.metadata.impl;

import javax.annotation.Nonnull;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.common.AbstractSAMLObjectUnmarshaller;
import org.opensaml.saml.saml2.metadata.Endpoint;
import org.w3c.dom.Attr;

/**
 * A thread-safe unmarshaller for {@link Endpoint} objects.
 */
public class EndpointUnmarshaller extends AbstractSAMLObjectUnmarshaller {

    /** {@inheritDoc} */
    @Override
    protected void processAttribute(@Nonnull final XMLObject xmlObject, @Nonnull final Attr attribute)
            throws UnmarshallingException {
        final Endpoint endpoint = (Endpoint) xmlObject;

        if (attribute.getNamespaceURI() == null) {
            if (attribute.getLocalName().equals(Endpoint.BINDING_ATTRIB_NAME)) {
                endpoint.setBinding(attribute.getValue());
            } else if (attribute.getLocalName().equals(Endpoint.LOCATION_ATTRIB_NAME)) {
                endpoint.setLocation(attribute.getValue());
            } else if (attribute.getLocalName().equals(Endpoint.RESPONSE_LOCATION_ATTRIB_NAME)) {
                endpoint.setResponseLocation(attribute.getValue());
            } else {
                super.processAttribute(xmlObject, attribute);
            }
        } else {
            processUnknownAttribute(endpoint, attribute);
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    protected void processChildElement(@Nonnull final XMLObject parentObject, @Nonnull final XMLObject childObject)
            throws UnmarshallingException {
        final Endpoint endpoint = (Endpoint) parentObject;

        endpoint.getUnknownXMLObjects().add(childObject);
    }

}