/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.x509.tls.impl;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.net.ssl.X509TrustManager;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.security.x509.tls.impl.ThreadLocalX509TrustEngineContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadLocalX509TrustManager
implements X509TrustManager {
    private Logger log = LoggerFactory.getLogger(ThreadLocalX509TrustManager.class);

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return new X509Certificate[0];
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.performTrustEval(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.performTrustEval(chain, authType);
    }

    protected void performTrustEval(X509Certificate[] chain, String authType) throws CertificateException {
        if (chain == null || chain.length == 0) {
            throw new IllegalArgumentException("Certificate chain was null or empty");
        }
        if (authType == null || authType.isEmpty()) {
            throw new IllegalArgumentException("AuthType was null or empty");
        }
        if (!ThreadLocalX509TrustEngineContext.haveCurrent()) {
            throw new CertificateException("Trust of X509Certificate could not be established, ThreadLocalX509TrustEngineContext is not populated");
        }
        if (this.performTrustEval(chain, ThreadLocalX509TrustEngineContext.getTrustEngine(), ThreadLocalX509TrustEngineContext.getCriteria())) {
            ThreadLocalX509TrustEngineContext.setTrusted(true);
        } else {
            ThreadLocalX509TrustEngineContext.setTrusted(false);
            if (ThreadLocalX509TrustEngineContext.isFailureFatal().booleanValue()) {
                this.log.debug("Credential evaluated as untrusted, failure indicated as fatal");
                throw new CertificateException("Trust engine could not establish trust of presented TLS credential");
            }
            this.log.debug("Credential evaluated as untrusted, failure indicated as non-fatal");
        }
    }

    protected boolean performTrustEval(@Nonnull X509Certificate[] chain, @Nonnull TrustEngine<? super X509Credential> trustEngine, @Nonnull CriteriaSet criteriaSet) throws CertificateException {
        this.log.debug("Attempting to evaluate server TLS credential against supplied TrustEngine and CriteriaSet");
        X509Credential credential = this.extractCredential(chain);
        this.log.trace("Saw trust engine of type: {}", (Object)trustEngine.getClass().getName());
        try {
            if (trustEngine.validate((Object)credential, criteriaSet)) {
                this.log.debug("Credential evaluated as trusted");
                return true;
            }
            this.log.debug("Credential evaluated as untrusted");
            return false;
        }
        catch (Throwable t) {
            this.log.error("Fatal trust engine error evaluating credential", t);
            return false;
        }
    }

    @Nonnull
    protected X509Credential extractCredential(@Nonnull @NotEmpty X509Certificate[] chain) throws CertificateException {
        List<X509Certificate> certChain = Arrays.asList(chain);
        X509Certificate entityCert = certChain.get(0);
        BasicX509Credential credential = new BasicX509Credential(entityCert);
        credential.setEntityCertificateChain(certChain);
        return credential;
    }
}

