/*
 * Decompiled with CFR 0.152.
 */
package org.opensciencegrid.authz.xacml.client;

import java.util.LinkedHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.opensaml.Configuration;
import org.opensaml.DefaultBootstrap;
import org.opensaml.xacml.ctx.ActionType;
import org.opensaml.xacml.ctx.DecisionType;
import org.opensaml.xacml.ctx.EnvironmentType;
import org.opensaml.xacml.ctx.ResourceType;
import org.opensaml.xacml.ctx.ResultType;
import org.opensaml.xacml.ctx.SubjectType;
import org.opensaml.xacml.profile.saml.XACMLAuthzDecisionStatementType;
import org.opensaml.xml.XMLObjectBuilderFactory;
import org.opensciencegrid.authz.xacml.client.XACMLClient;
import org.opensciencegrid.authz.xacml.stubs.Response;

public class XACMLClientTest {
    private static Log logger = LogFactory.getLog((String)XACMLClientTest.class.getName());
    static XMLObjectBuilderFactory builderFactory;

    public static void main(String[] stringArray) {
        XACMLClient xACMLClient = new XACMLClient();
        String string = null;
        String string2 = System.getenv("AUTHZ_SERVICE_URL");
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("http://authz-interop.org/xacml/subject/subject-x509-id", System.getenv("SUBJECT_X509"));
        linkedHashMap.put("http://authz-interop.org/xacml/subject/subject-condor-canonical-name-id", System.getenv("SUBJECT_CONDOR_CANONICAL_NAME"));
        linkedHashMap.put("http://authz-interop.org/xacml/subject/subject-x509-issuer", System.getenv("SUBJECT_X509_ISSUER"));
        linkedHashMap.put("http://authz-interop.org/xacml/subject/vo", System.getenv("SUBJECT_VO"));
        linkedHashMap.put("http://authz-interop.org/xacml/subject/voms-signing-subject", System.getenv("SUBJECT_VOMS_SIGNING_SUBJECT"));
        linkedHashMap.put("http://authz-interop.org/xacml/subject/voms-signing-issuer", System.getenv("SUBJECT_VOMS_SIGNING_ISSUER"));
        linkedHashMap.put("http://authz-interop.org/xacml/subject/voms-primary-fqan", System.getenv("SUBJECT_VOMS_PRIMARY_FQAN"));
        linkedHashMap.put("http://authz-interop.org/xacml/subject/certificate-serial-number", System.getenv("SUBJECT_CERTIFICATE_SERIAL_NUMBER"));
        linkedHashMap.put("http://authz-interop.org/xacml/subject/validity-not-before", System.getenv("SUBJECT_CERTIFICATE_NOT_BEFORE"));
        linkedHashMap.put("http://authz-interop.org/xacml/subject/validity-not-after", System.getenv("SUBJECT_CERTIFICATE_NOT_AFTER"));
        linkedHashMap.put("http://authz-interop.org/xacml/subject/ca-serial-number", System.getenv("SUBJECT_CA_SERIAL_NUMBER"));
        linkedHashMap.put("http://authz-interop.org/xacml/subject/voms-dns-port", System.getenv("SUBJECT_VOMS_DNS_PORT"));
        linkedHashMap.put("http://authz-interop.org/xacml/subject/ca-policy-oid", System.getenv("SUBJECT_CA_POLICY_OID"));
        linkedHashMap.put("http://authz-interop.org/xacml/subject/cert-chain", System.getenv("SUBJECT_CERT_CHAIN"));
        LinkedHashMap<String, String> linkedHashMap2 = new LinkedHashMap<String, String>();
        if ("CE".equals(System.getenv("RESOURCE"))) {
            linkedHashMap2.put("urn:oasis:names:tc:xacml:1.0:resource:resource-id", "http://authz-interop.org/xacml/resource/resource-type/ce");
        } else if ("WN".equals(System.getenv("RESOURCE"))) {
            linkedHashMap2.put("urn:oasis:names:tc:xacml:1.0:resource:resource-id", "http://authz-interop.org/xacml/resource/resource-type/wn");
        } else if ("SE".equals(System.getenv("RESOURCE"))) {
            linkedHashMap2.put("urn:oasis:names:tc:xacml:1.0:resource:resource-id", "http://authz-interop.org/xacml/resource/resource-type/se");
        }
        linkedHashMap2.put("http://authz-interop.org/xacml/resource/dns-host-name", System.getenv("RESOURCE_DNS_HOST_NAME"));
        linkedHashMap2.put("http://authz-interop.org/xacml/resource/resource-x509-id", System.getenv("RESOURCE_X509"));
        linkedHashMap2.put("http://authz-interop.org/xacml/resource/resource-x509-issuer", System.getenv("RESOURCE_X509_ISSUER"));
        LinkedHashMap<String, String> linkedHashMap3 = new LinkedHashMap<String, String>();
        linkedHashMap3.put("urn:oasis:names:tc:xacml:1.0:action:action-id", "http://authz-interop.org/xacml/action/action-type/access");
        linkedHashMap3.put("http://authz-interop.org/xacml/action/rsl-string", System.getenv("ACTION_RSL_STRING"));
        for (int i = 0; i < 1; ++i) {
            Object object;
            XACMLAuthzDecisionStatementType xACMLAuthzDecisionStatementType;
            String string3;
            String string4;
            SubjectType subjectType = XACMLClient.getSubjectType(linkedHashMap, string);
            String string5 = System.getenv("SUBJECT_VOMS_PRIMARY_FQAN");
            if (string5 != null) {
                XACMLClient.addSubjectFQAN(string5, subjectType, string);
            }
            if ((string4 = System.getenv("SUBJECT_VOMS_SECONDARY_FQAN")) != null) {
                XACMLClient.addSubjectFQAN(string4, subjectType, string);
            }
            if ((string3 = System.getenv("SUBJECT_VOMS_TERTIARY_FQAN")) != null) {
                XACMLClient.addSubjectFQAN(string3, subjectType, string);
            }
            ResourceType resourceType = XACMLClient.getResourceType(linkedHashMap2, string);
            ActionType actionType = XACMLClient.getActionType(linkedHashMap3, string);
            EnvironmentType environmentType = XACMLClient.getEnvironmentType();
            logger.info((Object)("Trying " + string2));
            try {
                Response response = xACMLClient.authorize(subjectType, resourceType, actionType, environmentType, string2);
                xACMLAuthzDecisionStatementType = xACMLClient.convertToXACML(response);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
            ResultType resultType = xACMLAuthzDecisionStatementType.getResponse().getResult();
            logger.info((Object)"Obtained result.");
            if (resultType.getDecision().getDecision() == DecisionType.DECISION.Indeterminate && (object = resultType.getStatus()) != null && object.getStatusCode().getValue().equals("urn:oasis:names:tc:xacml:1.0:status:processing-error")) {
                String string6 = object.getStatusMessage().getValue();
                logger.info((Object)string6);
            }
            if (resultType.getStatus().getStatusMessage() != null) {
                logger.info((Object)("Result Status: " + resultType.getStatus().getStatusMessage().getValue()));
            }
            if (resultType.getDecision().getDecision() == DecisionType.DECISION.Permit) {
                object = "Service authorized this user";
                logger.info((Object)("Decision: " + (String)object));
                continue;
            }
            object = "Service did not authorize this user";
            logger.info((Object)("Decision: " + (String)object));
        }
    }

    static {
        try {
            Init.init();
            DefaultBootstrap.bootstrap();
        }
        catch (Exception exception) {
            String string = "XACML init failed.";
            logger.error((Object)string, (Throwable)exception);
            throw new RuntimeException(string, exception);
        }
        builderFactory = Configuration.getBuilderFactory();
    }
}

