/*
 * Decompiled with CFR 0.152.
 */
package org.opensciencegrid.authz.xacml.client;

import eu.emi.security.authn.x509.impl.PEMCredential;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.LinkedHashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.italiangrid.voms.VOMSAttribute;
import org.opensciencegrid.authz.xacml.client.MapCredentialsClient;
import org.opensciencegrid.authz.xacml.common.LocalId;
import org.opensciencegrid.authz.xacml.common.X509CertUtil;

public class XACMLX509Test {
    private static Log logger = LogFactory.getLog((String)XACMLX509Test.class.getName());

    public static void main(String[] stringArray) {
        PEMCredential pEMCredential = null;
        try {
            pEMCredential = new PEMCredential(XACMLX509Test.getProxyFile(), (char[])null);
            System.setProperty("X509_PROXY_FILE", XACMLX509Test.getProxyFile());
        }
        catch (Exception exception) {
            logger.error((Object)("Caught exception in context creation. " + exception.getMessage()));
        }
        X509Certificate[] x509CertificateArray = null;
        try {
            x509CertificateArray = pEMCredential.getCertificateChain();
        }
        catch (Exception exception) {
            logger.error((Object)("Could not extract certificate chain from context " + exception.getMessage() + "\n" + exception.getCause()));
        }
        String string = null;
        try {
            string = X509CertUtil.getSubjectFromX509Chain(x509CertificateArray, false);
        }
        catch (Exception exception) {
            logger.error((Object)("Could not get subjectname from proxy. " + exception.getMessage()));
        }
        logger.info((Object)("The subject name is " + string));
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        linkedHashSet.add(null);
        try {
            linkedHashSet.addAll(X509CertUtil.getFQANsFromX509Chain(x509CertificateArray, false));
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (String string2 : linkedHashSet) {
            String string3 = null;
            try {
                LocalId localId = XACMLX509Test.authorize(string, string2, x509CertificateArray);
                string3 = localId.getUserName();
            }
            catch (Exception exception) {
                logger.error((Object)("Caught exception in authorization." + exception.getMessage()));
            }
            if (string2 == null) {
                string2 = "null";
            }
            if (string3 != null) {
                logger.info((Object)("xacml-vo-mapping service returned Username: " + string3 + " for " + string2));
                continue;
            }
            logger.info((Object)"xacml-vo-mapping service did not return a username");
        }
    }

    public static LocalId authorize(String string, String string2, X509Certificate[] x509CertificateArray) throws Exception {
        LocalId localId;
        MapCredentialsClient mapCredentialsClient;
        String string3;
        String string4;
        String string5;
        Object object;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        String string12 = null;
        String string13 = null;
        String string14 = null;
        String string15 = null;
        String string16 = null;
        String string17 = "http://authz-interop.org/xacml/action/action-type/access";
        String string18 = null;
        String string19 = string;
        try {
            string7 = X509CertUtil.getSubjectX509Issuer(x509CertificateArray);
        }
        catch (Exception exception) {
            logger.warn((Object)("Could not determine subject-x509-issuer : " + exception.getMessage()));
        }
        VOMSAttribute vOMSAttribute = null;
        if (x509CertificateArray != null && string2 != null) {
            vOMSAttribute = X509CertUtil.getVOMSAttribute(x509CertificateArray, string2);
        }
        if (vOMSAttribute != null) {
            string8 = vOMSAttribute.getVO();
            object = vOMSAttribute.getIssuer().toString();
            string9 = X509CertUtil.toGlobusDN((String)object);
        }
        object = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        String string20 = ((DateFormat)object).format(X509CertUtil.getLatestNotBefore(x509CertificateArray));
        String string21 = ((DateFormat)object).format(X509CertUtil.getEarliestNotAfter(x509CertificateArray));
        try {
            string5 = XACMLX509Test.getResourceX509ID();
        }
        catch (Exception exception) {
            logger.error((Object)("Exception in finding targetServiceName : " + exception));
            throw new Exception(exception.toString());
        }
        try {
            string16 = XACMLX509Test.getResourceType();
        }
        catch (Exception exception) {
            logger.error((Object)("Exception in finding resource type : " + exception));
            throw new Exception(exception.toString());
        }
        try {
            string4 = XACMLX509Test.getResourceHostName();
        }
        catch (Exception exception) {
            logger.error((Object)("Exception in finding targetServiceName : " + exception));
            throw new Exception(exception.toString());
        }
        try {
            string3 = XACMLX509Test.getTargetServiceIssuer();
        }
        catch (Exception exception) {
            logger.error((Object)("Exception in finding targetServiceIssuer : " + exception));
            throw new Exception(exception.toString());
        }
        logger.info((Object)("Requesting mapping for User with DN: " + string + " and Role " + string2));
        logger.debug((Object)("Mapping Service URL configuration: " + XACMLX509Test.getMappingServiceURL()));
        try {
            mapCredentialsClient = new MapCredentialsClient();
            mapCredentialsClient.setX509Subject(string);
            mapCredentialsClient.setCondorCanonicalNameID(string6);
            mapCredentialsClient.setX509SubjectIssuer(string7);
            mapCredentialsClient.setVO(string8);
            mapCredentialsClient.setVOMSSigningSubject(string9);
            mapCredentialsClient.setVOMSSigningIssuer(string10);
            mapCredentialsClient.setFqan(string2);
            mapCredentialsClient.setCertificateSerialNumber(string11);
            mapCredentialsClient.setCertificateChainNotBefore(string20);
            mapCredentialsClient.setCertificateChainNotAfter(string21);
            mapCredentialsClient.setCASerialNumber(string12);
            mapCredentialsClient.setVOMS_DNS_Port(string13);
            mapCredentialsClient.setCertificatePoliciesOIDs(string14);
            mapCredentialsClient.setCertificateChain(string15);
            mapCredentialsClient.setResourceType(string16);
            mapCredentialsClient.setResourceDNSHostName(string4);
            mapCredentialsClient.setResourceX509ID(string5);
            mapCredentialsClient.setResourceX509Issuer(string3);
            mapCredentialsClient.setRequestedaction(string17);
            mapCredentialsClient.setRSL_string(string18);
        }
        catch (Exception exception) {
            logger.error((Object)("Exception in XACML mapping client instantiation: " + exception));
            throw new Exception(exception.toString());
        }
        try {
            localId = mapCredentialsClient.mapCredentials(XACMLX509Test.getMappingServiceURL());
        }
        catch (Exception exception) {
            logger.error((Object)(" Exception occurred in mapCredentials: " + exception));
            throw new Exception(exception.toString());
        }
        if (localId == null) {
            String string22 = "Authorization denied: No XACML mapping retrieved service for DN " + string + " and role " + string2;
            logger.warn((Object)string22);
            throw new Exception(string22);
        }
        return localId;
    }

    public static String getProxyFile() throws Exception {
        String string = System.getenv("X509_PROXY_FILE");
        if (string == null) {
            throw new Exception();
        }
        return string;
    }

    public static String getMappingServiceURL() throws Exception {
        String string = System.getenv("AUTHZ_SERVICE_URL");
        if (string == null) {
            throw new Exception();
        }
        return string;
    }

    public static String getResourceX509ID() throws Exception {
        String string = System.getenv("RESOURCE_X509");
        if (string == null) {
            throw new Exception();
        }
        return string;
    }

    public static String getResourceType() throws Exception {
        String string = System.getenv("RESOURCE");
        if ("CE".equals(string)) {
            return System.getenv("http://authz-interop.org/xacml/resource/resource-type/ce");
        }
        if ("WN".equals(string)) {
            return System.getenv("http://authz-interop.org/xacml/resource/resource-type/wn");
        }
        if ("SE".equals(string)) {
            return System.getenv("http://authz-interop.org/xacml/resource/resource-type/se");
        }
        throw new Exception();
    }

    public static String getResourceHostName() throws Exception {
        String string = System.getenv("RESOURCE_DNS_HOST_NAME");
        if (string == null) {
            throw new Exception();
        }
        return string;
    }

    public static String getTargetServiceIssuer() throws Exception {
        String string = System.getenv("RESOURCE_X509_ISSUER");
        if (string == null) {
            throw new Exception();
        }
        return string;
    }
}

