/*
 * Decompiled with CFR 0.152.
 */
package org.opensciencegrid.authz.xacml.common;

import eu.emi.security.authn.x509.X509CertChainValidatorExt;
import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.impl.OpensslNameUtils;
import eu.emi.security.authn.x509.impl.PEMCredential;
import eu.emi.security.authn.x509.proxy.ProxyUtils;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import org.italiangrid.voms.VOMSAttribute;
import org.italiangrid.voms.VOMSValidators;
import org.italiangrid.voms.ac.VOMSACValidator;
import org.italiangrid.voms.store.VOMSTrustStore;
import org.italiangrid.voms.store.VOMSTrustStores;
import org.italiangrid.voms.util.CertificateValidatorBuilder;

public class X509CertUtil {
    public static String default_service_cert = "/etc/grid-security/hostcert.pem";
    public static String default_service_key = "/etc/grid-security/hostkey.pem";
    private static X509CertChainValidatorExt certChainValidator;
    private static VOMSACValidator vomsValidator;
    private static PEMCredential hostCredential;
    private static int REFRESH_TIME_MS;
    public static final String capnull = "/Capability=NULL";
    public static final int capnulllen;
    public static final String rolenull = "/Role=NULL";
    public static final int rolenulllen;

    public static String toGlobusDN(String string) {
        return OpensslNameUtils.convertFromRfc2253((String)string, (boolean)true);
    }

    public static String getSubjectFromX509Chain(X509Certificate[] x509CertificateArray, boolean bl) throws Exception {
        return X509CertUtil.toGlobusDN(ProxyUtils.getOriginalUserDN((X509Certificate[])x509CertificateArray).getName());
    }

    public static X509Certificate getUserCertFromX509Chain(X509Certificate[] x509CertificateArray) throws Exception {
        return ProxyUtils.getEndUserCertificate((X509Certificate[])x509CertificateArray);
    }

    public static Date getLatestNotBefore(X509Certificate[] x509CertificateArray) throws Exception {
        Date date = null;
        for (X509Certificate x509Certificate : x509CertificateArray) {
            Date date2 = x509Certificate.getNotBefore();
            if (date == null || date2.after(date)) {
                date = date2;
            }
            if (!ProxyUtils.isProxy((X509Certificate)x509Certificate)) break;
        }
        if (date == null) {
            throw new Exception("could not find any not-before time in the certificate chain.");
        }
        return date;
    }

    public static Date getEarliestNotAfter(X509Certificate[] x509CertificateArray) throws Exception {
        Date date = null;
        for (X509Certificate x509Certificate : x509CertificateArray) {
            Date date2 = x509Certificate.getNotAfter();
            if (date == null || date2.before(date)) {
                date = date2;
            }
            if (!ProxyUtils.isProxy((X509Certificate)x509Certificate)) break;
        }
        if (date == null) {
            throw new Exception("could not find any not-after time in the certificate chain.");
        }
        return date;
    }

    public static String getSubjectX509Issuer(X509Certificate[] x509CertificateArray) throws Exception {
        X509Certificate x509Certificate = X509CertUtil.getUserCertFromX509Chain(x509CertificateArray);
        return X509CertUtil.getSubjectX509Issuer(x509Certificate);
    }

    public static String getSubjectX509Issuer(X509Certificate x509Certificate) throws Exception {
        return X509CertUtil.toGlobusDN(x509Certificate.getIssuerDN().toString());
    }

    public static Collection<String> getFQANsFromX509Chain(X509Certificate[] x509CertificateArray, boolean bl) throws Exception {
        LinkedHashSet<String> linkedHashSet = null;
        try {
            List<VOMSAttribute> list = X509CertUtil.getVOMSAttributes(x509CertificateArray, bl);
            linkedHashSet = X509CertUtil.getFQANSfromVOMSAttributes(list);
        }
        catch (Exception exception) {
            throw new Exception(exception.toString());
        }
        return linkedHashSet;
    }

    public static LinkedHashSet<String> getFQANSfromVOMSAttributes(List<VOMSAttribute> list) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (VOMSAttribute vOMSAttribute : list) {
            for (String string : vOMSAttribute.getFQANs()) {
                if (string.endsWith(capnull)) {
                    string = string.substring(0, string.length() - capnulllen);
                }
                if (string.endsWith(rolenull)) {
                    string = string.substring(0, string.length() - rolenulllen);
                }
                boolean bl = false;
                for (String string2 : linkedHashSet) {
                    if (!string2.startsWith(string)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                linkedHashSet.add(string);
            }
        }
        return linkedHashSet;
    }

    public static VOMSAttribute getVOMSAttribute(X509Certificate[] x509CertificateArray, String string) throws Exception {
        if (string.endsWith(capnull)) {
            string = string.substring(0, string.length() - capnulllen);
        }
        if (string.endsWith(rolenull)) {
            string = string.substring(0, string.length() - rolenulllen);
        }
        List<VOMSAttribute> list = X509CertUtil.getVOMSAttributes(x509CertificateArray, false);
        for (VOMSAttribute vOMSAttribute : list) {
            List list2 = vOMSAttribute.getFQANs();
            for (String string2 : list2) {
                if (string2.endsWith(capnull)) {
                    string2 = string2.substring(0, string2.length() - capnulllen);
                }
                if (string2.endsWith(rolenull)) {
                    string2 = string2.substring(0, string2.length() - rolenulllen);
                }
                if (!string2.equals(string)) continue;
                return vOMSAttribute;
            }
        }
        return null;
    }

    public static List<VOMSAttribute> getVOMSAttributes(X509Certificate[] x509CertificateArray, boolean bl) throws Exception {
        try {
            VOMSACValidator vOMSACValidator = X509CertUtil.getVOMSValidatorInstance();
            if (bl) {
                return vOMSACValidator.validate(x509CertificateArray);
            }
            return vOMSACValidator.parse(x509CertificateArray);
        }
        catch (IOException iOException) {
            throw new Exception("Could not read trust stores " + iOException.getMessage() + "\n" + iOException.getCause());
        }
        catch (CertificateException certificateException) {
            throw new Exception("Could not read certificate " + certificateException.getMessage() + "\n" + certificateException.getCause());
        }
        catch (CRLException cRLException) {
            throw new Exception("Could not read CRL " + cRLException.getMessage() + "\n" + cRLException.getCause());
        }
    }

    public static synchronized VOMSACValidator getVOMSValidatorInstance() throws IOException, CertificateException, CRLException {
        if (vomsValidator == null) {
            String string = System.getProperty("VOMSDIR");
            VOMSTrustStore vOMSTrustStore = string == null ? VOMSTrustStores.newTrustStore() : VOMSTrustStores.newTrustStore(Arrays.asList(string));
            X509CertChainValidatorExt x509CertChainValidatorExt = X509CertUtil.getCertChainValidator();
            vomsValidator = VOMSValidators.newValidator((VOMSTrustStore)vOMSTrustStore, (X509CertChainValidatorExt)x509CertChainValidatorExt);
        }
        return vomsValidator;
    }

    public static synchronized X509CertChainValidatorExt getCertChainValidator() {
        if (certChainValidator == null) {
            String string = System.getProperty("CADIR");
            CertificateValidatorBuilder certificateValidatorBuilder = new CertificateValidatorBuilder();
            if (string != null) {
                certificateValidatorBuilder.trustAnchorsDir(string);
            }
            certChainValidator = certificateValidatorBuilder.build();
        }
        return certChainValidator;
    }

    public static synchronized X509Credential getHostCredential() throws CertificateException, KeyStoreException, IOException {
        if (hostCredential == null) {
            String string = System.getProperty("HOSTKEY", default_service_key);
            String string2 = System.getProperty("HOSTCERT", default_service_cert);
            hostCredential = new PEMCredential(string, string2, null);
        }
        return hostCredential;
    }

    static {
        REFRESH_TIME_MS = 20000;
        capnulllen = capnull.length();
        rolenulllen = rolenull.length();
    }
}

