/*
 * Decompiled with CFR 0.152.
 */
package org.opensciencegrid.authz.xacml.service;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.axis.AxisFault;
import org.apache.axis.message.MessageElement;
import org.apache.axis.types.Id;
import org.apache.axis.types.NCName;
import org.apache.axis.types.URI;
import org.apache.axis.utils.XMLUtils;
import org.apache.log4j.Logger;
import org.apache.xml.security.Init;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.xacml.ctx.RequestType;
import org.opensaml.xacml.ctx.StatusMessageType;
import org.opensaml.xacml.ctx.impl.StatusMessageTypeImplBuilder;
import org.opensaml.xacml.profile.saml.XACMLAuthzDecisionQueryType;
import org.opensaml.xacml.profile.saml.XACMLAuthzDecisionStatementType;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.XMLObjectBuilder;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallerFactory;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallerFactory;
import org.opensaml.xml.io.UnmarshallingException;
import org.opensciencegrid.authz.xacml.common.OSGSAMLBootstrap;
import org.opensciencegrid.authz.xacml.service.XACMLMappingService;
import org.opensciencegrid.authz.xacml.stubs.Response;
import org.opensciencegrid.authz.xacml.stubs.XACMLAuthorizationPortTypeSOAPBindingImpl;
import org.opensciencegrid.authz.xacml.stubs.XACMLAuthzDecisionQuery;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BasicMappingXACMLAuthZService
extends XACMLAuthorizationPortTypeSOAPBindingImpl {
    XACMLMappingService mapService;
    protected String serviceIdentity = "BasicMappingXACMLAuthZService";
    static Logger logger = Logger.getLogger((String)BasicMappingXACMLAuthZService.class.getName());
    private static UnmarshallerFactory unMarshallerFactory = null;
    private static MarshallerFactory marshallerFactory = null;

    public BasicMappingXACMLAuthZService(XACMLMappingService xACMLMappingService) {
        this.mapService = xACMLMappingService;
        unMarshallerFactory = Configuration.getUnmarshallerFactory();
        marshallerFactory = Configuration.getMarshallerFactory();
    }

    @Override
    public Response authorize(XACMLAuthzDecisionQuery xACMLAuthzDecisionQuery) throws RemoteException {
        Element element;
        XACMLAuthzDecisionQueryType xACMLAuthzDecisionQueryType;
        Element element2;
        try {
            element2 = ((MessageElement)xACMLAuthzDecisionQuery.get_any()[0].getParentElement()).getAsDOM();
        }
        catch (Exception exception) {
            logger.error((Object)exception);
            throw new RemoteException("Error converting to query element", exception);
        }
        UnmarshallerFactory unmarshallerFactory = Configuration.getUnmarshallerFactory();
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(XACMLAuthzDecisionQueryType.DEFAULT_ELEMENT_NAME_XACML20);
        try {
            xACMLAuthzDecisionQueryType = (XACMLAuthzDecisionQueryType)unmarshaller.unmarshall(element2);
            logger.debug((Object)("XACMLAuthzDecisionQueryType object received: " + XMLUtils.ElementToString((Element)xACMLAuthzDecisionQueryType.getDOM())));
        }
        catch (UnmarshallingException unmarshallingException) {
            logger.error((Object)unmarshallingException);
            throw new RemoteException("Unmarshall failed", unmarshallingException);
        }
        XACMLAuthzDecisionStatementType xACMLAuthzDecisionStatementType = null;
        try {
            xACMLAuthzDecisionStatementType = this.mapService.mapCredentials(xACMLAuthzDecisionQueryType);
        }
        catch (Exception exception) {
            Element element3;
            logger.error((Object)"Mapping service failed to map credentials", (Throwable)exception);
            StatusMessageTypeImplBuilder statusMessageTypeImplBuilder = (StatusMessageTypeImplBuilder)Configuration.getBuilderFactory().getBuilder(StatusMessageType.DEFAULT_ELEMENT_NAME);
            StatusMessageType statusMessageType = statusMessageTypeImplBuilder.buildObject();
            statusMessageType.setValue(exception.getMessage());
            MarshallerFactory marshallerFactory = Configuration.getMarshallerFactory();
            Marshaller marshaller = marshallerFactory.getMarshaller(StatusMessageType.DEFAULT_ELEMENT_NAME);
            try {
                element3 = marshaller.marshall((XMLObject)statusMessageType);
            }
            catch (MarshallingException marshallingException) {
                logger.error((Object)"marshalling exception", (Throwable)marshallingException);
                throw new RemoteException(exception.getMessage());
            }
            AxisFault axisFault = new AxisFault(StatusMessageType.DEFAULT_ELEMENT_NAME, exception.getLocalizedMessage(), "GUMS", new Element[]{element3});
            throw axisFault;
        }
        RequestType requestType = xACMLAuthzDecisionQueryType.getRequest();
        if (xACMLAuthzDecisionQueryType.getReturnContextXSBooleanValue() != null && xACMLAuthzDecisionQueryType.getReturnContextXSBooleanValue().getValue().booleanValue()) {
            requestType.releaseDOM();
            requestType.detach();
            xACMLAuthzDecisionStatementType.setRequest(requestType);
        }
        XMLObjectBuilder xMLObjectBuilder = Configuration.getBuilderFactory().getBuilder(Assertion.DEFAULT_ELEMENT_NAME);
        Assertion assertion = (Assertion)xMLObjectBuilder.buildObject(Assertion.DEFAULT_ELEMENT_NAME);
        assertion.getStatements().add(xACMLAuthzDecisionStatementType);
        XMLObjectBuilder xMLObjectBuilder2 = Configuration.getBuilderFactory().getBuilder(org.opensaml.saml2.core.Response.DEFAULT_ELEMENT_NAME);
        org.opensaml.saml2.core.Response response = (org.opensaml.saml2.core.Response)xMLObjectBuilder2.buildObject(org.opensaml.saml2.core.Response.DEFAULT_ELEMENT_NAME);
        response.getAssertions().add(assertion);
        response.setInResponseTo(xACMLAuthzDecisionQueryType.getID());
        MarshallerFactory marshallerFactory = Configuration.getMarshallerFactory();
        Marshaller marshaller = marshallerFactory.getMarshaller(org.opensaml.saml2.core.Response.DEFAULT_ELEMENT_NAME);
        try {
            element = marshaller.marshall((XMLObject)response);
            logger.debug((Object)("Response object returned: " + XMLUtils.ElementToString((Element)element)));
        }
        catch (MarshallingException marshallingException) {
            logger.error((Object)"marshalling exception", (Throwable)marshallingException);
            throw new RemoteException("Marshalling exception", marshallingException);
        }
        NodeList nodeList = element.getChildNodes();
        ArrayList<MessageElement> arrayList = new ArrayList<MessageElement>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            arrayList.add(new MessageElement((Element)node));
        }
        Response response2 = new Response();
        response2.set_any(arrayList.toArray(new MessageElement[arrayList.size()]));
        try {
            if (response.getConsent() != null && !response.getConsent().equals("")) {
                response2.setConsent(new URI(response.getConsent()));
            }
            if (response.getDestination() != null && !response.getDestination().equals("")) {
                response2.setDestination(new URI(response.getDestination()));
            }
        }
        catch (URI.MalformedURIException malformedURIException) {
            logger.error((Object)malformedURIException);
            throw new RemoteException("Error converting to URI", malformedURIException);
        }
        if (response.getID() != null && !response.getID().equals("")) {
            response2.setID(new Id(response.getID()));
        }
        if (response.getInResponseTo() != null && !response.getInResponseTo().equals("")) {
            response2.setInResponseTo(new NCName(response.getInResponseTo()));
        }
        if (response.getIssueInstant() != null) {
            response2.setIssueInstant(response.getIssueInstant().toCalendar(Locale.getDefault()));
        }
        if (response.getVersion() != null) {
            response2.setVersion(response.getVersion().toString());
        }
        return response2;
    }

    static {
        try {
            Init.init();
            OSGSAMLBootstrap.bootstrap();
        }
        catch (Exception exception) {
            String string = "xacmlInitFailed";
            logger.error((Object)string, (Throwable)exception);
            throw new RuntimeException(string, exception);
        }
    }
}

