/*
 * Decompiled with CFR 0.152.
 */
package org.opensciencegrid.authz.client;

import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Stub;
import org.apache.axis.message.MessageElement;
import org.apache.log4j.Category;
import org.globus.gsi.gssapi.GlobusGSSCredentialImpl;
import org.globus.wsrf.impl.security.authorization.NoAuthorization;
import org.opensaml.QName;
import org.opensaml.SAMLAction;
import org.opensaml.SAMLAssertion;
import org.opensaml.SAMLAttribute;
import org.opensaml.SAMLAttributeStatement;
import org.opensaml.SAMLAuthorizationDecisionQuery;
import org.opensaml.SAMLAuthorizationDecisionStatement;
import org.opensaml.SAMLException;
import org.opensaml.SAMLNameIdentifier;
import org.opensaml.SAMLQuery;
import org.opensaml.SAMLRequest;
import org.opensaml.SAMLResponse;
import org.opensaml.SAMLSubject;
import org.opensciencegrid.authz.common.LocalId;
import org.opensciencegrid.authz.common.OSGAuthorizationConstants;
import org.opensciencegrid.authz.saml.ObligatedAuthorizationDecisionStatement;
import org.opensciencegrid.authz.saml.SAMLExtensionInit;
import org.opensciencegrid.authz.saml.SAMLUtil;
import org.opensciencegrid.authz.saml.XACMLObligation;
import org.opensciencegrid.authz.stubs.AuthorizationServiceLocator;
import org.opensciencegrid.authz.stubs.SAMLRequestPortType;
import org.opensciencegrid.authz.stubs.SAMLRequestType;
import org.opensciencegrid.authz.stubs.SAMLResponseType;
import org.w3c.dom.Element;

public class SAMLAuthZClientBase {
    static Category log = Category.getInstance((String)SAMLAuthZClientBase.class.getName());
    private GlobusGSSCredentialImpl globusCredentials;

    public SAMLSubject getSAMLSubjectFromString(String string) throws SAMLException {
        if (string == null || string.length() == 0) {
            log.error((Object)"The subjectName parameter must not be null or empty");
            return null;
        }
        log.debug((Object)("Creating SAMLSubject from string: " + string));
        String string2 = "";
        String string3 = "urn:osasis:names:tc:SAML:1.1nameid-format:X509SubjectName";
        ArrayList<String> arrayList = null;
        SAMLNameIdentifier sAMLNameIdentifier = new SAMLNameIdentifier(string, string2, string3);
        arrayList = new ArrayList<String>(1);
        arrayList.add("urn:oasis:names:tc:SAML:1.0:am:X509-PKI");
        log.debug((Object)("Subject name " + string + " nameQualifier " + string2 + " format " + string3));
        return new SAMLSubject(sAMLNameIdentifier, arrayList, null, null);
    }

    public SAMLSubject getSAMLSubjectFromGSS(String string) throws SAMLException {
        String string2 = "/CN=Dummy Subject";
        log.debug((Object)("Creating SAMLSubject from peer certificate subject (not implemented): " + string2));
        String string3 = "";
        String string4 = "urn:osasis:names:tc:SAML:1.1nameid-format:X509SubjectName";
        ArrayList<String> arrayList = null;
        SAMLNameIdentifier sAMLNameIdentifier = new SAMLNameIdentifier(string2, string3, string4);
        arrayList = new ArrayList<String>(1);
        arrayList.add("urn:oasis:names:tc:SAML:1.0:am:X509-PKI");
        log.debug((Object)("Subject name " + string2 + " nameQualifier " + string3 + " format " + string4));
        return new SAMLSubject(sAMLNameIdentifier, arrayList, null, null);
    }

    public ArrayList createMappingActions() throws SAMLException {
        ArrayList<SAMLAction> arrayList = new ArrayList<SAMLAction>();
        SAMLAction sAMLAction = new SAMLAction("opensciencegrid:authorization", "access_as_local_identity");
        arrayList.add(sAMLAction);
        return arrayList;
    }

    public ArrayList createFQANEvidenceFromString(SAMLSubject sAMLSubject, String string, String string2) throws SAMLException, CloneNotSupportedException {
        ArrayList<SAMLAssertion> arrayList = null;
        if (string2 != null && string2.length() != 0 && string != null && string.length() != 0) {
            arrayList = new ArrayList<SAMLAssertion>(1);
            log.debug((Object)("Creating Evidence based on FQAN String: " + string2 + " from: " + string));
            ArrayList<String> arrayList2 = new ArrayList<String>(1);
            arrayList2.add(string2);
            SAMLAttribute sAMLAttribute = new SAMLAttribute("FQAN", "opensciencegrid:authorization", null, 0L, arrayList2);
            ArrayList<SAMLAttribute> arrayList3 = new ArrayList<SAMLAttribute>(1);
            arrayList3.add(sAMLAttribute);
            SAMLAttributeStatement sAMLAttributeStatement = new SAMLAttributeStatement((SAMLSubject)sAMLSubject.clone(), arrayList3);
            ArrayList<SAMLAttributeStatement> arrayList4 = new ArrayList<SAMLAttributeStatement>(1);
            arrayList4.add(sAMLAttributeStatement);
            SAMLAssertion sAMLAssertion = new SAMLAssertion(string, new Date(), new Date(), null, null, arrayList4);
            arrayList.add(sAMLAssertion);
        } else {
            log.warn((Object)"fqan and fqanIssuer information must be provided for evidence element to be created");
        }
        return arrayList;
    }

    public ArrayList createFQANEvidenceFromGSS(String string) {
        return null;
    }

    public SAMLAuthorizationDecisionStatement queryAuthZService(SAMLSubject sAMLSubject, ArrayList arrayList, ArrayList arrayList2, String string, URL uRL) throws SAMLException, ServiceException, RemoteException, Exception {
        Stub stub;
        SAMLExtensionInit.init();
        SAMLAuthorizationDecisionQuery sAMLAuthorizationDecisionQuery = null;
        sAMLAuthorizationDecisionQuery = new SAMLAuthorizationDecisionQuery(sAMLSubject, string, (Collection)arrayList2, (Collection)arrayList);
        ArrayList<QName> arrayList3 = new ArrayList<QName>();
        arrayList3.add(OSGAuthorizationConstants.AUTHZDECISIONSTATEMENT);
        arrayList3.add(OSGAuthorizationConstants.OBLIGATEDAUTHZDECISIONSTATEMENT);
        SAMLRequest sAMLRequest = null;
        sAMLRequest = new SAMLRequest(arrayList3, (SAMLQuery)sAMLAuthorizationDecisionQuery, null, null);
        SAMLRequestType sAMLRequestType = new SAMLRequestType();
        sAMLRequestType.set_any(new MessageElement[]{new MessageElement((Element)sAMLRequest.toDOM())});
        SAMLResponseType sAMLResponseType = null;
        AuthorizationServiceLocator authorizationServiceLocator = new AuthorizationServiceLocator();
        log.debug((Object)("Sending SAML query/request to " + uRL + " " + sAMLRequest));
        SAMLRequestPortType sAMLRequestPortType = authorizationServiceLocator.getAuthorizationServicePort(uRL);
        if (this.getGlobusCredentials() != null) {
            stub = (Stub)sAMLRequestPortType;
            log.debug((Object)"Setting Globus GSI credentials on the WS stub.");
            stub._setProperty("org.globus.gsi.credentials", (Object)this.getGlobusCredentials());
            stub._setProperty("org.globus.security.authorization", (Object)NoAuthorization.getInstance());
        }
        if ((sAMLResponseType = sAMLRequestPortType.SAMLRequest(sAMLRequestType)) == null) {
            log.error((Object)"Authorization query/request failed - received a null response");
            return null;
        }
        stub = null;
        MessageElement[] messageElementArray = sAMLResponseType.get_any();
        stub = new SAMLResponse(messageElementArray[0].getAsDOM());
        String string2 = stub.getInResponseTo();
        if (string2 == null || !string2.equals(sAMLRequest.getId())) {
            log.error((Object)"Authorization query/request failed - received a bad inResponseTo");
            return null;
        }
        log.debug((Object)("Received response corresponding to our request: " + stub));
        log.debug((Object)"Extracting authorization decision statements from response");
        Iterator iterator = stub.getAssertions();
        if (iterator != null && iterator.hasNext()) {
            SAMLAssertion sAMLAssertion = (SAMLAssertion)iterator.next();
            Iterator iterator2 = sAMLAssertion.getStatements();
            if (iterator2 != null && iterator2.hasNext()) {
                Object e = iterator2.next();
                if (e instanceof ObligatedAuthorizationDecisionStatement || e instanceof SAMLAuthorizationDecisionStatement) {
                    log.debug((Object)"Received and returning Authorization Decision Statement");
                    return (SAMLAuthorizationDecisionStatement)e;
                }
                log.error((Object)"Received statement was not an Authorization Decison Statement");
            } else {
                log.error((Object)"Received assertion did not contain a SAML statement");
            }
        } else {
            log.error((Object)"Received response did not contain a SAML Assertion");
        }
        return null;
    }

    public LocalId processAuthzStmt(SAMLAuthorizationDecisionStatement sAMLAuthorizationDecisionStatement, String string, ArrayList arrayList, SAMLSubject sAMLSubject) {
        Cloneable cloneable;
        Iterator iterator;
        log.debug((Object)"Processing Authorization Decision Statement");
        LocalId localId = null;
        if (sAMLAuthorizationDecisionStatement.getDecision().equals("Permit") && sAMLAuthorizationDecisionStatement.getResource().equals(string)) {
            log.debug((Object)"Authorization decision is Permit and Resource matches");
            if (SAMLUtil.samlSubjectMatch(sAMLSubject, sAMLAuthorizationDecisionStatement.getSubject())) {
                log.debug((Object)"Response subject name matches request subject name");
                iterator = sAMLAuthorizationDecisionStatement.getActions();
                cloneable = new ArrayList();
                while (iterator.hasNext()) {
                    SAMLAction sAMLAction = (SAMLAction)iterator.next();
                    ((ArrayList)cloneable).add(sAMLAction);
                    log.debug((Object)("Authorized action: " + sAMLAction.getNamespace() + "    " + sAMLAction.getData()));
                }
                boolean bl = false;
                for (int i = 0; i < arrayList.size(); ++i) {
                    bl = false;
                    for (int j = 0; j < ((ArrayList)cloneable).size(); ++j) {
                        if (!SAMLUtil.samlActionMatch((SAMLAction)arrayList.get(i), (SAMLAction)((ArrayList)cloneable).get(j))) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) break;
                }
                if (bl) {
                    log.debug((Object)"Authorized actions include requested actions");
                    localId = new LocalId();
                } else {
                    log.warn((Object)"Authorization decision did not permit requested actions");
                }
            } else {
                log.warn((Object)"Response subject does not match request subject");
                log.debug((Object)("Request  Subject Name " + sAMLSubject.getName()));
                log.debug((Object)("Response Subject Name " + sAMLAuthorizationDecisionStatement.getSubject().getName()));
                if (sAMLSubject.getName().equals(sAMLAuthorizationDecisionStatement.getSubject().getName())) {
                    log.debug((Object)"The name is equal");
                } else {
                    log.debug((Object)"The name is not equal");
                }
                log.debug((Object)("Request  Subject Name Qualifier " + sAMLSubject.getName().getNameQualifier()));
                log.debug((Object)("Response Subject Name Qualifier " + sAMLAuthorizationDecisionStatement.getSubject().getName().getNameQualifier()));
                if (sAMLSubject.getName().getNameQualifier().equals(sAMLAuthorizationDecisionStatement.getSubject().getName().getNameQualifier())) {
                    log.debug((Object)"The name qualifier is equal");
                } else {
                    log.debug((Object)"The name qualifier is not equal");
                }
                log.debug((Object)("Request  Subject Name Format " + sAMLSubject.getName().getFormat()));
                log.debug((Object)("Response Subject Name Format " + sAMLAuthorizationDecisionStatement.getSubject().getName().getFormat()));
                if (sAMLSubject.getName().getFormat().equals(sAMLAuthorizationDecisionStatement.getSubject().getName().getFormat())) {
                    log.debug((Object)"The format is equal");
                } else {
                    log.debug((Object)"The format is not equal");
                }
            }
        }
        if (localId == null) {
            return null;
        }
        if (sAMLAuthorizationDecisionStatement instanceof ObligatedAuthorizationDecisionStatement) {
            log.debug((Object)"Processing Obligations");
            iterator = ((ObligatedAuthorizationDecisionStatement)sAMLAuthorizationDecisionStatement).getXACMLObligations();
            while (iterator.hasNext()) {
                cloneable = (XACMLObligation)iterator.next();
                if (((XACMLObligation)cloneable).getObligationId().equals("opensciencegrid:authorization:UserIdObligation") && ((XACMLObligation)cloneable).getFullfillOn().equals("Permit")) {
                    log.debug((Object)"Found UserId obligation");
                    if (localId.getUserName() != null) {
                        log.warn((Object)"Warning multiple UserId Obligations, overriding previous");
                    }
                    if (((XACMLObligation)cloneable).getAttributeId().equals("opensciencegrid:authorization:attribute:UserId") && ((XACMLObligation)cloneable).getDatatype().equals("http://www.w3.org/2001/XMLSchema#string")) {
                        localId.setUserName(((XACMLObligation)cloneable).getValue());
                        continue;
                    }
                    log.error((Object)"Obligation has unexpected attributeId or datatype");
                    return null;
                }
                if (((XACMLObligation)cloneable).getObligationId().equals("opensciencegrid:authorization:GroupIdObligation") && ((XACMLObligation)cloneable).getFullfillOn().equals("Permit")) {
                    log.debug((Object)"Found GroupId obligation");
                    if (localId.getGroupName() != null) {
                        log.warn((Object)"Warning multiple GroupId Obligations, overriding previous");
                    }
                    if (((XACMLObligation)cloneable).getAttributeId().equals("opensciencegrid:authorization:attribute:GroupId") && ((XACMLObligation)cloneable).getDatatype().equals("http://www.w3.org/2001/XMLSchema#string")) {
                        localId.setGroupName(((XACMLObligation)cloneable).getValue());
                        continue;
                    }
                    log.error((Object)"Obligation has unexpected attributeId or datatype");
                    return null;
                }
                if (((XACMLObligation)cloneable).getObligationId().equals("opensciencegrid:authorization:SupGroupIdsObligation") && ((XACMLObligation)cloneable).getFullfillOn().equals("Permit")) {
                    log.debug((Object)"Found SupplementalGroupId obligation");
                    if (localId.getGroupName() != null) {
                        log.warn((Object)"Warning multiple SupplementalGroupIds Obligations, overriding previous");
                    }
                    if (((XACMLObligation)cloneable).getAttributeId().equals("opensciencegrid:authorization:attribute:SupGroupIds") && ((XACMLObligation)cloneable).getDatatype().equals("http://www.w3.org/2001/XMLSchema#string")) {
                        localId.setSupplementalGroupNames(((XACMLObligation)cloneable).getValue().split("\\s"));
                        continue;
                    }
                    log.error((Object)"Obligation has unexpected attributeId or datatype");
                    return null;
                }
                if (((XACMLObligation)cloneable).getObligationId().equals("opensciencegrid:authorization:RootPathObligation") && ((XACMLObligation)cloneable).getFullfillOn().equals("Permit")) {
                    log.debug((Object)"Found Root Path obligation");
                    if (localId.getGroupName() != null) {
                        log.warn((Object)"Warning multiple Root Path Obligations, overriding previous");
                    }
                    if (((XACMLObligation)cloneable).getAttributeId().equals("opensciencegrid:authorization:attribute:RootPath") && ((XACMLObligation)cloneable).getDatatype().equals("http://www.w3.org/2001/XMLSchema#string")) {
                        localId.setRootPath(((XACMLObligation)cloneable).getValue());
                        continue;
                    }
                    log.error((Object)"Obligation has unexpected attributeId or datatype");
                    return null;
                }
                if (((XACMLObligation)cloneable).getObligationId().equals("opensciencegrid:authorization:RelHomePathObligation") && ((XACMLObligation)cloneable).getFullfillOn().equals("Permit")) {
                    log.debug((Object)"Found Relative Home Path obligation");
                    if (localId.getRelativeHomePath() != null) {
                        log.warn((Object)"Warning multiple Relative Home Path Obligations, overriding previous");
                    }
                    if (((XACMLObligation)cloneable).getAttributeId().equals("opensciencegrid:authorization:attribute:RelHomePath") && ((XACMLObligation)cloneable).getDatatype().equals("http://www.w3.org/2001/XMLSchema#string")) {
                        localId.setRelativeHomePath(((XACMLObligation)cloneable).getValue());
                        continue;
                    }
                    log.error((Object)"Obligation has unexpected attributeId or datatype");
                    return null;
                }
                if (((XACMLObligation)cloneable).getObligationId().equals("opensciencegrid:authorization:FSRootPathObligation") && ((XACMLObligation)cloneable).getFullfillOn().equals("Permit")) {
                    log.debug((Object)"Found FS Root Path obligation");
                    if (localId.getFSRootPath() != null) {
                        log.warn((Object)"Warning multiple FS Root Path Obligations, overriding previous");
                    }
                    if (((XACMLObligation)cloneable).getAttributeId().equals("opensciencegrid:authorization:attribute:FSRootPath") && ((XACMLObligation)cloneable).getDatatype().equals("http://www.w3.org/2001/XMLSchema#string")) {
                        localId.setFSRootPath(((XACMLObligation)cloneable).getValue());
                        continue;
                    }
                    log.error((Object)"Obligation has unexpected attributeId or datatype");
                    return null;
                }
                if (((XACMLObligation)cloneable).getObligationId().equals("opensciencegrid:authorization:PriorityObligation") && ((XACMLObligation)cloneable).getFullfillOn().equals("Permit")) {
                    log.debug((Object)"Found Priority obligation");
                    if (localId.getPriority() != null) {
                        log.warn((Object)"Warning multiple Priority Obligations, overriding previous");
                    }
                    if (((XACMLObligation)cloneable).getAttributeId().equals("opensciencegrid:authorization:attribute:Priority") && ((XACMLObligation)cloneable).getDatatype().equals("http://www.w3.org/2001/XMLSchema#string")) {
                        localId.setPriority(((XACMLObligation)cloneable).getValue());
                        continue;
                    }
                    log.error((Object)"Obligation has unexpected attributeId or datatype");
                    return null;
                }
                if (((XACMLObligation)cloneable).getObligationId().equals("opensciencegrid:authorization:UIDObligation") && ((XACMLObligation)cloneable).getFullfillOn().equals("Permit")) {
                    log.debug((Object)"Found UID obligation");
                    if (localId.getUID() != null) {
                        log.warn((Object)"Warning multiple UID Obligations, overriding previous");
                    }
                    if (((XACMLObligation)cloneable).getAttributeId().equals("opensciencegrid:authorization:attribute:UID") && ((XACMLObligation)cloneable).getDatatype().equals("http://www.w3.org/2001/XMLSchema#integer")) {
                        localId.setUID(new Integer(((XACMLObligation)cloneable).getValue()));
                        continue;
                    }
                    log.error((Object)"Obligation has unexpected attributeId or datatype");
                    return null;
                }
                if (((XACMLObligation)cloneable).getObligationId().equals("opensciencegrid:authorization:GIDObligation") && ((XACMLObligation)cloneable).getFullfillOn().equals("Permit")) {
                    log.debug((Object)"Found GID obligation");
                    if (localId.getGID() != null) {
                        log.warn((Object)"Warning multiple GID Obligations, overriding previous");
                    }
                    if (((XACMLObligation)cloneable).getAttributeId().equals("opensciencegrid:authorization:attribute:GID") && ((XACMLObligation)cloneable).getDatatype().equals("http://www.w3.org/2001/XMLSchema#integer")) {
                        localId.setGID(new Integer(((XACMLObligation)cloneable).getValue()));
                        continue;
                    }
                    log.error((Object)"Obligation has unexpected attributeId or datatype");
                    return null;
                }
                if (((XACMLObligation)cloneable).getObligationId().equals("opensciencegrid:authorization:ReadOnlyObligation") && ((XACMLObligation)cloneable).getFullfillOn().equals("Permit")) {
                    log.debug((Object)"Found ReadOnly obligation");
                    if (localId.getReadOnlyFlag()) {
                        log.warn((Object)"Warning multiple ReadOnly Obligations");
                    }
                    if (((XACMLObligation)cloneable).getAttributeId().equals("opensciencegrid:authorization:attribute:ReadOnly") && ((XACMLObligation)cloneable).getDatatype().equals("http://www.w3.org/2001/XMLSchema#boolean")) {
                        if (((XACMLObligation)cloneable).getValue().compareToIgnoreCase("true") == 0) {
                            log.debug((Object)"ReadOnly obligation = true");
                            localId.setReadOnlyFlag(true);
                            continue;
                        }
                        log.debug((Object)"ReadOnly obligation = false");
                        localId.setReadOnlyFlag(false);
                        continue;
                    }
                    log.error((Object)"Obligation has unexpected attributeId or datatype");
                    return null;
                }
                log.error((Object)"Found unsupported obligation - mapping denied");
                return null;
            }
        }
        return localId;
    }

    public GlobusGSSCredentialImpl getGlobusCredentials() {
        return this.globusCredentials;
    }

    public void setGlobusCredentials(GlobusGSSCredentialImpl globusGSSCredentialImpl) {
        this.globusCredentials = globusGSSCredentialImpl;
    }
}

