/*
 * Decompiled with CFR 0.152.
 */
package org.opensciencegrid.authz.saml;

import java.io.InputStream;
import org.apache.log4j.Category;
import org.opensaml.MalformedException;
import org.opensaml.SAMLException;
import org.opensaml.SAMLObject;
import org.opensaml.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XACMLObligation
extends SAMLObject
implements Cloneable {
    protected String obligationId = null;
    protected String fullfillOn = null;
    protected String attributeId = null;
    protected String datatype = null;
    protected String value = null;
    static Category log = Category.getInstance((String)"XACMLObligation");

    public XACMLObligation(String string, String string2, String string3, String string4, String string5) throws SAMLException {
        if (string == null || string.length() == 0) {
            throw new MalformedException(SAMLException.RESPONDER, "XACMLObligation() requires ObligationID");
        }
        if (string2 == null || string2.length() == 0) {
            throw new MalformedException(SAMLException.RESPONDER, "XACMLObligation() requires FullfillOn");
        }
        if (string3 == null || string3.length() == 0 || string4 == null || string4.length() == 0) {
            throw new MalformedException(SAMLException.RESPONDER, "XACMLObligation() requires AttributeID and DataType");
        }
        this.obligationId = string;
        this.fullfillOn = string2;
        this.attributeId = string3;
        this.datatype = string4;
        this.value = string5;
    }

    public XACMLObligation() {
    }

    public XACMLObligation(Element element) throws SAMLException {
        this.fromDOM(element);
    }

    public XACMLObligation(InputStream inputStream) throws SAMLException {
        this.fromDOM(XACMLObligation.fromStream((InputStream)inputStream));
    }

    public void fromDOM(Element element) throws SAMLException {
        super.fromDOM(element);
        if (this.config.getBooleanProperty("org.opensaml.strict-dom-checking") && !XML.isElementNamed((Element)element, (String)"opensciencegrid:authorization:saml", (String)"XACMLObligation")) {
            throw new MalformedException(SAMLException.REQUESTER, "XACMLObligation.fromDOM() requires opensciencegrid:authorization:saml:XACMLObligation at root");
        }
        this.obligationId = element.getAttributeNS(null, "ObligationId");
        this.fullfillOn = element.getAttributeNS(null, "FullfillOn");
        NodeList nodeList = element.getElementsByTagNameNS("opensciencegrid:authorization:saml", "AttributeAssignment");
        if (nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                this.attributeId = ((Element)nodeList.item(i)).getAttribute("AttributeId");
                this.datatype = ((Element)nodeList.item(i)).getAttribute("Datatype");
                this.value = ((Element)nodeList.item(i)).getFirstChild().getNodeValue();
            }
        } else {
            throw new MalformedException("XACMLObligation requires at least one attribute assignment");
        }
        log.debug((Object)("parsed obligation with id " + this.obligationId + " to be fullfilled on " + this.fullfillOn));
        log.debug((Object)("attribute id is " + this.attributeId + " of datatype " + this.datatype));
        log.debug((Object)("and attribute value is " + this.value));
    }

    public Node toDOM(Document document) throws SAMLException {
        this.root = super.toDOM(document);
        if (this.root != null) {
            return this.root;
        }
        Element element = document.createElementNS("opensciencegrid:authorization:saml", "XACMLObligation");
        element.setAttributeNS(null, "ObligationId", this.obligationId);
        element.setAttributeNS(null, "FullfillOn", this.fullfillOn);
        Element element2 = document.createElementNS("opensciencegrid:authorization:saml", "AttributeAssignment");
        element2.setAttributeNS(null, "AttributeId", this.attributeId);
        element2.setAttributeNS(null, "Datatype", this.datatype);
        element2.appendChild(document.createTextNode(this.value));
        element.appendChild(element2);
        this.root = element;
        return this.root;
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            XACMLObligation xACMLObligation = new XACMLObligation(this.obligationId, this.fullfillOn, this.attributeId, this.datatype, this.value);
            return xACMLObligation;
        }
        catch (Exception exception) {
            throw new CloneNotSupportedException(exception.getMessage());
        }
    }

    public String getObligationId() {
        return this.obligationId;
    }

    public String getFullfillOn() {
        return this.fullfillOn;
    }

    public String getAttributeId() {
        return this.attributeId;
    }

    public String getDatatype() {
        return this.datatype;
    }

    public String getValue() {
        return this.value;
    }

    public void checkValidity() {
    }

    protected Element buildRoot(Document document, boolean bl) {
        return null;
    }
}

