/*
 * Decompiled with CFR 0.152.
 */
package org.opensciencegrid.authz.service;

import com.sun.xacml.Indenter;
import com.sun.xacml.Obligation;
import com.sun.xacml.PDP;
import com.sun.xacml.PDPConfig;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.StringAttribute;
import com.sun.xacml.attr.X500NameAttribute;
import com.sun.xacml.ctx.Attribute;
import com.sun.xacml.ctx.RequestCtx;
import com.sun.xacml.ctx.ResponseCtx;
import com.sun.xacml.ctx.Result;
import com.sun.xacml.ctx.Subject;
import com.sun.xacml.finder.AttributeFinder;
import com.sun.xacml.finder.PolicyFinder;
import com.sun.xacml.finder.impl.CurrentEnvModule;
import com.sun.xacml.finder.impl.FilePolicyModule;
import com.sun.xacml.finder.impl.SelectorModule;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.security.auth.x500.X500Principal;
import org.apache.log4j.Category;
import org.opensaml.SAMLAction;
import org.opensaml.SAMLException;
import org.opensaml.SAMLSubject;
import org.opensciencegrid.authz.client.GRIDIdentityMappingServiceClient;
import org.opensciencegrid.authz.common.GridId;
import org.opensciencegrid.authz.common.LocalId;
import org.opensciencegrid.authz.saml.XACMLObligation;
import org.opensciencegrid.authz.service.SAMLAuthZServiceBase;

public class PRIMAAuthorizationServiceImpl
extends SAMLAuthZServiceBase {
    static Category log = Category.getInstance((String)PRIMAAuthorizationServiceImpl.class.getName());
    private PDP pdp = null;
    private String policyDir = "/etc/grid-security/prima-policies";
    protected String serviceIdentity = "PRIMA Authorization Service";
    private String identityMappingServiceContact = "https://fledgling09.fnal.gov:8448/gums/services/GUMSAuthorizationServicePort";
    private String sslKey = "/etc/grid-security/hostkey.pem";
    private String sslCertfile = "/etc/grid-security/hostcert.pem";
    private String sslCAFiles = "/etc/grid-security/certificates/*.0";
    private String sslKeyPasswd;

    public PRIMAAuthorizationServiceImpl() {
        try {
            PRIMALogHandler pRIMALogHandler = new PRIMALogHandler();
            pRIMALogHandler.setFormatter(new SimpleFormatter());
            Logger.getLogger("com.sun.xacml").addHandler(pRIMALogHandler);
            Logger.getLogger("com.sun.xacml").setLevel(Level.FINEST);
            FilePolicyModule filePolicyModule = new FilePolicyModule();
            File file = new File(this.policyDir);
            if (file.isDirectory()) {
                String[] stringArray = file.list();
                if (stringArray != null && stringArray.length > 0) {
                    for (int i = 0; i < stringArray.length; ++i) {
                        filePolicyModule.addPolicy(this.policyDir + "/" + stringArray[i]);
                        log.debug((Object)("Loading XACML Policy file: " + this.policyDir + "/" + stringArray[i]));
                    }
                } else {
                    log.debug((Object)("No policy files found at: " + this.policyDir));
                }
            } else {
                log.error((Object)("No policy file directory found at: " + this.policyDir));
            }
            PolicyFinder policyFinder = new PolicyFinder();
            HashSet<FilePolicyModule> hashSet = new HashSet<FilePolicyModule>();
            hashSet.add(filePolicyModule);
            policyFinder.setModules(hashSet);
            CurrentEnvModule currentEnvModule = new CurrentEnvModule();
            SelectorModule selectorModule = new SelectorModule();
            AttributeFinder attributeFinder = new AttributeFinder();
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(currentEnvModule);
            arrayList.add(selectorModule);
            attributeFinder.setModules(arrayList);
            this.pdp = new PDP(new PDPConfig(attributeFinder, policyFinder, null));
        }
        catch (Exception exception) {
            log.error((Object)("Error instantiating XACML PDP " + exception.getMessage()));
            log.error((Object)exception);
        }
    }

    public SAMLAuthZServiceBase.AuthzDecision authorize(SAMLSubject sAMLSubject, String string, Iterator iterator, Iterator iterator2) throws SAMLException {
        Object object;
        log.debug((Object)("entered authorize method of: " + this.serviceIdentity));
        LocalId localId = null;
        SAMLAuthZServiceBase.FQAN fQAN = null;
        GridId gridId = new GridId();
        SAMLAuthZServiceBase.AuthzDecision authzDecision = new SAMLAuthZServiceBase.AuthzDecision();
        authzDecision.issuer = this.serviceIdentity;
        authzDecision.decision = "Indeterminate";
        log.debug((Object)"Checking if VOMS attribute (FQAN) is present in Subject Evidence");
        fQAN = this.findFQANinSubjectEvidence(iterator2, sAMLSubject);
        if (fQAN != null) {
            log.debug((Object)("found VOMS attribute with data \"" + fQAN.data + "\" from \"" + fQAN.issuer + "\""));
        } else {
            log.debug((Object)"no VOMS attribute found in Subject evidence");
        }
        gridId.setUserDN(sAMLSubject.getName().getName());
        gridId.setHostDN(string);
        if (fQAN != null) {
            gridId.setUserFQAN(fQAN.data);
            gridId.setUserFQANIssuer(fQAN.issuer);
        }
        log.debug((Object)("extracted from SAML Request: " + gridId.toString()));
        ArrayList<SAMLAction> arrayList = new ArrayList<SAMLAction>(1);
        arrayList.add(new SAMLAction("opensciencegrid:authorization", "access_as_local_identity"));
        authzDecision.actions = new ArrayList();
        while (iterator.hasNext()) {
            object = (SAMLAction)iterator.next();
            authzDecision.actions.add(object);
        }
        authzDecision.actions = this.locatePermissibleActions(authzDecision.actions.iterator(), arrayList);
        if (authzDecision.actions != null) {
            log.debug((Object)"At least one of the requested actions requires a local userid mapping, thus querying GUMS");
            log.debug((Object)"Request mapping from mapping service");
            try {
                log.debug((Object)("Identity mapping service contact: " + this.identityMappingServiceContact));
                this.setSslProperties();
                object = new GRIDIdentityMappingServiceClient(new URL(this.identityMappingServiceContact));
                localId = ((GRIDIdentityMappingServiceClient)object).mapCredentials(gridId);
            }
            catch (Exception exception) {
                log.error((Object)("Error contacting mapping service at " + this.identityMappingServiceContact));
                log.error((Object)exception.getMessage());
                throw new SAMLException("Error contacting mapping service at " + this.identityMappingServiceContact);
            }
            if (localId == null || localId.getUserName() == null) {
                log.debug((Object)"Received no mapping from mapping service --> DENY");
                authzDecision.decision = "Deny";
            } else {
                authzDecision.obligations = this.createObligations(localId);
            }
        }
        if (!authzDecision.decision.equals("Deny")) {
            try {
                log.debug((Object)"Creating XACML request context");
                object = new HashSet();
                URI uRI = new URI("opensciencegrid:authorization:attribute:UserId");
                ((HashSet)object).add(new Attribute(uRI, null, null, (AttributeValue)new StringAttribute(localId.getUserName())));
                URI uRI2 = new URI("opensciencegrid:authorization:attribute:UserDN");
                ((HashSet)object).add(new Attribute(uRI2, null, null, (AttributeValue)new X500NameAttribute(new X500Principal(gridId.getUserDN().replaceFirst("/", "").replaceAll("/", ", ")))));
                HashSet<Subject> hashSet = new HashSet<Subject>();
                hashSet.add(new Subject((Set)object));
                HashSet<Attribute> hashSet2 = new HashSet<Attribute>();
                hashSet2.add(new Attribute(new URI("urn:oasis:names:tc:xacml:1.0:resource:resource-id"), null, null, (AttributeValue)new X500NameAttribute(new X500Principal(gridId.getHostDN().replaceFirst("/", "").replaceAll("/", ", ")))));
                HashSet<Attribute> hashSet3 = new HashSet<Attribute>();
                URI uRI3 = new URI("urn:oasis:names:tc:xacml:1.0:action:action-id");
                for (int i = 0; i < authzDecision.actions.size(); ++i) {
                    hashSet3.add(new Attribute(uRI3, null, null, (AttributeValue)new StringAttribute(((SAMLAction)authzDecision.actions.get(i)).getData())));
                }
                RequestCtx requestCtx = new RequestCtx(hashSet, hashSet2, hashSet3, new HashSet());
                ResponseCtx responseCtx = this.pdp.evaluate(requestCtx);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                requestCtx.encode((OutputStream)byteArrayOutputStream, new Indenter());
                responseCtx.encode((OutputStream)byteArrayOutputStream, new Indenter());
                log.debug((Object)("Request/Response: " + byteArrayOutputStream.toString()));
                Set set = responseCtx.getResults();
                Iterator iterator3 = set.iterator();
                Result result = (Result)iterator3.next();
                if (result != null) {
                    log.debug((Object)("XACML policy decision is: " + Result.DECISIONS[result.getDecision()]));
                    authzDecision.decision = result.getDecision() == 1 ? "Deny" : (result.getDecision() == 0 ? "Permit" : "Indeterminate");
                    Set set2 = result.getObligations();
                    if (set2 != null) {
                        log.debug((Object)"Including obligations from XACML PDP response in SAML response");
                        Iterator iterator4 = set2.iterator();
                        while (iterator4.hasNext()) {
                            Obligation obligation = (Obligation)iterator4.next();
                            List list = obligation.getAssignments();
                            for (int i = 0; i < list.size(); ++i) {
                                Attribute attribute = (Attribute)list.get(i);
                                if (authzDecision.obligations == null) {
                                    authzDecision.obligations = new ArrayList();
                                }
                                authzDecision.obligations.add(new XACMLObligation(obligation.getId().toString(), Result.DECISIONS[obligation.getFulfillOn()], attribute.getId().toString(), attribute.getType().toString(), attribute.getValue().encode()));
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {
                log.error((Object)("Error querying XACML PDP engine: " + exception.getMessage()));
                log.error((Object)exception.getStackTrace()[0].toString());
                log.error((Object)exception);
                authzDecision.decision = "Indeterminate";
            }
        }
        if (authzDecision.decision.equals("Indeterminate")) {
            log.debug((Object)"XACML PDP could not produce a decision, responding with indeterminate");
            if (authzDecision.actions == null) {
                log.debug((Object)"Setting actions to mapping action to avoid empty action field");
                authzDecision.actions = new ArrayList(1);
                authzDecision.actions.add(new SAMLAction("opensciencegrid:authorization", "access_as_local_identity"));
            }
        }
        return authzDecision;
    }

    private ArrayList createObligations(LocalId localId) throws SAMLException {
        String[] stringArray;
        ArrayList<XACMLObligation> arrayList = new ArrayList<XACMLObligation>();
        String string = localId.getUserName();
        if (string != null) {
            arrayList.add(new XACMLObligation("opensciencegrid:authorization:UserIdObligation", "Permit", "opensciencegrid:authorization:attribute:UserId", "http://www.w3.org/2001/XMLSchema#string", string));
        }
        if ((string = localId.getGroupName()) != null) {
            arrayList.add(new XACMLObligation("opensciencegrid:authorization:GroupIdObligation", "Permit", "opensciencegrid:authorization:attribute:GroupId", "http://www.w3.org/2001/XMLSchema#string", string));
        }
        if ((stringArray = localId.getSupplementalGroupNames()) != null) {
            string = stringArray[0];
            for (int i = 1; i < stringArray.length; ++i) {
                string.concat(" " + stringArray[i]);
            }
            arrayList.add(new XACMLObligation("opensciencegrid:authorization:SupGroupIdsObligation", "Permit", "opensciencegrid:authorization:attribute:SupGroupIds", "http://www.w3.org/2001/XMLSchema#string", string));
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList;
    }

    private void setSslProperties() {
        System.setProperty("axis.socketSecureFactory", "org.glite.security.trustmanager.axis.AXISSocketFactory");
        log.debug((Object)("SSL properties (old): sslCAFiles='" + this.getSslCAFiles() + "' sslCertfile='" + this.getSslCertfile() + "' sslKey='" + this.getSslKey() + "' sslKeyPasswd set:" + (this.getSslKeyPasswd() != null) + "'"));
        if (this.getSslCAFiles() != null) {
            System.setProperty("sslCAFiles", this.getSslCAFiles());
        }
        if (this.getSslCertfile() != null) {
            System.setProperty("sslCertfile", this.getSslCertfile());
        }
        if (this.getSslKey() != null) {
            System.setProperty("sslKey", this.getSslKey());
        }
        if (this.getSslKeyPasswd() != null) {
            System.setProperty("sslKeyPasswd", this.getSslKeyPasswd());
        }
        log.debug((Object)("SSL properties (new): sslCAFiles='" + this.getSslCAFiles() + "' sslCertfile='" + this.getSslCertfile() + "' sslKey='" + this.getSslKey() + "' sslKeyPasswd set:" + (this.getSslKeyPasswd() != null) + "'"));
    }

    public String getSslKey() {
        return this.sslKey;
    }

    public void setSslKey(String string) {
        this.sslKey = string;
    }

    public String getSslCertfile() {
        return this.sslCertfile;
    }

    public void setSslCertfile(String string) {
        this.sslCertfile = string;
    }

    public String getSslCAFiles() {
        return this.sslCAFiles;
    }

    public void setSslCAFiles(String string) {
        this.sslCAFiles = string;
    }

    public String getSslKeyPasswd() {
        return this.sslKeyPasswd;
    }

    public void setSslKeyPasswd(String string) {
        this.sslKeyPasswd = string;
    }

    private class PRIMALogHandler
    extends Handler {
        Category log = Category.getInstance((String)(class$org$opensciencegrid$authz$service$PRIMAAuthorizationServiceImpl == null ? (class$org$opensciencegrid$authz$service$PRIMAAuthorizationServiceImpl = PRIMAAuthorizationServiceImpl.class$("org.opensciencegrid.authz.service.PRIMAAuthorizationServiceImpl")) : class$org$opensciencegrid$authz$service$PRIMAAuthorizationServiceImpl).getName());

        private PRIMALogHandler() {
        }

        public void close() {
        }

        public void flush() {
        }

        public void publish(LogRecord logRecord) {
            if (logRecord.getLevel() == Level.SEVERE) {
                this.log.error((Object)("XACML-PDP: " + logRecord.getMessage()));
            } else if (logRecord.getLevel() == Level.WARNING) {
                this.log.warn((Object)("XACML-PDP: " + logRecord.getMessage()));
            } else if (logRecord.getLevel() == Level.INFO) {
                this.log.info((Object)("XACML-PDP: " + logRecord.getMessage()));
            } else {
                this.log.debug((Object)("XACML-PDP: " + logRecord.getMessage()));
            }
        }
    }
}

