/*
 * Decompiled with CFR 0.152.
 */
package org.opensciencegrid.authz.service;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.glite.security.SecurityContext;
import org.glite.security.util.axis.InitSecurityContext;

public class SecurityUtil {
    private static Log log = LogFactory.getLog((Class)SecurityUtil.class);

    public static String retrieveClientDN() {
        try {
            InitSecurityContext.init();
            SecurityContext securityContext = SecurityContext.getCurrentContext();
            X509Certificate[] x509CertificateArray = securityContext.getClientCertChain();
            log.trace((Object)("Retrieved chain: " + x509CertificateArray));
            X509Certificate x509Certificate = x509CertificateArray[0];
            if (x509Certificate == null) {
                return null;
            }
            String string = x509Certificate.getSubjectX500Principal().toString();
            if (string.toLowerCase().indexOf("proxy") != -1) {
                string = x509Certificate.getIssuerX500Principal().toString();
            }
            log.trace((Object)("Retrieved DN: " + SecurityUtil.convertDN(string)));
            return SecurityUtil.convertDN(string);
        }
        catch (Throwable throwable) {
            log.error((Object)"Failed to retrieve client DN", throwable);
            throw new RuntimeException("Failed to retrieve client DN: " + throwable.getMessage());
        }
    }

    private static String convertDN(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        while (string.indexOf(", ") != -1) {
            int n = string.indexOf(", ");
            arrayList.add(string.substring(0, n));
            string = string.substring(n + 2);
        }
        arrayList.add(string);
        Collections.reverse(arrayList);
        Iterator iterator = arrayList.iterator();
        StringBuffer stringBuffer = new StringBuffer();
        while (iterator.hasNext()) {
            stringBuffer.append("/");
            stringBuffer.append((String)iterator.next());
        }
        return stringBuffer.toString();
    }
}

