/*
 * Decompiled with CFR 0.152.
 */
package org.opensciencegrid.authz.service;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.axis.MessageContext;
import org.apache.log4j.Category;
import org.opensaml.SAMLAction;
import org.opensaml.SAMLException;
import org.opensaml.SAMLSubject;
import org.opensciencegrid.authz.client.GRIDIdentityMappingServiceClient;
import org.opensciencegrid.authz.common.GridId;
import org.opensciencegrid.authz.common.LocalId;
import org.opensciencegrid.authz.saml.XACMLObligation;
import org.opensciencegrid.authz.service.SAMLAuthZServiceBase;

public class StorageAuthorizationServiceImpl
extends SAMLAuthZServiceBase {
    static Category log = Category.getInstance((String)StorageAuthorizationServiceImpl.class.getName());
    protected String serviceIdentity = "Simple Storage Authorization Service";
    private String identityMappingServiceContact = null;
    private String storagePolicyFile = "/etc/grid-security/storage-authzdb";
    private String sslKey = "/etc/grid-security/hostkey.pem";
    private String sslCertfile = "/etc/grid-security/hostcert.pem";
    private String sslCAFiles = "/etc/grid-security/certificates/*.0";
    private String sslKeyPasswd;

    protected SAMLAuthZServiceBase.AuthzDecision authorize(SAMLSubject sAMLSubject, String string, Iterator iterator, Iterator iterator2) throws SAMLException {
        log.debug((Object)("entered authorize method of: " + this.serviceIdentity));
        SAMLAuthZServiceBase.AuthzDecision authzDecision = new SAMLAuthZServiceBase.AuthzDecision(this);
        authzDecision.issuer = this.serviceIdentity;
        ArrayList<SAMLAction> arrayList = new ArrayList<SAMLAction>(1);
        arrayList.add(new SAMLAction("opensciencegrid:authorization", "access_as_local_identity"));
        log.debug((Object)"This service supports only the following action: access_as_local_identity");
        authzDecision.actions = this.locatePermissibleActions(iterator, arrayList);
        if (authzDecision.actions != null) {
            log.debug((Object)"Supported action is requested");
            log.debug((Object)"Checking if VOMS attribute (FQAN) is present in Subject Evidence");
            SAMLAuthZServiceBase.FQAN fQAN = this.findFQANinSubjectEvidence(iterator2, sAMLSubject);
            if (fQAN != null) {
                log.debug((Object)("found VOMS attribute with data \"" + fQAN.data + "\" from \"" + fQAN.issuer + "\""));
            } else {
                log.debug((Object)"no VOMS attribute found in Subject evidence");
            }
            GridId gridId = new GridId();
            gridId.setUserDN(sAMLSubject.getName().getName());
            gridId.setHostDN(string);
            if (fQAN != null) {
                gridId.setUserFQAN(fQAN.data);
                gridId.setUserFQANIssuer(fQAN.issuer);
            }
            log.debug((Object)"Request mapping from mapping service");
            LocalId localId = null;
            try {
                log.debug((Object)("Identity mapping service contact: " + this.identityMappingServiceContact));
                this.setSslProperties();
                this.identityMappingServiceContact = (String)MessageContext.getCurrentContext().getAxisEngine().getService("StorageAuthorizationServicePort").getOption("gumsurl");
                GRIDIdentityMappingServiceClient gRIDIdentityMappingServiceClient = new GRIDIdentityMappingServiceClient(new URL(this.identityMappingServiceContact));
                localId = gRIDIdentityMappingServiceClient.mapCredentials(gridId);
            }
            catch (Exception exception) {
                log.error((Object)("Error contacting mapping service at " + this.identityMappingServiceContact));
                log.error((Object)exception.getMessage());
                throw new SAMLException("Error contacting mapping service at " + this.identityMappingServiceContact);
            }
            if (localId != null) {
                log.debug((Object)"Received PERMIT decision from mapping service");
                authzDecision.decision = "Permit";
                authzDecision.obligations = this.createObligations(localId);
            } else {
                log.debug((Object)"Received DENY decision from mapping service");
                authzDecision.decision = "Deny";
            }
        } else {
            log.debug((Object)"No supported action was requested, responding with indeterminate");
            authzDecision.decision = "Indeterminate";
            log.debug((Object)"Setting actions to mapping action, obligations to null");
            authzDecision.actions = new ArrayList(1);
            authzDecision.actions.add(new SAMLAction("opensciencegrid:authorization", "access_as_local_identity"));
            authzDecision.obligations = null;
        }
        return authzDecision;
    }

    public LocalId authorize_local_id(SAMLSubject sAMLSubject, String string, Iterator iterator, Iterator iterator2, URL uRL) throws SAMLException {
        log.debug((Object)("entered authorize_local_id method of: " + this.serviceIdentity));
        LocalId localId = null;
        ArrayList<SAMLAction> arrayList = new ArrayList<SAMLAction>(1);
        arrayList.add(new SAMLAction("opensciencegrid:authorization", "access_as_local_identity"));
        log.debug((Object)"This service supports only the following action: access_as_local_identity");
        log.debug((Object)"Checking if VOMS attribute (FQAN) is present in Subject Evidence");
        SAMLAuthZServiceBase.FQAN fQAN = this.findFQANinSubjectEvidence(iterator2, sAMLSubject);
        if (fQAN != null) {
            log.debug((Object)("found VOMS attribute with data \"" + fQAN.data + "\" from \"" + fQAN.issuer + "\""));
        } else {
            log.debug((Object)"no VOMS attribute found in Subject evidence");
        }
        GridId gridId = new GridId();
        gridId.setUserDN(sAMLSubject.getName().getName());
        gridId.setHostDN(string);
        if (fQAN != null) {
            gridId.setUserFQAN(fQAN.data);
            gridId.setUserFQANIssuer(fQAN.issuer);
        }
        log.debug((Object)"Request mapping from mapping service");
        try {
            log.debug((Object)("Identity mapping service contact: " + uRL));
            this.setSslProperties();
            GRIDIdentityMappingServiceClient gRIDIdentityMappingServiceClient = new GRIDIdentityMappingServiceClient(uRL);
            localId = gRIDIdentityMappingServiceClient.mapCredentials(gridId);
        }
        catch (Exception exception) {
            throw new SAMLException("Error contacting mapping service at " + uRL + " " + exception.getMessage());
        }
        if (localId == null) {
            log.debug((Object)"Received DENY decision from mapping service");
            return null;
        }
        log.debug((Object)"Received PERMIT decision from mapping service");
        return localId;
    }

    private ArrayList createObligations(LocalId localId) throws SAMLException {
        Integer n;
        String[] stringArray;
        ArrayList<XACMLObligation> arrayList = new ArrayList<XACMLObligation>();
        String string = localId.getUserName();
        if (string != null) {
            arrayList.add(new XACMLObligation("opensciencegrid:authorization:UserIdObligation", "Permit", "opensciencegrid:authorization:attribute:UserId", "http://www.w3.org/2001/XMLSchema#string", string));
        }
        if ((string = localId.getGroupName()) != null) {
            arrayList.add(new XACMLObligation("opensciencegrid:authorization:GroupIdObligation", "Permit", "opensciencegrid:authorization:attribute:GroupId", "http://www.w3.org/2001/XMLSchema#string", string));
        }
        if ((stringArray = localId.getSupplementalGroupNames()) != null) {
            string = stringArray[0];
            for (int i = 1; i < stringArray.length; ++i) {
                string.concat(" " + stringArray[i]);
            }
            arrayList.add(new XACMLObligation("opensciencegrid:authorization:SupGroupIdsObligation", "Permit", "opensciencegrid:authorization:attribute:SupGroupIds", "http://www.w3.org/2001/XMLSchema#string", string));
        }
        if ((string = localId.getRootPath()) != null) {
            arrayList.add(new XACMLObligation("opensciencegrid:authorization:RootPathObligation", "Permit", "opensciencegrid:authorization:attribute:RootPath", "http://www.w3.org/2001/XMLSchema#string", string));
        }
        if ((string = localId.getRelativeHomePath()) != null) {
            arrayList.add(new XACMLObligation("opensciencegrid:authorization:RelHomePathObligation", "Permit", "opensciencegrid:authorization:attribute:RelHomePath", "http://www.w3.org/2001/XMLSchema#string", string));
        }
        if ((string = localId.getFSRootPath()) != null) {
            arrayList.add(new XACMLObligation("opensciencegrid:authorization:FSRootPathObligation", "Permit", "opensciencegrid:authorization:attribute:FSRootPath", "http://www.w3.org/2001/XMLSchema#string", string));
        }
        if ((string = localId.getPriority()) != null) {
            arrayList.add(new XACMLObligation("opensciencegrid:authorization:PriorityObligation", "Permit", "opensciencegrid:authorization:attribute:Priority", "http://www.w3.org/2001/XMLSchema#string", string));
        }
        if (localId.getReadOnlyFlag()) {
            arrayList.add(new XACMLObligation("opensciencegrid:authorization:ReadOnlyObligation", "Permit", "opensciencegrid:authorization:attribute:ReadOnly", "http://www.w3.org/2001/XMLSchema#boolean", "true"));
        }
        if ((n = localId.getUID()) != null) {
            arrayList.add(new XACMLObligation("opensciencegrid:authorization:UIDObligation", "Permit", "opensciencegrid:authorization:attribute:UID", "http://www.w3.org/2001/XMLSchema#integer", n.toString()));
        }
        if ((n = localId.getGID()) != null) {
            arrayList.add(new XACMLObligation("opensciencegrid:authorization:GIDObligation", "Permit", "opensciencegrid:authorization:attribute:GID", "http://www.w3.org/2001/XMLSchema#integer", n.toString()));
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList;
    }

    private void setSslProperties() {
        System.setProperty("axis.socketSecureFactory", "org.glite.security.trustmanager.axis.AXISSocketFactory");
        log.debug((Object)("SSL properties (old): sslCAFiles='" + this.getSslCAFiles() + "' sslCertfile='" + this.getSslCertfile() + "' sslKey='" + this.getSslKey() + "' sslKeyPasswd set:" + (this.getSslKeyPasswd() != null) + "'"));
        if (this.getSslCAFiles() != null) {
            System.setProperty("sslCAFiles", this.getSslCAFiles());
        }
        if (this.getSslCertfile() != null) {
            System.setProperty("sslCertfile", this.getSslCertfile());
        }
        if (this.getSslKey() != null) {
            System.setProperty("sslKey", this.getSslKey());
        }
        if (this.getSslKeyPasswd() != null) {
            System.setProperty("sslKeyPasswd", this.getSslKeyPasswd());
        }
        log.debug((Object)("SSL properties (new): sslCAFiles='" + this.getSslCAFiles() + "' sslCertfile='" + this.getSslCertfile() + "' sslKey='" + this.getSslKey() + "' sslKeyPasswd set:" + (this.getSslKeyPasswd() != null) + "'"));
    }

    public String getSslKey() {
        return this.sslKey;
    }

    public void setSslKey(String string) {
        this.sslKey = string;
    }

    public String getSslCertfile() {
        return this.sslCertfile;
    }

    public void setSslCertfile(String string) {
        this.sslCertfile = string;
    }

    public String getSslCAFiles() {
        return this.sslCAFiles;
    }

    public void setSslCAFiles(String string) {
        this.sslCAFiles = string;
    }

    public String getSslKeyPasswd() {
        return this.sslKeyPasswd;
    }

    public void setSslKeyPasswd(String string) {
        this.sslKeyPasswd = string;
    }
}

