/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.resolve;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.openxri.XRIAuthority;
import org.openxri.XRISubSegment;
import org.openxri.resolve.Cache;
import org.openxri.resolve.CacheResult;

class CacheNode {
    Cache.CachedValue moCacheValue = null;
    Map moCacheHash = Collections.synchronizedMap(new HashMap());
    CacheNode moParent = null;
    String msSubsegment = null;
    CacheNode moPrev = null;
    CacheNode moNext = null;
    Cache moCache = null;

    CacheNode(Cache oCache) {
        this.moCache = oCache;
        this.moNext = this;
        this.moPrev = this;
    }

    CacheNode(CacheNode oParent, String sSubsegment) {
        this.moParent = oParent;
        this.msSubsegment = sSubsegment;
        this.moCache = oParent.moCache;
        this.moCache.increment();
        this.addToFront();
    }

    void touch() {
        this.detach();
        this.addToFront();
    }

    boolean removeSelf(boolean bRemoveFromParent) {
        if (this.moParent == null) {
            return false;
        }
        this.detach();
        this.moCache.decrement();
        Iterator oChild = this.moCacheHash.values().iterator();
        while (oChild.hasNext()) {
            ((CacheNode)oChild.next()).removeSelf(false);
        }
        if (!bRemoveFromParent) {
            return true;
        }
        return this.moParent.moCacheHash.remove(this.msSubsegment) != null;
    }

    CacheResult find(XRIAuthority oAuth, int nNextSubsegment, boolean bCompleteChain, Vector oCachedDescriptors) {
        XRISubSegment oSubSegment = oAuth.getSubSegmentAt(nNextSubsegment);
        if (oSubSegment == null) {
            return new CacheResult(this, nNextSubsegment);
        }
        CacheNode oNode = this.find(oSubSegment.toString());
        if (oNode == null) {
            return new CacheResult(this, nNextSubsegment);
        }
        if (oNode.moCacheValue == null || oNode.moCacheValue.getDescriptor() == null) {
            if (bCompleteChain) {
                return new CacheResult(this, nNextSubsegment);
            }
        } else if (oCachedDescriptors != null) {
            oCachedDescriptors.add(oNode.moCacheValue.getDescriptor());
        }
        return oNode.find(oAuth, nNextSubsegment + 1, bCompleteChain, oCachedDescriptors);
    }

    CacheNode mkdir(XRIAuthority oAuth, int n, int iTargetDepth) {
        XRISubSegment oSubSegment = oAuth.getSubSegmentAt(n);
        if (oSubSegment == null) {
            return this;
        }
        CacheNode oNode = this.mkdir(oSubSegment.toString());
        return n + 1 < iTargetDepth ? oNode.mkdir(oAuth, n + 1, iTargetDepth) : oNode;
    }

    CacheNode mkdir(String sSubSegment) {
        CacheNode oNode = this.find(sSubSegment);
        if (oNode == null) {
            oNode = new CacheNode(this, sSubSegment);
            this.moCacheHash.put(sSubSegment, oNode);
        }
        return oNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CacheNode find(String sSubSegment) {
        CacheNode oNode = (CacheNode)this.moCacheHash.get(sSubSegment);
        if (oNode != null) {
            Cache cache = this.moCache;
            synchronized (cache) {
                if (oNode.moNext == null) {
                    return null;
                }
                oNode.touch();
            }
        }
        return oNode;
    }

    private void addToFront() {
        this.moPrev = this.moCache.moRootNode;
        this.moNext = this.moCache.moRootNode.moNext;
        this.moCache.moRootNode.moNext = this;
        this.moNext.moPrev = this;
    }

    private void detach() {
        this.moPrev.moNext = this.moNext;
        this.moNext.moPrev = this.moPrev;
        this.moNext = null;
        this.moPrev = null;
    }
}

