/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.resolve;

import java.net.URI;
import java.util.ArrayList;
import org.openxri.GCSAuthority;
import org.openxri.XRI;
import org.openxri.XRIAuthority;
import org.openxri.resolve.Cache;
import org.openxri.xml.XRD;

public class ResolverState {
    private long timeStarted;
    private ArrayList steps;
    private int numRefsFollowed = 0;
    private int numRequests = 0;
    private int numBytesReceived = 0;
    private Cache moBasicCache = new Cache(1000);
    private Cache moTrustedCache = new Cache(1000);

    public ResolverState() {
        this.timeStarted = System.currentTimeMillis();
        this.steps = new ArrayList();
    }

    public long getTimeStarted() {
        return this.timeStarted;
    }

    public int getNumRefsFollowed() {
        return this.numRefsFollowed;
    }

    public int getNumRequests() {
        return this.numRequests;
    }

    public int getNumBytesReceived() {
        return this.numBytesReceived;
    }

    public ResolverStep getStepAt(int i) {
        return (ResolverStep)this.steps.get(i);
    }

    public int getNumSteps() {
        return this.steps.size();
    }

    public void pushResolved(String qxri, String trustType, String xrds, URI uri) {
        ResolverStep step = new ResolverStep(qxri, trustType, xrds, null, uri);
        this.steps.add(step);
        ++this.numRequests;
        this.numBytesReceived += xrds.length();
    }

    public void pushFollowingRef(XRI ref) {
        ResolverStep step = new ResolverStep(null, null, null, ref, null);
        this.steps.add(step);
        ++this.numRefsFollowed;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("NumRequests=" + this.numRequests + ", numRefsFollowed=" + this.numRefsFollowed + ", numBytesReceived=" + this.numBytesReceived + "\n");
        for (int i = 0; i < this.getNumSteps(); ++i) {
            ResolverStep step = this.getStepAt(i);
            sb.append(step.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public Cache getCache(boolean bTrusted) {
        return bTrusted ? this.moBasicCache : this.moTrustedCache;
    }

    public void set(XRIAuthority oAuth, XRD oDesc) {
        this.moBasicCache.stuff(oAuth, oDesc);
        this.moTrustedCache.stuff(oAuth, oDesc);
    }

    public void reset(XRIAuthority oAuth) {
        this.moBasicCache.prune(oAuth);
        this.moTrustedCache.prune(oAuth);
    }

    public void setAtAuthority(XRD oDesc) {
        GCSAuthority oAuth = new GCSAuthority("@");
        this.set((XRIAuthority)oAuth, oDesc);
    }

    public void setEqualsAuthority(XRD oDesc) {
        GCSAuthority oAuth = new GCSAuthority("=");
        this.set((XRIAuthority)oAuth, oDesc);
    }

    public class ResolverStep {
        public final String qxri;
        public final String trust;
        public final String xrds;
        public final URI uri;
        public final XRI ref;
        public final long timeCompleted;

        public ResolverStep(String qxri, String trust, String xrds, XRI ref, URI uri) {
            this.qxri = qxri;
            this.trust = trust;
            this.xrds = xrds;
            this.ref = ref;
            this.uri = uri;
            this.timeCompleted = System.currentTimeMillis();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("QXRI=");
            sb.append(this.qxri);
            sb.append(", trust=");
            sb.append(this.trust);
            sb.append(", uri=");
            sb.append(this.uri == null ? "null" : this.uri.toASCIIString());
            sb.append(", ref=");
            sb.append(this.ref);
            sb.append(", elapsed=");
            sb.append(this.timeCompleted - ResolverState.this.timeStarted);
            sb.append("ms\n\nXRDS = \n");
            sb.append(this.xrds);
            return sb.toString();
        }
    }
}

