/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.xml;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.KeyInfo;
import org.openxri.XRIParseException;
import org.openxri.util.DOMUtils;
import org.openxri.util.PrioritizedList;
import org.openxri.xml.LocalID;
import org.openxri.xml.ProviderID;
import org.openxri.xml.Redirect;
import org.openxri.xml.Ref;
import org.openxri.xml.SEPElement;
import org.openxri.xml.SEPMediaType;
import org.openxri.xml.SEPPath;
import org.openxri.xml.SEPType;
import org.openxri.xml.SEPUri;
import org.openxri.xml.XRD;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class Service
implements Cloneable,
Serializable {
    private static Log soLog = LogFactory.getLog((String)Service.class.getName());
    private ProviderID providerID;
    private Vector localIDs;
    private List types;
    private List paths;
    private List mediaTypes;
    private Integer priority;
    private KeyInfo keyInfo;
    private List uris;
    private PrioritizedList prioritizedURIs;
    private Vector redirects;
    private PrioritizedList prioritizedRedirects = null;
    private Vector refs;
    private PrioritizedList prioritizedRefs = null;
    private HashMap otherChildrenVectorMap = new HashMap();

    public Service() {
        this.reset();
    }

    public Service(Element oElem) throws URISyntaxException {
        this.fromDOM(oElem);
    }

    public void reset() {
        this.providerID = null;
        this.localIDs = new Vector();
        this.types = new Vector();
        this.paths = new Vector();
        this.mediaTypes = new Vector();
        this.priority = null;
        this.keyInfo = null;
        this.uris = new Vector();
        this.prioritizedURIs = null;
        this.redirects = new Vector();
        this.prioritizedRedirects = null;
        this.refs = new Vector();
        this.prioritizedRefs = null;
        this.otherChildrenVectorMap = new HashMap();
    }

    public void fromDOM(Element oElem) throws URISyntaxException {
        this.reset();
        String val = oElem.getAttribute("priority");
        if (val != null && val.length() > 0) {
            this.setPriority(new Integer(val));
        }
        Element oChild = DOMUtils.getFirstChildElement(oElem);
        while (oChild != null) {
            String sChildName = oChild.getLocalName();
            if (sChildName == null) {
                sChildName = oChild.getNodeName();
            }
            if (sChildName.equals("Type")) {
                this.types.add(SEPType.fromXML(oChild));
            } else if (sChildName.equals("ProviderID")) {
                ProviderID p = new ProviderID();
                p.fromXML(oChild);
                this.providerID = p;
            } else if (sChildName.equals("Path")) {
                this.paths.add(SEPPath.fromXML(oChild));
            } else if (sChildName.equals("MediaType")) {
                this.mediaTypes.add(SEPMediaType.fromXML(oChild));
            } else if (sChildName.equals("URI")) {
                this.addURI(SEPUri.fromXML(oChild));
            } else if (sChildName.equals("Ref")) {
                this.addRef(new Ref(oChild));
            } else if (sChildName.equals("Redirect")) {
                this.addRedirect(new Redirect(oChild));
            } else if (sChildName.equals("LocalID")) {
                this.addLocalID(new LocalID(oChild));
            } else if (oChild.getNamespaceURI() != null && oChild.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#") && oChild.getLocalName() != null && oChild.getLocalName().equals("KeyInfo")) {
                try {
                    this.keyInfo = new KeyInfo(oChild, "");
                }
                catch (XMLSecurityException oEx) {
                    soLog.warn((Object)"Error constructing KeyInfo.", (Throwable)oEx);
                }
            } else {
                Vector<Node> oVector = (Vector<Node>)this.otherChildrenVectorMap.get(sChildName);
                if (oVector == null) {
                    oVector = new Vector<Node>();
                    this.otherChildrenVectorMap.put(sChildName, oVector);
                }
                oVector.add(oChild.cloneNode(true));
            }
            oChild = DOMUtils.getNextSiblingElement(oChild);
        }
    }

    public String getMediaType() {
        soLog.warn((Object)"getMediaType - deprecated.");
        SEPMediaType mtype = this.getMediaTypeAt(0);
        return mtype != null ? mtype.getValue() : null;
    }

    public int getNumMediaTypes() {
        return this.mediaTypes == null ? 0 : this.mediaTypes.size();
    }

    public SEPMediaType getMediaTypeAt(int n) {
        if (this.mediaTypes != null) {
            return (SEPMediaType)this.mediaTypes.get(n);
        }
        return null;
    }

    public void setMediaType(String sVal) {
        soLog.warn((Object)"setMediaType - deprecated.");
        SEPMediaType mediaType = new SEPMediaType(sVal, null, null);
        this.mediaTypes.add(mediaType);
    }

    public void addMediaType(String sVal) {
        this.addMediaType(sVal, null, null);
    }

    public void addMediaType(String sVal, String match, Boolean select) {
        SEPMediaType mediaType = new SEPMediaType(sVal, match, select);
        this.mediaTypes.add(mediaType);
    }

    public String getType() {
        soLog.warn((Object)"getType is deprecated.");
        SEPType type = this.getTypeAt(0);
        return type != null ? type.getValue() : null;
    }

    public int getNumTypes() {
        return this.types == null ? 0 : this.types.size();
    }

    public SEPType getTypeAt(int n) {
        if (this.types != null) {
            return (SEPType)this.types.get(n);
        }
        return null;
    }

    public void setType(String sVal) {
        soLog.warn((Object)"setType is deprecated.");
        this.types.add(new SEPType(sVal, null, null));
    }

    public void addType(String sVal) {
        this.addType(sVal, null, null);
    }

    public void addType(String sVal, String match, Boolean select) {
        this.types.add(new SEPType(sVal, match, select));
    }

    public boolean matchType(String sVal) {
        for (int i = 0; i < this.getNumTypes(); ++i) {
            SEPType type = this.getTypeAt(i);
            if (!type.match(sVal)) continue;
            return true;
        }
        return false;
    }

    public int getNumURIs() {
        return this.uris == null ? 0 : this.uris.size();
    }

    public SEPUri getURI() {
        soLog.warn((Object)"getURI is deprecated.");
        return this.getURIAt(0);
    }

    public SEPUri getURIAt(int n) {
        return n < this.getNumURIs() ? (SEPUri)this.uris.get(n) : null;
    }

    public SEPUri getURIForScheme(String sScheme) {
        if (sScheme == null) {
            return null;
        }
        for (int i = 0; i < this.getNumURIs(); ++i) {
            SEPUri oURI = this.getURIAt(i);
            if (oURI == null || oURI.getURI() == null || !oURI.getURI().getScheme().equalsIgnoreCase(sScheme)) continue;
            return oURI;
        }
        return null;
    }

    public List getURIs() {
        return this.uris;
    }

    public ArrayList getPrioritizedURIs() {
        if (this.prioritizedURIs == null) {
            return new ArrayList();
        }
        return this.prioritizedURIs.getList();
    }

    public void addURI(String sURI) {
        this.addURI(sURI, null, null);
    }

    public void addURI(String sURI, Integer priority, String append) {
        try {
            SEPUri uri = new SEPUri(sURI, priority, append);
            this.addURI(uri);
        }
        catch (Exception e) {
            throw new XRIParseException("BadURI", e);
        }
    }

    public void addURI(SEPUri uri) {
        if (this.prioritizedURIs == null) {
            this.prioritizedURIs = new PrioritizedList();
        }
        this.uris.add(uri);
        Integer priority = uri.getPriority();
        this.prioritizedURIs.addObject(priority == null ? "null" : priority.toString(), uri);
    }

    public SEPPath getPathAt(int n) {
        return n < this.getNumPaths() ? (SEPPath)this.paths.get(n) : null;
    }

    public void addPath(String sPath) {
        this.addPath(sPath, null, null);
    }

    public void addPath(String sPath, String match, Boolean select) {
        try {
            this.paths.add(new SEPPath(sPath, match, select));
        }
        catch (Exception e) {
            throw new XRIParseException("BadPath", e);
        }
    }

    public int getNumPaths() {
        return this.paths == null ? 0 : this.paths.size();
    }

    public String getProviderId() {
        return this.providerID != null ? this.providerID.getValue() : null;
    }

    public void setProviderId(String val) {
        this.providerID = new ProviderID(val);
    }

    public void setKeyInfo(KeyInfo oKeyInfo) {
        this.keyInfo = oKeyInfo;
    }

    public KeyInfo getKeyInfo() {
        return this.keyInfo;
    }

    public boolean setOtherTagValues(String sTag, String sTagValue) {
        String xmlStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + sTagValue;
        boolean returnValue = false;
        try {
            ByteArrayInputStream oIn = new ByteArrayInputStream(xmlStr.getBytes());
            DOMParser oDOMParser = DOMUtils.getDOMParser();
            oDOMParser.parse(new InputSource(oIn));
            Document oDOMDoc = oDOMParser.getDocument();
            Element oElement = oDOMDoc.getDocumentElement();
            Vector<Node> oVector = (Vector<Node>)this.otherChildrenVectorMap.get(sTag);
            if (oVector == null) {
                oVector = new Vector<Node>();
                this.otherChildrenVectorMap.put(sTag, oVector);
            }
            oVector.add(oElement.cloneNode(true));
            returnValue = true;
        }
        catch (Exception exp) {
            exp.printStackTrace();
            returnValue = false;
        }
        return returnValue;
    }

    public Vector getOtherTagValues(String sTag) {
        return (Vector)this.otherChildrenVectorMap.get(sTag);
    }

    public void setExtension(String extension) throws URISyntaxException, ParseException {
        String xmlStr = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><xrd xmlns=\"xri://$xrd*($v*2.0)\"><Service>" + extension + "</Service></xrd>";
        Service tempService = XRD.parseXRD(xmlStr, false).getServiceAt(0);
        this.otherChildrenVectorMap = tempService.otherChildrenVectorMap;
        if (tempService.getKeyInfo() != null) {
            this.setKeyInfo(tempService.getKeyInfo());
        }
    }

    public String getExtension() {
        StringBuffer extension = new StringBuffer();
        for (String sTag : this.otherChildrenVectorMap.keySet()) {
            Vector oValues = (Vector)this.otherChildrenVectorMap.get(sTag);
            for (int i = 0; i < oValues.size(); ++i) {
                Node oChild = (Node)oValues.get(i);
                extension.append(DOMUtils.toString((Element)oChild, true, true));
            }
        }
        return extension.toString();
    }

    public Node toDOM(Document oDoc) {
        return this.toDOM(oDoc, false);
    }

    public Node toDOM(Document doc, boolean wantFiltered) {
        int i;
        int i2;
        Element elem = doc.createElementNS("xri://$xrd*($v*2.0)", "Service");
        if (this.getPriority() != null) {
            elem.setAttribute("priority", this.getPriority().toString());
        }
        if (this.providerID != null && this.providerID.getValue() != null) {
            elem.appendChild(this.providerID.toXML(doc));
        }
        for (i2 = 0; i2 < this.getNumTypes(); ++i2) {
            SEPType type = this.getTypeAt(i2);
            elem.appendChild(type.toXML(doc, "Type"));
        }
        for (i2 = 0; i2 < this.getNumPaths(); ++i2) {
            SEPPath path = this.getPathAt(i2);
            elem.appendChild(path.toXML(doc, "Path"));
        }
        for (i2 = 0; i2 < this.getNumMediaTypes(); ++i2) {
            SEPMediaType mtype = this.getMediaTypeAt(i2);
            elem.appendChild(mtype.toXML(doc, "MediaType"));
        }
        if (wantFiltered) {
            ArrayList uris = this.getPrioritizedURIs();
            for (int i3 = 0; i3 < uris.size(); ++i3) {
                SEPUri u = (SEPUri)uris.get(i3);
                elem.appendChild(u.toXML(doc, "URI"));
            }
        } else {
            for (i2 = 0; i2 < this.getNumURIs(); ++i2) {
                SEPUri uri = this.getURIAt(i2);
                elem.appendChild(uri.toXML(doc, "URI"));
            }
        }
        for (i = 0; i < this.getNumRedirects(); ++i) {
            Redirect redir = this.getRedirectAt(i);
            elem.appendChild(redir.toXML(doc, "Redirect"));
        }
        for (i = 0; i < this.getNumRefs(); ++i) {
            Ref ref = this.getRefAt(i);
            elem.appendChild(ref.toXML(doc, "Ref"));
        }
        for (i = 0; i < this.getNumLocalIDs(); ++i) {
            Element localID = this.getLocalIDAt(i).toXML(doc);
            elem.appendChild(localID);
        }
        if (this.getKeyInfo() != null) {
            Node oChild = doc.importNode(this.getKeyInfo().getElement(), true);
            elem.appendChild(oChild);
        }
        for (String sTag : this.otherChildrenVectorMap.keySet()) {
            Vector oValues = (Vector)this.otherChildrenVectorMap.get(sTag);
            for (int i4 = 0; i4 < oValues.size(); ++i4) {
                Node oChild = (Node)oValues.get(i4);
                Node oChild2 = doc.importNode(oChild, true);
                elem.appendChild(oChild2);
            }
        }
        return elem;
    }

    public String toString() {
        return this.dump();
    }

    public String dump() {
        DocumentImpl doc = new DocumentImpl();
        Node elm = this.toDOM((Document)doc);
        doc.appendChild(elm);
        return DOMUtils.toString((Document)doc);
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public void setPriority(String priority) {
        this.priority = new Integer(priority);
    }

    public List getMediaTypes() {
        return this.mediaTypes;
    }

    public HashMap getOtherChildrenVectorMap() {
        return this.otherChildrenVectorMap;
    }

    public List getPaths() {
        return this.paths;
    }

    public List getTypes() {
        return this.types;
    }

    public void addType(SEPType type) {
        if (type == null) {
            return;
        }
        this.types.add(type);
    }

    public void addMediaType(SEPMediaType mtype) {
        if (mtype == null) {
            return;
        }
        this.mediaTypes.add(mtype);
    }

    public void addPath(SEPPath path) {
        if (path == null) {
            return;
        }
        this.paths.add(path);
    }

    public void setPrioritizedURIs(PrioritizedList prioritizedURIs) {
        this.prioritizedURIs = prioritizedURIs;
    }

    public Object clone() throws CloneNotSupportedException {
        Serializable element;
        int i;
        Service srvc = new Service();
        srvc.keyInfo = this.keyInfo;
        srvc.otherChildrenVectorMap = this.otherChildrenVectorMap;
        srvc.prioritizedURIs = this.prioritizedURIs;
        srvc.priority = this.priority;
        srvc.providerID = this.providerID;
        srvc.refs = this.refs;
        srvc.prioritizedRefs = this.prioritizedRefs;
        srvc.redirects = this.redirects;
        srvc.prioritizedRedirects = this.prioritizedRedirects;
        srvc.localIDs = this.localIDs;
        srvc.uris = null;
        srvc.types = null;
        srvc.mediaTypes = null;
        srvc.paths = null;
        Vector<Object> elements = null;
        if (this.types != null) {
            elements = new Vector<Object>();
            for (i = 0; i < this.types.size(); ++i) {
                element = (SEPElement)this.types.get(i);
                elements.add(((SEPElement)element).clone());
            }
            srvc.types = elements;
        }
        if (this.mediaTypes != null) {
            elements = new Vector();
            for (i = 0; i < this.mediaTypes.size(); ++i) {
                element = (SEPElement)this.mediaTypes.get(i);
                elements.add(((SEPElement)element).clone());
            }
            srvc.mediaTypes = elements;
        }
        if (this.paths != null) {
            elements = new Vector();
            for (i = 0; i < this.paths.size(); ++i) {
                element = (SEPElement)this.paths.get(i);
                elements.add(((SEPElement)element).clone());
            }
            srvc.paths = elements;
        }
        if (this.uris != null) {
            elements = new Vector();
            for (i = 0; i < this.uris.size(); ++i) {
                element = (SEPUri)this.uris.get(i);
                elements.add(((SEPUri)element).clone());
            }
            srvc.uris = elements;
        }
        return srvc;
    }

    public void setURIs(List uris) {
        this.uris = uris;
    }

    public void setMediaTypes(List mediaTypes) {
        this.mediaTypes = mediaTypes;
    }

    public void setPaths(List paths) {
        this.paths = paths;
    }

    public void setTypes(List types) {
        this.types = types;
    }

    public Vector getRefs() {
        return (Vector)this.refs.clone();
    }

    public Ref getRefAt(int n) {
        return (Ref)this.refs.get(n);
    }

    public int getNumRefs() {
        return this.refs.size();
    }

    public void addRef(Ref ref) {
        if (this.prioritizedRefs == null) {
            this.prioritizedRefs = new PrioritizedList();
        }
        Integer priority = ref.getPriority();
        this.refs.add(ref);
        this.prioritizedRefs.addObject(priority == null ? "null" : priority.toString(), ref);
    }

    public ArrayList getPrioritizedRefs() {
        return this.prioritizedRefs.getList();
    }

    public Vector getRedirects() {
        return (Vector)this.redirects.clone();
    }

    public Redirect getRedirectAt(int n) {
        return (Redirect)this.redirects.get(n);
    }

    public int getNumRedirects() {
        return this.redirects.size();
    }

    public void addRedirect(Redirect redirect) {
        if (this.prioritizedRedirects == null) {
            this.prioritizedRedirects = new PrioritizedList();
        }
        Integer priority = redirect.getPriority();
        this.redirects.add(redirect);
        this.prioritizedRedirects.addObject(priority == null ? "null" : priority.toString(), redirect);
    }

    public ArrayList getPrioritizedRedirects() {
        return this.prioritizedRedirects.getList();
    }

    public int getNumLocalIDs() {
        return this.localIDs.size();
    }

    public LocalID getLocalIDAt(int n) {
        return (LocalID)this.localIDs.get(n);
    }

    public void addLocalID(LocalID localId) {
        this.localIDs.add(localId);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Service)) {
            return false;
        }
        Service other = (Service)o;
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.providerID == null && other.providerID != null) {
            return false;
        }
        if (this.providerID != null && !this.providerID.equals(other.providerID)) {
            return false;
        }
        if (this.priority == null && other.priority != null) {
            return false;
        }
        if (this.priority != null && !this.priority.equals(other.priority)) {
            return false;
        }
        if (this.types == null && other.types != null) {
            return false;
        }
        if (this.types != null && !((Object)this.types).equals(other.types)) {
            return false;
        }
        if (this.paths == null && other.paths != null) {
            return false;
        }
        if (this.paths != null && !((Object)this.paths).equals(other.paths)) {
            return false;
        }
        if (this.mediaTypes == null && other.mediaTypes != null) {
            return false;
        }
        if (this.mediaTypes != null && !((Object)this.mediaTypes).equals(other.mediaTypes)) {
            return false;
        }
        if (this.uris == null && other.uris != null) {
            return false;
        }
        if (this.uris != null && !((Object)this.uris).equals(other.uris)) {
            return false;
        }
        if (this.otherChildrenVectorMap == null && other.otherChildrenVectorMap != null) {
            return false;
        }
        if (this.otherChildrenVectorMap != null && !this.otherChildrenVectorMap.equals(other.otherChildrenVectorMap)) {
            return false;
        }
        if (this.prioritizedURIs == null && other.prioritizedURIs != null) {
            return false;
        }
        return this.prioritizedURIs == null || this.prioritizedURIs.equals(other.prioritizedURIs);
    }
}

