/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.xml;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.xerces.dom.DocumentImpl;
import org.openxri.util.DOMUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class SimpleXMLElement
implements Cloneable,
Serializable {
    private String value = null;
    private String tag = null;
    protected Hashtable attributes = null;

    public SimpleXMLElement(SimpleXMLElement s) {
        this.value = s.value;
        this.tag = s.tag;
        if (s.attributes != null) {
            this.attributes = (Hashtable)s.attributes.clone();
        }
    }

    public SimpleXMLElement(String tagname) {
        this.reset(tagname);
    }

    public SimpleXMLElement(String tagname, String sValue) {
        this.reset(tagname);
        this.value = sValue;
    }

    protected void reset(String tagName) {
        this.value = null;
        this.attributes = null;
        this.tag = tagName;
    }

    public String getTagname() {
        return this.tag;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void addAttribute(String attrName, String attrValue) {
        if (attrName == null || attrValue == null) {
            return;
        }
        if (this.attributes == null) {
            this.attributes = new Hashtable();
        }
        this.attributes.put(attrName, attrValue);
    }

    public String getAttributeValue(String attrName) {
        if (attrName == null || this.attributes == null) {
            return null;
        }
        return (String)this.attributes.get(attrName);
    }

    public void removeAttribute(String attrName) {
        if (this.attributes == null) {
            return;
        }
        this.attributes.remove(attrName);
    }

    public Element toXML(Document doc, String tag) {
        Element body = doc.createElement(tag);
        if (this.attributes != null) {
            Enumeration keys = this.attributes.keys();
            while (keys.hasMoreElements()) {
                String attrName = (String)keys.nextElement();
                String attrValue = (String)this.attributes.get(attrName);
                body.setAttribute(attrName, attrValue);
            }
        }
        if (this.value != null) {
            body.appendChild(doc.createTextNode(this.value));
        }
        return body;
    }

    public Element toXML(Document doc) {
        return this.toXML(doc, this.tag);
    }

    public void fromXML(Node root) {
        if (root.getNodeType() == 1) {
            this.tag = root.getLocalName();
            if (this.tag == null) {
                this.tag = root.getNodeName();
            }
            this.setValue(DOMUtils.getText(root));
            NamedNodeMap attribs = root.getAttributes();
            for (int i = 0; i < attribs.getLength(); ++i) {
                Node attribNode = attribs.item(i);
                String attrName = attribNode.getNodeName();
                String attrValue = attribNode.getNodeValue();
                this.addAttribute(attrName, attrValue);
            }
        }
    }

    protected String toString(String tag) {
        DocumentImpl doc = new DocumentImpl();
        Element elm = this.toXML((Document)doc, tag);
        doc.appendChild(elm);
        return DOMUtils.toString((Document)doc);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object o) {
        SimpleXMLElement other = (SimpleXMLElement)o;
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.tag == null && other.tag != null) {
            return false;
        }
        if (this.tag != null && !this.tag.equals(other.tag)) {
            return false;
        }
        if (this.value == null && other.value != null) {
            return false;
        }
        if (this.value != null && !this.value.equals(other.value)) {
            return false;
        }
        if (this.attributes == null && other.attributes != null) {
            return false;
        }
        return this.attributes == null || this.attributes.equals(other.attributes);
    }

    public int hashCode() {
        int h = 1;
        if (this.tag != null) {
            h *= this.tag.hashCode();
        }
        if (this.value != null) {
            h *= this.value.hashCode();
        }
        if (this.attributes != null) {
            h *= this.attributes.hashCode();
        }
        return h;
    }

    public String toString() {
        DocumentImpl doc = new DocumentImpl();
        Element elm = this.toXML((Document)doc);
        doc.appendChild(elm);
        return DOMUtils.toString((Document)doc);
    }
}

