/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.security.logging.filter;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.AbstractMatcherFilter;
import ch.qos.logback.core.spi.FilterReply;
import java.util.ArrayList;
import java.util.List;
import org.owasp.security.logging.SecurityMarkers;
import org.slf4j.Marker;

public class SecurityMarkerFilter
extends AbstractMatcherFilter<ILoggingEvent> {
    public static final List<Marker> markersToMatch = new ArrayList<Marker>(3);
    private boolean acceptAll = false;

    public FilterReply decide(ILoggingEvent event) {
        if (!this.isStarted()) {
            return FilterReply.NEUTRAL;
        }
        Marker eventMarker = event.getMarker();
        if (eventMarker == null) {
            return FilterReply.DENY;
        }
        if (eventMarker.hasReferences()) {
            for (Marker marker : markersToMatch) {
                if (!eventMarker.contains(marker)) continue;
                return this.acceptAll ? FilterReply.ACCEPT : FilterReply.NEUTRAL;
            }
        } else if (markersToMatch.contains(eventMarker)) {
            return this.acceptAll ? FilterReply.ACCEPT : FilterReply.NEUTRAL;
        }
        return FilterReply.DENY;
    }

    public void setAcceptAll(String input) {
        if (input != null) {
            this.acceptAll = Boolean.valueOf(input);
        }
    }

    static {
        markersToMatch.add(SecurityMarkers.SECURITY_SUCCESS);
        markersToMatch.add(SecurityMarkers.SECURITY_FAILURE);
        markersToMatch.add(SecurityMarkers.SECURITY_AUDIT);
    }
}

