/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.security.logging.layout;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.LayoutBase;
import org.slf4j.MDC;

public class SecurityLoggingLayout
extends LayoutBase<ILoggingEvent> {
    private static final String LINE_SEP = System.getProperty("line.separator");
    private String prefix = "Security";

    public String doLayout(ILoggingEvent event) {
        StringBuilder sbuf = new StringBuilder(128);
        if (this.prefix != null) {
            sbuf.append(this.prefix).append(": ");
        }
        sbuf.append(event.getTimeStamp() - event.getLoggerContextVO().getBirthTime());
        sbuf.append(' ');
        sbuf.append(event.getLevel());
        sbuf.append(' ');
        sbuf.append(event.getMarker());
        sbuf.append(' ');
        sbuf.append(event.getLoggerName());
        sbuf.append(" - ");
        sbuf.append(MDC.get((String)"username"));
        sbuf.append('@');
        sbuf.append(MDC.get((String)"ipAddress"));
        sbuf.append(' ');
        sbuf.append(event.getFormattedMessage());
        sbuf.append(LINE_SEP);
        return sbuf.toString();
    }
}

