/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.springframework.web;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.JEEContext;
import org.pac4j.core.context.JEEContextFactory;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.WebContextFactory;
import org.pac4j.core.context.session.JEESessionStore;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.engine.DefaultLogoutLogic;
import org.pac4j.core.engine.LogoutLogic;
import org.pac4j.core.http.adapter.HttpActionAdapter;
import org.pac4j.core.http.adapter.JEEHttpActionAdapter;
import org.pac4j.core.util.FindBest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class LogoutController {
    private LogoutLogic<Object, JEEContext> logoutLogic;
    @Value(value="${pac4j.logout.defaultUrl:#{null}}")
    private String defaultUrl;
    @Value(value="${pac4j.logout.logoutUrlPattern:#{null}}")
    private String logoutUrlPattern;
    @Value(value="${pac4j.logout.localLogout:#{null}}")
    private Boolean localLogout;
    @Value(value="${pac4j.logout.destroySession:#{null}}")
    private Boolean destroySession;
    @Value(value="${pac4j.logout.centralLogout:#{null}}")
    private Boolean centralLogout;
    @Autowired
    private Config config;

    @RequestMapping(value={"${pac4j.logout.path:/logout}"})
    public void logout(HttpServletRequest request, HttpServletResponse response) {
        SessionStore bestSessionStore = FindBest.sessionStore(null, (Config)this.config, (SessionStore)JEESessionStore.INSTANCE);
        HttpActionAdapter bestAdapter = FindBest.httpActionAdapter(null, (Config)this.config, (HttpActionAdapter)JEEHttpActionAdapter.INSTANCE);
        LogoutLogic bestLogic = FindBest.logoutLogic(this.logoutLogic, (Config)this.config, (LogoutLogic)DefaultLogoutLogic.INSTANCE);
        JEEContext context = (JEEContext)FindBest.webContextFactory(null, (Config)this.config, (WebContextFactory)JEEContextFactory.INSTANCE).newContext(new Object[]{request, response, bestSessionStore});
        bestLogic.perform((WebContext)context, this.config, bestAdapter, this.defaultUrl, this.logoutUrlPattern, this.localLogout, this.destroySession, this.centralLogout);
    }

    public String getDefaultUrl() {
        return this.defaultUrl;
    }

    public void setDefaultUrl(String defaultUrl) {
        this.defaultUrl = defaultUrl;
    }

    public String getLogoutUrlPattern() {
        return this.logoutUrlPattern;
    }

    public void setLogoutUrlPattern(String logoutUrlPattern) {
        this.logoutUrlPattern = logoutUrlPattern;
    }

    public LogoutLogic<Object, JEEContext> getLogoutLogic() {
        return this.logoutLogic;
    }

    public void setLogoutLogic(LogoutLogic<Object, JEEContext> logoutLogic) {
        this.logoutLogic = logoutLogic;
    }

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public Boolean getLocalLogout() {
        return this.localLogout;
    }

    public void setLocalLogout(Boolean localLogout) {
        this.localLogout = localLogout;
    }

    public Boolean getCentralLogout() {
        return this.centralLogout;
    }

    public void setCentralLogout(Boolean centralLogout) {
        this.centralLogout = centralLogout;
    }

    public Boolean getDestroySession() {
        return this.destroySession;
    }

    public void setDestroySession(Boolean destroySession) {
        this.destroySession = destroySession;
    }
}

