/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.aggregate;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.pitest.aggregate.ReportAggregationException;

abstract class DataLoader<T> {
    private static final String CANNOT_CLOSE_ERR = "Unable to close input stream";
    private final Set<File> filesToLoad;

    protected DataLoader(Collection<File> filesToLoad) {
        if (filesToLoad == null || filesToLoad.isEmpty()) {
            throw new IllegalArgumentException("Null or empty filesToLoad");
        }
        this.filesToLoad = Collections.unmodifiableSet(new HashSet<File>(filesToLoad));
    }

    public Set<T> loadData() throws ReportAggregationException {
        HashSet<T> data = new HashSet<T>();
        for (File file : this.filesToLoad) {
            data.addAll(this.loadData(file));
        }
        return data;
    }

    protected abstract Set<T> mapToData(XMLEventReader var1) throws XMLStreamException;

    Set<T> loadData(File dataLocation) throws ReportAggregationException {
        if (!dataLocation.exists() || !dataLocation.isFile()) {
            throw new ReportAggregationException(dataLocation.getAbsolutePath() + " does not exist or is not a file");
        }
        try {
            return this.loadData(new BufferedInputStream(new FileInputStream(dataLocation)), dataLocation);
        }
        catch (FileNotFoundException e) {
            throw new ReportAggregationException("Could not read file: " + dataLocation.getAbsolutePath(), e);
        }
    }

    Set<T> loadData(InputStream inputStream, File dataLocation) throws ReportAggregationException {
        try {
            XMLEventReader doc = XMLInputFactory.newInstance().createXMLEventReader(inputStream);
            Set<T> set = this.mapToData(doc);
            return set;
        }
        catch (XMLStreamException e) {
            throw new ReportAggregationException("Could not parse file: " + dataLocation.getAbsolutePath(), e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new ReportAggregationException(CANNOT_CLOSE_ERR, e);
                }
            }
        }
    }
}

