/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.aggregate;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.pitest.aggregate.BlockCoverageDataLoader;
import org.pitest.aggregate.CodeSourceAggregator;
import org.pitest.aggregate.DataLoader;
import org.pitest.aggregate.MutationResultDataLoader;
import org.pitest.aggregate.ReportAggregationException;
import org.pitest.classinfo.ClassByteArraySource;
import org.pitest.classpath.CodeSource;
import org.pitest.coverage.BlockCoverage;
import org.pitest.coverage.BlockLocation;
import org.pitest.coverage.CoverageData;
import org.pitest.coverage.LineMap;
import org.pitest.coverage.ReportCoverage;
import org.pitest.coverage.TestInfo;
import org.pitest.coverage.analysis.LineMapper;
import org.pitest.functional.FCollection;
import org.pitest.mutationtest.ClassMutationResults;
import org.pitest.mutationtest.MutationMetaData;
import org.pitest.mutationtest.MutationResult;
import org.pitest.mutationtest.MutationResultListener;
import org.pitest.mutationtest.SourceLocator;
import org.pitest.mutationtest.report.html.MutationHtmlReportListener;
import org.pitest.mutationtest.tooling.SmartSourceLocator;
import org.pitest.util.Log;
import org.pitest.util.ResultOutputStrategy;

public final class ReportAggregator {
    private final ResultOutputStrategy resultOutputStrategy;
    private final DataLoader<BlockCoverage> blockCoverageLoader;
    private final DataLoader<MutationResult> mutationLoader;
    private final Collection<File> sourceCodeDirectories;
    private final CodeSourceAggregator codeSourceAggregator;

    private ReportAggregator(ResultOutputStrategy resultOutputStrategy, Set<File> lineCoverageFiles, Set<File> mutationFiles, Set<File> sourceCodeDirs, Set<File> compiledCodeDirs) {
        this.resultOutputStrategy = resultOutputStrategy;
        this.blockCoverageLoader = new BlockCoverageDataLoader(lineCoverageFiles);
        this.mutationLoader = new MutationResultDataLoader(mutationFiles);
        this.sourceCodeDirectories = Collections.unmodifiableCollection(new HashSet<File>(sourceCodeDirs));
        this.codeSourceAggregator = new CodeSourceAggregator(new HashSet<File>(compiledCodeDirs));
    }

    public void aggregateReport() throws ReportAggregationException {
        MutationMetaData mutationMetaData = new MutationMetaData(new ArrayList<MutationResult>(this.mutationLoader.loadData()));
        MutationResultListener mutationResultListener = this.createResultListener(mutationMetaData);
        mutationResultListener.runStart();
        for (ClassMutationResults mutationResults : mutationMetaData.toClassResults()) {
            mutationResultListener.handleMutationResult(mutationResults);
        }
        mutationResultListener.runEnd();
    }

    private MutationResultListener createResultListener(MutationMetaData mutationMetaData) throws ReportAggregationException {
        SmartSourceLocator sourceLocator = new SmartSourceLocator(this.sourceCodeDirectories);
        CodeSource codeSource = this.codeSourceAggregator.createCodeSource();
        ReportCoverage coverageDatabase = this.calculateCoverage(codeSource);
        HashSet mutatorNames = new HashSet(FCollection.flatMap((Iterable)mutationMetaData.getMutations(), ReportAggregator.resultToMutatorName()));
        return new MutationHtmlReportListener(coverageDatabase, this.resultOutputStrategy, mutatorNames, new SourceLocator[]{sourceLocator});
    }

    private static Function<MutationResult, List<String>> resultToMutatorName() {
        return a -> {
            try {
                String mutatorName = a.getDetails().getId().getMutator();
                return Collections.singletonList(mutatorName);
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot convert to mutator: " + a.getDetails().getMutator(), e);
            }
        };
    }

    private ReportCoverage calculateCoverage(CodeSource codeSource) throws ReportAggregationException {
        try {
            Collection coverageData = this.blockCoverageLoader.loadData().stream().map(BlockCoverage::getBlock).collect(Collectors.toList());
            CoverageData cd = new CoverageData(codeSource, (LineMap)new LineMapper((ClassByteArraySource)codeSource));
            cd.loadBlockDataOnly(coverageData);
            return cd;
        }
        catch (Exception e) {
            throw new ReportAggregationException(e.getMessage(), e);
        }
    }

    private Map<TestInfo, Collection<BlockLocation>> blocksToMap(Collection<BlockCoverage> coverageData) {
        HashMap<TestInfo, Collection<BlockLocation>> blockCoverageMap = new HashMap<TestInfo, Collection<BlockLocation>>();
        for (BlockCoverage blockData : coverageData) {
            List tests = blockData.getTests().stream().map(this.toTestInfo(blockData)).collect(Collectors.toList());
            for (TestInfo each : tests) {
                Collection collection = blockCoverageMap.computeIfAbsent(each, k -> new ArrayList());
                collection.add(blockData.getBlock());
            }
        }
        return blockCoverageMap;
    }

    private Function<String, TestInfo> toTestInfo(BlockCoverage blockData) {
        return a -> new TestInfo(null, a, 0, Optional.ofNullable(blockData.getBlock().getLocation().getClassName()), blockData.getBlock().getBlock());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private static final Logger LOG = Log.getLogger();
        private ResultOutputStrategy resultOutputStrategy;
        private final Set<File> lineCoverageFiles = new HashSet<File>();
        private final Set<File> mutationResultsFiles = new HashSet<File>();
        private final Set<File> sourceCodeDirectories = new HashSet<File>();
        private final Set<File> compiledCodeDirectories = new HashSet<File>();

        public Builder resultOutputStrategy(ResultOutputStrategy resultOutputStrategy) {
            this.resultOutputStrategy = resultOutputStrategy;
            return this;
        }

        public Builder lineCoverageFiles(List<File> lineCoverageFiles) {
            this.lineCoverageFiles.clear();
            for (File file : lineCoverageFiles) {
                this.addLineCoverageFile(file);
            }
            return this;
        }

        public Builder addLineCoverageFile(File lineCoverageFile) {
            this.validateFile(lineCoverageFile);
            this.lineCoverageFiles.add(lineCoverageFile);
            return this;
        }

        public Builder mutationResultsFiles(List<File> mutationResultsFiles) {
            this.mutationResultsFiles.clear();
            for (File file : mutationResultsFiles) {
                this.addMutationResultsFile(file);
            }
            return this;
        }

        public Builder addMutationResultsFile(File mutationResultsFile) {
            this.validateFile(mutationResultsFile);
            this.mutationResultsFiles.add(mutationResultsFile);
            return this;
        }

        public Builder sourceCodeDirectories(List<File> sourceCodeDirectories) {
            this.sourceCodeDirectories.clear();
            for (File file : sourceCodeDirectories) {
                this.addSourceCodeDirectory(file);
            }
            return this;
        }

        public Builder addSourceCodeDirectory(File sourceCodeDirectory) {
            this.validateDirectory(sourceCodeDirectory);
            if (sourceCodeDirectory.exists()) {
                this.sourceCodeDirectories.add(sourceCodeDirectory);
            } else {
                LOG.info("ignoring absent source code directory " + sourceCodeDirectory.getAbsolutePath());
            }
            return this;
        }

        public Builder compiledCodeDirectories(List<File> compiledCodeDirectories) {
            this.compiledCodeDirectories.clear();
            for (File file : compiledCodeDirectories) {
                this.addCompiledCodeDirectory(file);
            }
            return this;
        }

        public Builder addCompiledCodeDirectory(File compiledCodeDirectory) {
            this.validateDirectory(compiledCodeDirectory);
            if (compiledCodeDirectory.exists()) {
                this.compiledCodeDirectories.add(compiledCodeDirectory);
            } else {
                LOG.info("ignoring absent compiled code directory " + compiledCodeDirectory.getAbsolutePath());
            }
            return this;
        }

        public Set<File> getCompiledCodeDirectories() {
            return this.compiledCodeDirectories;
        }

        public Set<File> getLineCoverageFiles() {
            return this.lineCoverageFiles;
        }

        public Set<File> getMutationResultsFiles() {
            return this.mutationResultsFiles;
        }

        public Set<File> getSourceCodeDirectories() {
            return this.sourceCodeDirectories;
        }

        public ReportAggregator build() {
            this.validateState();
            return new ReportAggregator(this.resultOutputStrategy, this.lineCoverageFiles, this.mutationResultsFiles, this.sourceCodeDirectories, this.compiledCodeDirectories);
        }

        private void validateState() {
            if (this.resultOutputStrategy == null) {
                throw new IllegalStateException("Failed to build: the resultOutputStrategy has not been set");
            }
            if (this.lineCoverageFiles.isEmpty()) {
                throw new IllegalStateException("Failed to build: no lineCoverageFiles have been set");
            }
            if (this.mutationResultsFiles.isEmpty()) {
                throw new IllegalStateException("Failed to build: no mutationResultsFiles have been set");
            }
            if (this.sourceCodeDirectories.isEmpty()) {
                throw new IllegalStateException("Failed to build: no sourceCodeDirectories have been set");
            }
            if (this.compiledCodeDirectories.isEmpty()) {
                throw new IllegalStateException("Failed to build: no compiledCodeDirectories have been set");
            }
        }

        private void validateFile(File file) {
            if (file == null) {
                throw new IllegalArgumentException("file is null");
            }
            if (!file.exists() || !file.isFile()) {
                throw new IllegalArgumentException(file.getAbsolutePath() + " does not exist or is not a file");
            }
        }

        private void validateDirectory(File directory) {
            if (directory == null) {
                throw new IllegalArgumentException("directory is null");
            }
            if (directory.exists() && !directory.isDirectory()) {
                throw new IllegalArgumentException(directory.getAbsolutePath() + " is not a directory");
            }
        }
    }
}

