/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.verify;

import java.util.List;
import java.util.stream.Collectors;
import org.pitest.mutationtest.verify.BuildMessage;
import org.pitest.mutationtest.verify.BuildVerifier;
import org.pitest.mutationtest.verify.BuildVerifierArguments;
import org.pitest.mutationtest.verify.BuildVerifierFactory;

public class CompoundBuildVerifierFactory
implements BuildVerifierFactory {
    List<BuildVerifierFactory> verifiers;

    public CompoundBuildVerifierFactory(List<BuildVerifierFactory> verifiers) {
        this.verifiers = verifiers;
    }

    @Override
    public BuildVerifier create(BuildVerifierArguments args) {
        final List issues = this.verifiers.stream().map(f -> f.create(args)).flatMap(v -> v.verifyBuild().stream()).collect(Collectors.toList());
        return new BuildVerifier(){

            @Override
            public List<BuildMessage> verifyBuild() {
                return issues;
            }
        };
    }

    public String description() {
        return "Build Verifier";
    }
}

