/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.classinfo;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Objects;
import org.pitest.classinfo.ClassIdentifier;
import org.pitest.classinfo.ClassName;

public final class HierarchicalClassId
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ClassIdentifier classId;
    private final String hierarchicalHash;

    public HierarchicalClassId(ClassIdentifier classId, String hierarchicalHash) {
        this.classId = classId;
        this.hierarchicalHash = hierarchicalHash;
    }

    public HierarchicalClassId(ClassIdentifier id, BigInteger deepHash) {
        this(id, deepHash.toString(16));
    }

    public HierarchicalClassId(long hash, ClassName name, String hierarchicalHash) {
        this(new ClassIdentifier(hash, name), hierarchicalHash);
    }

    public String getHierarchicalHash() {
        return this.hierarchicalHash;
    }

    public ClassName getName() {
        return this.classId.getName();
    }

    public ClassIdentifier getId() {
        return this.classId;
    }

    public String toString() {
        return "HierarchicalClassId [classId=" + String.valueOf(this.classId) + ", hierarchicalHash=" + this.hierarchicalHash + "]";
    }

    public int hashCode() {
        return Objects.hash(this.classId, this.hierarchicalHash);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HierarchicalClassId other = (HierarchicalClassId)obj;
        return Objects.equals(this.classId, other.classId) && Objects.equals(this.hierarchicalHash, other.hierarchicalHash);
    }
}

