/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.execute;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.HashMap;
import org.pitest.mutationtest.MutationStatusMap;
import org.pitest.mutationtest.MutationStatusTestPair;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.mutationtest.execute.MinionArguments;
import org.pitest.mutationtest.execute.MutationTestCommunicationThread;
import org.pitest.mutationtest.execute.MutationTestMinion;
import org.pitest.process.ProcessArgs;
import org.pitest.process.WrappingProcess;
import org.pitest.util.ExitCode;

public class MutationTestProcess {
    private final WrappingProcess process;
    private final MutationTestCommunicationThread thread;

    public MutationTestProcess(ServerSocket socket, ProcessArgs processArgs, MinionArguments arguments) {
        this.process = new WrappingProcess(socket.getLocalPort(), processArgs, MutationTestMinion.class);
        this.thread = new MutationTestCommunicationThread(socket, arguments, new HashMap<MutationIdentifier, MutationStatusTestPair>());
    }

    public void start() throws IOException, InterruptedException {
        this.thread.start();
        this.process.start();
    }

    public void results(MutationStatusMap allmutations) throws IOException {
        for (MutationDetails each : allmutations.allMutations()) {
            MutationStatusTestPair status = this.thread.getStatus(each.getId());
            if (status == null) continue;
            allmutations.setStatusForMutation(each, status);
        }
    }

    public ExitCode waitToDie() {
        try {
            ExitCode exitCode = this.thread.waitToFinish();
            return exitCode;
        }
        finally {
            this.process.destroy();
        }
    }
}

