/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.maven;

import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.logging.Handler;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.pitest.coverage.CoverageSummary;
import org.pitest.maven.DependencyFilter;
import org.pitest.maven.GoalStrategy;
import org.pitest.maven.MojoToReportOptionsConverter;
import org.pitest.maven.NonEmptyProjectCheck;
import org.pitest.maven.RunPitStrategy;
import org.pitest.maven.SurefireConfigConverter;
import org.pitest.mutationtest.config.PluginServices;
import org.pitest.mutationtest.config.ReportOptions;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.statistics.MutationStatistics;
import org.pitest.mutationtest.tooling.CombinedStatistics;
import org.pitest.plugin.ToolClasspathPlugin;
import org.slf4j.bridge.SLF4JBridgeHandler;
import uk.org.lidalia.sysoutslf4j.context.SysOutOverSLF4J;

public class AbstractPitMojo
extends AbstractMojo {
    private final Predicate<MavenProject> notEmptyProject;
    private final Predicate<Artifact> filter;
    private final PluginServices plugins;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(property="targetClasses")
    private ArrayList<String> targetClasses;
    @Parameter(property="targetTests")
    private ArrayList<String> targetTests;
    @Parameter(property="excludedMethods")
    private ArrayList<String> excludedMethods;
    @Parameter(property="excludedClasses")
    private ArrayList<String> excludedClasses;
    @Parameter(property="excludedTestClasses")
    private ArrayList<String> excludedTestClasses;
    @Parameter(property="avoidCallsTo")
    private ArrayList<String> avoidCallsTo;
    @Parameter(defaultValue="${project.build.directory}/pit-reports", property="reportsDirectory")
    private File reportsDirectory;
    @Parameter(property="historyOutputFile")
    private File historyOutputFile;
    @Parameter(property="historyInputFile")
    private File historyInputFile;
    @Parameter(defaultValue="false", property="withHistory")
    private boolean withHistory;
    @Parameter(defaultValue="1", property="threads")
    private int threads;
    @Parameter(defaultValue="true", property="detectInlinedCode")
    private boolean detectInlinedCode;
    @Parameter(property="mutators")
    private ArrayList<String> mutators;
    @Parameter(property="features")
    private ArrayList<String> features;
    @Parameter(property="extraFeatures")
    private ArrayList<String> extraFeatures;
    @Parameter(defaultValue="1.25", property="timeoutFactor")
    private float timeoutFactor;
    @Parameter(defaultValue="3000", property="timeoutConstant")
    private long timeoutConstant;
    @Parameter(defaultValue="-1", property="maxMutationsPerClass")
    private int maxMutationsPerClass;
    @Parameter(property="jvmArgs")
    private ArrayList<String> jvmArgs;
    @Parameter(property="argLine")
    private String argLine;
    @Parameter(property="outputFormats")
    private ArrayList<String> outputFormats;
    @Parameter(defaultValue="false", property="verbose")
    private boolean verbose;
    @Parameter(defaultValue="true", property="failWhenNoMutations")
    private boolean failWhenNoMutations;
    @Parameter(defaultValue="false", property="timestampedReports")
    private boolean timestampedReports;
    @Parameter(property="excludedGroups")
    private ArrayList<String> excludedGroups;
    @Parameter(property="includedGroups")
    private ArrayList<String> includedGroups;
    @Parameter(property="includedTestMethods")
    private ArrayList<String> includedTestMethods;
    @Parameter(property="fullMutationMatrix", defaultValue="false")
    private boolean fullMutationMatrix;
    @Parameter(property="mutationUnitSize")
    private int mutationUnitSize;
    @Parameter(defaultValue="false", property="exportLineCoverage")
    private boolean exportLineCoverage;
    @Parameter(defaultValue="0", property="mutationThreshold")
    private int mutationThreshold;
    @Parameter(defaultValue="0", property="testStrengthThreshold")
    private int testStrengthThreshold;
    @Parameter(defaultValue="-1", property="maxSurviving")
    private int maxSurviving = -1;
    @Parameter(defaultValue="0", property="coverageThreshold")
    private int coverageThreshold;
    @Parameter
    private String jvm;
    @Parameter(defaultValue="gregor", property="mutationEngine")
    private String mutationEngine;
    @Parameter(property="additionalClasspathElements")
    private ArrayList<String> additionalClasspathElements;
    @Parameter(property="classpathDependencyExcludes")
    private ArrayList<String> classpathDependencyExcludes;
    @Parameter(property="excludedRunners")
    private ArrayList<String> excludedRunners;
    @Parameter(property="skipPitest", defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="true")
    private boolean parseSurefireConfig;
    @Parameter(defaultValue="true")
    private boolean parseSurefireArgLine;
    @Parameter(property="skipTests", defaultValue="false")
    private boolean skipTests;
    @Parameter(defaultValue="false")
    private boolean skipFailingTests;
    @Parameter(defaultValue="false", property="useSlf4j")
    private boolean useSlf4j;
    @Parameter(property="pit.inputEncoding", defaultValue="${project.build.sourceEncoding}")
    private String inputEncoding;
    @Parameter(property="pit.outputEncoding", defaultValue="${project.reporting.outputEncoding}")
    private String outputEncoding;
    @Parameter(property="pit.additionalSources", defaultValue="src/main/kotlin")
    private List<File> additionalSources;
    @Parameter(property="pit.additionalTestSources", defaultValue="src/test/kotlin")
    private List<File> additionalTestSources;
    @Parameter(defaultValue="${session.executionRootDirectory}", property="projectBase")
    private String projectBase;
    @Parameter
    private Map<String, String> pluginConfiguration;
    @Parameter
    private Map<String, String> environmentVariables = new HashMap<String, String>();
    @Parameter(property="project", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="plugin.artifactMap", readonly=true, required=true)
    private Map<String, Artifact> pluginArtifactMap;
    @Parameter(property="useClasspathJar", defaultValue="false")
    private boolean useClasspathJar;
    @Parameter(property="verbosity", defaultValue="DEFAULT")
    private String verbosity;
    private final GoalStrategy goalStrategy;
    private final RepositorySystem repositorySystem;

    @Inject
    public AbstractPitMojo(RepositorySystem repositorySystem) {
        this(new RunPitStrategy(), new DependencyFilter(PluginServices.makeForLoader((ClassLoader)AbstractPitMojo.class.getClassLoader())), PluginServices.makeForLoader((ClassLoader)AbstractPitMojo.class.getClassLoader()), new NonEmptyProjectCheck(), repositorySystem);
    }

    public AbstractPitMojo(GoalStrategy strategy, Predicate<Artifact> filter, PluginServices plugins, Predicate<MavenProject> emptyProjectCheck, RepositorySystem repositorySystem) {
        this.goalStrategy = strategy;
        this.filter = filter;
        this.plugins = plugins;
        this.notEmptyProject = emptyProjectCheck;
        this.repositorySystem = repositorySystem;
    }

    public final void execute() throws MojoExecutionException, MojoFailureException {
        this.switchLogging();
        this.augmentConfig();
        RunDecision shouldRun = this.shouldRun();
        if (shouldRun.shouldRun()) {
            this.getLog().info((CharSequence)("Root dir is : " + this.projectBase));
            for (ToolClasspathPlugin each : this.plugins.findToolClasspathPlugins()) {
                this.getLog().info((CharSequence)("Found plugin : " + each.description()));
            }
            this.plugins.findClientClasspathPlugins().stream().filter(p -> !(p instanceof MethodMutatorFactory)).forEach(p -> this.getLog().info((CharSequence)("Found shared classpath plugin : " + p.description())));
            String operators = this.plugins.findMutationOperators().stream().map(m -> m.getName()).collect(Collectors.joining(","));
            this.getLog().info((CharSequence)("Available mutators : " + operators));
            Optional<CombinedStatistics> result = this.analyse();
            if (result.isPresent()) {
                this.throwErrorIfTestStrengthBelowThreshold(result.get().getMutationStatistics());
                this.throwErrorIfScoreBelowThreshold(result.get().getMutationStatistics());
                this.throwErrorIfMoreThanMaximumSurvivors(result.get().getMutationStatistics());
                this.throwErrorIfCoverageBelowThreshold(result.get().getCoverageSummary());
            }
        } else {
            this.getLog().info((CharSequence)"Skipping project because:");
            for (String reason : shouldRun.getReasons()) {
                this.getLog().info((CharSequence)("  - " + reason));
            }
        }
    }

    private void augmentConfig() {
        for (File source : this.emptyWithoutNulls(this.additionalSources)) {
            if (!source.exists() || this.project.getCompileSourceRoots().contains(source.getAbsolutePath())) continue;
            this.getLog().info((CharSequence)("Adding source root " + source));
            this.project.addCompileSourceRoot(source.getAbsolutePath());
        }
        for (File source : this.emptyWithoutNulls(this.additionalTestSources)) {
            if (!source.exists() || this.project.getTestCompileSourceRoots().contains(source.getAbsolutePath())) continue;
            this.getLog().info((CharSequence)("Adding test root " + source));
            this.project.addTestCompileSourceRoot(source.getAbsolutePath());
        }
    }

    private void switchLogging() {
        if (this.useSlf4j) {
            SLF4JBridgeHandler.removeHandlersForRootLogger();
            SLF4JBridgeHandler.install();
            Logger.getLogger("PIT").addHandler((Handler)new SLF4JBridgeHandler());
            SysOutOverSLF4J.sendSystemOutAndErrToSLF4J();
        }
    }

    private void throwErrorIfCoverageBelowThreshold(CoverageSummary coverageSummary) throws MojoFailureException {
        if (this.coverageThreshold != 0 && coverageSummary.getCoverage() < this.coverageThreshold) {
            throw new MojoFailureException("Line coverage of " + coverageSummary.getCoverage() + "(" + coverageSummary.getNumberOfCoveredLines() + "/" + coverageSummary.getNumberOfLines() + ") is below threshold of " + this.coverageThreshold);
        }
    }

    private void throwErrorIfScoreBelowThreshold(MutationStatistics result) throws MojoFailureException {
        if (this.mutationThreshold != 0 && result.getPercentageDetected() < this.mutationThreshold) {
            throw new MojoFailureException("Mutation score of " + result.getPercentageDetected() + " is below threshold of " + this.mutationThreshold);
        }
    }

    private void throwErrorIfTestStrengthBelowThreshold(MutationStatistics result) throws MojoFailureException {
        if (this.testStrengthThreshold != 0 && result.getTestStrength() < this.testStrengthThreshold) {
            throw new MojoFailureException("Test strength score of " + result.getTestStrength() + " is below threshold of " + this.testStrengthThreshold);
        }
    }

    private void throwErrorIfMoreThanMaximumSurvivors(MutationStatistics result) throws MojoFailureException {
        if (this.maxSurviving >= 0 && result.getTotalSurvivingMutations() > (long)this.maxSurviving) {
            throw new MojoFailureException("Had " + result.getTotalSurvivingMutations() + " surviving mutants, but only " + this.maxSurviving + " survivors allowed");
        }
    }

    protected Optional<CombinedStatistics> analyse() throws MojoExecutionException {
        ReportOptions data = new MojoToReportOptionsConverter(this, new SurefireConfigConverter(this.isParseSurefireArgLine()), this.filter).convert();
        data.getEnvironmentVariables().putAll(this.environmentVariables);
        return Optional.ofNullable(this.goalStrategy.execute(this.detectBaseDir(), data, this.plugins, data.getEnvironmentVariables()));
    }

    protected File detectBaseDir() {
        MavenProject executionProject = this.project.getExecutionProject();
        if (executionProject == null) {
            return null;
        }
        return executionProject.getBasedir();
    }

    protected Predicate<Artifact> getFilter() {
        return this.filter;
    }

    protected GoalStrategy getGoalStrategy() {
        return this.goalStrategy;
    }

    protected PluginServices getPlugins() {
        return this.plugins;
    }

    public List<String> getTargetClasses() {
        return this.withoutNulls(this.targetClasses);
    }

    public void setTargetClasses(ArrayList<String> targetClasses) {
        this.targetClasses = targetClasses;
    }

    public List<String> getTargetTests() {
        return this.withoutNulls(this.targetTests);
    }

    public void setTargetTests(ArrayList<String> targetTests) {
        this.targetTests = targetTests;
    }

    public List<String> getExcludedMethods() {
        return this.withoutNulls(this.excludedMethods);
    }

    public List<String> getExcludedClasses() {
        return this.withoutNulls(this.excludedClasses);
    }

    public List<String> getAvoidCallsTo() {
        return this.withoutNulls(this.avoidCallsTo);
    }

    public File getReportsDirectory() {
        return this.reportsDirectory;
    }

    public int getThreads() {
        return this.threads;
    }

    public List<String> getMutators() {
        return this.withoutNulls(this.mutators);
    }

    public float getTimeoutFactor() {
        return this.timeoutFactor;
    }

    public long getTimeoutConstant() {
        return this.timeoutConstant;
    }

    public ArrayList<String> getExcludedTestClasses() {
        return this.withoutNulls(this.excludedTestClasses);
    }

    public int getMaxMutationsPerClass() {
        return this.maxMutationsPerClass;
    }

    public List<String> getJvmArgs() {
        return this.withoutNulls(this.jvmArgs);
    }

    public String getArgLine() {
        return this.argLine;
    }

    public List<String> getOutputFormats() {
        return this.withoutNulls(this.outputFormats);
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public Map<String, Artifact> getPluginArtifactMap() {
        return this.pluginArtifactMap;
    }

    public boolean isFailWhenNoMutations() {
        return this.failWhenNoMutations;
    }

    public List<String> getExcludedGroups() {
        return this.withoutNulls(this.excludedGroups);
    }

    public List<String> getIncludedGroups() {
        return this.withoutNulls(this.includedGroups);
    }

    public List<String> getIncludedTestMethods() {
        return this.withoutNulls(this.includedTestMethods);
    }

    public boolean isFullMutationMatrix() {
        return this.fullMutationMatrix;
    }

    public int getMutationUnitSize() {
        return this.mutationUnitSize;
    }

    public boolean isTimestampedReports() {
        return this.timestampedReports;
    }

    public boolean isDetectInlinedCode() {
        return this.detectInlinedCode;
    }

    public void setTimestampedReports(boolean timestampedReports) {
        this.timestampedReports = timestampedReports;
    }

    public File getHistoryOutputFile() {
        return this.historyOutputFile;
    }

    public File getHistoryInputFile() {
        return this.historyInputFile;
    }

    public boolean isExportLineCoverage() {
        return this.exportLineCoverage;
    }

    public Charset getSourceEncoding() {
        if (this.inputEncoding != null) {
            return Charset.forName(this.inputEncoding);
        }
        return Charset.defaultCharset();
    }

    public Charset getOutputEncoding() {
        if (this.outputEncoding != null) {
            return Charset.forName(this.outputEncoding);
        }
        return Charset.defaultCharset();
    }

    protected RunDecision shouldRun() {
        RunDecision decision = new RunDecision();
        if (this.skip) {
            decision.addReason("Execution of PIT should be skipped.");
        }
        if (this.skipTests) {
            decision.addReason("Test execution should be skipped (-DskipTests).");
        }
        if ("pom".equalsIgnoreCase(this.project.getPackaging())) {
            decision.addReason("Packaging is POM.");
        }
        if (!this.notEmptyProject.test(this.project)) {
            decision.addReason("Project has either no tests or no production code.");
        }
        return decision;
    }

    public String getMutationEngine() {
        return this.mutationEngine;
    }

    public String getJavaExecutable() {
        return this.jvm;
    }

    public List<String> getAdditionalClasspathElements() {
        return this.withoutNulls(this.additionalClasspathElements);
    }

    public List<String> getClasspathDependencyExcludes() {
        return this.withoutNulls(this.classpathDependencyExcludes);
    }

    public boolean isParseSurefireConfig() {
        return this.parseSurefireConfig;
    }

    public boolean isParseSurefireArgLine() {
        return this.parseSurefireArgLine;
    }

    public boolean skipFailingTests() {
        return this.skipFailingTests;
    }

    public Map<String, String> getPluginProperties() {
        return this.pluginConfiguration;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public boolean useHistory() {
        return this.withHistory;
    }

    public ArrayList<String> getExcludedRunners() {
        return this.withoutNulls(this.excludedRunners);
    }

    public ArrayList<String> getFeatures() {
        ArrayList<String> consolidated = this.emptyWithoutNulls(this.features);
        consolidated.addAll(this.emptyWithoutNulls(this.extraFeatures));
        return consolidated;
    }

    public boolean isUseClasspathJar() {
        return this.useClasspathJar;
    }

    public String getVerbosity() {
        return this.verbosity;
    }

    public String getProjectBase() {
        return this.projectBase;
    }

    public MavenSession session() {
        return this.session;
    }

    public RepositorySystem repositorySystem() {
        return this.repositorySystem;
    }

    private <X> ArrayList<X> emptyWithoutNulls(List<X> originalList) {
        if (originalList == null) {
            return new ArrayList();
        }
        return this.withoutNulls(originalList);
    }

    private <X> ArrayList<X> withoutNulls(List<X> originalList) {
        if (originalList == null) {
            return null;
        }
        return originalList.stream().filter(Objects::nonNull).collect(Collectors.toCollection(ArrayList::new));
    }

    static class RunDecision {
        private List<String> reasons = new ArrayList<String>(4);

        RunDecision() {
        }

        boolean shouldRun() {
            return this.reasons.isEmpty();
        }

        public void addReason(String reason) {
            this.reasons.add(reason);
        }

        public List<String> getReasons() {
            return Collections.unmodifiableList(this.reasons);
        }
    }
}

